/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.event;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.event.factory.EventServiceFactory;

public class Event
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CREATE = 1;
    public static final int MODIFY = 2;
    public static final int MODIFY_METADATA = 4;
    public static final int ADD = 8;
    public static final int REMOVE = 16;
    public static final int DELETE = 32;
    public static final int INSTALL = 64;
    public static final int SUBJECT_MASK = 0;
    public static final int EVENT_MASK = 1;
    protected static final String[] eventTypeText = new String[]{"CREATE", "MODIFY", "MODIFY_METADATA", "ADD", "REMOVE", "DELETE", "INSTALL"};
    protected static final int NONE = 0;
    protected static final int BITSTREAM = 1;
    protected static final int BUNDLE = 2;
    protected static final int ITEM = 4;
    protected static final int COLLECTION = 8;
    protected static final int COMMUNITY = 16;
    protected static final int SITE = 32;
    protected static final int GROUP = 64;
    protected static final int EPERSON = 128;
    protected static final int ALL_OBJECTS_MASK = 255;
    protected static Map<Integer, Integer> objTypeToMask = new HashMap<Integer, Integer>();
    protected static Map<Integer, Integer> objMaskToType = new HashMap<Integer, Integer>();
    private int dispatcher;
    private int eventType;
    private int subjectType;
    private UUID subjectID;
    private int objectType = 0;
    private UUID objectID = null;
    private long timeStamp;
    private String detail;
    private ArrayList<String> identifiers;
    private String transactionID;
    private int currentUser = -1;
    private String extraLogInfo = null;
    private BitSet consumedBy = new BitSet();
    private static Logger log;

    public Event(int eventType, int subjectType, UUID subjectID, String detail) {
        this(eventType, subjectType, subjectID, detail, new ArrayList<String>());
    }

    public Event(int eventType, int subjectType, UUID subjectID, String detail, ArrayList<String> identifiers) {
        this.eventType = eventType;
        this.subjectType = this.coreTypeToMask(subjectType);
        this.subjectID = subjectID;
        this.timeStamp = System.currentTimeMillis();
        this.detail = detail;
        this.identifiers = (ArrayList)identifiers.clone();
    }

    public Event(int eventType, int subjectType, UUID subjectID, int objectType, UUID objectID, String detail) {
        this(eventType, subjectType, subjectID, objectType, objectID, detail, new ArrayList<String>());
    }

    public Event(int eventType, int subjectType, UUID subjectID, int objectType, UUID objectID, String detail, ArrayList<String> identifiers) {
        this.eventType = eventType;
        this.subjectType = this.coreTypeToMask(subjectType);
        this.subjectID = subjectID;
        this.objectType = this.coreTypeToMask(objectType);
        this.objectID = objectID;
        this.timeStamp = System.currentTimeMillis();
        this.detail = detail;
        this.identifiers = (ArrayList)identifiers.clone();
    }

    public boolean equals(Object other) {
        if (other instanceof Event) {
            Event otherEvent = (Event)other;
            return (this.detail == null ? otherEvent.detail == null : this.detail.equals(otherEvent.detail)) && this.eventType == otherEvent.eventType && this.subjectType == otherEvent.subjectType && this.subjectID == otherEvent.subjectID && this.objectType == otherEvent.objectType && this.objectID == otherEvent.objectID;
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.detail).append(this.eventType).append(this.subjectType).append((Object)this.subjectID).append(this.objectType).append((Object)this.objectID).toHashCode();
    }

    public void setDispatcher(int id) {
        this.dispatcher = id;
    }

    protected int coreTypeToMask(int core) {
        Integer mask = objTypeToMask.get(core);
        if (mask == null) {
            return -1;
        }
        return mask;
    }

    protected int maskTypeToCore(int mask) {
        Integer core = objMaskToType.get(mask);
        if (core == null) {
            return -1;
        }
        return core;
    }

    public DSpaceObject getObject(Context context) throws SQLException {
        int type = this.getObjectType();
        UUID id = this.getObjectID();
        if (type < 0 || id == null) {
            return null;
        }
        return ContentServiceFactory.getInstance().getDSpaceObjectService(type).find(context, id);
    }

    public DSpaceObject getSubject(Context context) throws SQLException {
        return ContentServiceFactory.getInstance().getDSpaceObjectService(this.getSubjectType()).find(context, this.getSubjectID());
    }

    public UUID getSubjectID() {
        return this.subjectID;
    }

    public UUID getObjectID() {
        return this.objectID;
    }

    public int getSubjectType() {
        return this.maskTypeToCore(this.subjectType);
    }

    public int getObjectType() {
        return this.maskTypeToCore(this.objectType);
    }

    public String getSubjectTypeAsString() {
        int i = this.log2(this.subjectType);
        if (i >= 0 && i < Constants.typeText.length) {
            return Constants.typeText[i];
        }
        return "(Unknown)";
    }

    public String getObjectTypeAsString() {
        int i = this.log2(this.objectType);
        if (i >= 0 && i < Constants.typeText.length) {
            return Constants.typeText[i];
        }
        return "(Unknown)";
    }

    public static int parseObjectType(String s) {
        if ("*".equals(s) || "all".equalsIgnoreCase(s)) {
            return 255;
        }
        int id = Constants.getTypeID(s.toUpperCase());
        if (id >= 0) {
            return 1 << id;
        }
        return 0;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getEventTypeAsString() {
        int i = this.log2(this.eventType);
        if (i >= 0 && i < eventTypeText.length) {
            return eventTypeText[i];
        }
        return "(Unknown)";
    }

    public static int parseEventType(String s) {
        if ("*".equals(s) || "all".equalsIgnoreCase(s)) {
            int result = 0;
            for (int i = 0; i < eventTypeText.length; ++i) {
                result |= 1 << i;
            }
            return result;
        }
        for (int i = 0; i < eventTypeText.length; ++i) {
            if (!eventTypeText[i].equalsIgnoreCase(s)) continue;
            return 1 << i;
        }
        return 0;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public int getDispatcher() {
        return this.dispatcher;
    }

    public String getDetail() {
        return this.detail;
    }

    public List<String> getIdentifiers() {
        return (List)this.identifiers.clone();
    }

    public String getTransactionID() {
        return this.transactionID;
    }

    public void setTransactionID(String tid) {
        this.transactionID = tid;
    }

    public void setCurrentUser(int uid) {
        this.currentUser = uid;
    }

    public int getCurrentUser() {
        return this.currentUser;
    }

    public void setExtraLogInfo(String info) {
        this.extraLogInfo = info;
    }

    public String getExtraLogInfo() {
        return this.extraLogInfo;
    }

    public boolean pass(List<int[]> filters) {
        boolean result = false;
        for (int[] filter : filters) {
            if ((this.subjectType & filter[0]) == 0 || (this.eventType & filter[1]) == 0) continue;
            result = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Filtering event: eventType=" + String.valueOf(this.eventType) + ", subjectType=" + String.valueOf(this.subjectType) + ", result=" + String.valueOf(result)));
        }
        return result;
    }

    protected int log2(int n) {
        for (int i = 0; i < 32; ++i) {
            if (n == 1) {
                return i;
            }
            n >>= 1;
        }
        return -1;
    }

    public void setBitSet(String consumerName) {
        this.consumedBy.set(EventServiceFactory.getInstance().getEventService().getConsumerIndex(consumerName));
    }

    public BitSet getBitSet() {
        return this.consumedBy;
    }

    public String toString() {
        return "org.dspace.event.Event(eventType=" + this.getEventTypeAsString() + ", SubjectType=" + this.getSubjectTypeAsString() + ", SubjectID=" + String.valueOf(this.subjectID) + ", ObjectType=" + this.getObjectTypeAsString() + ", ObjectID=" + String.valueOf(this.objectID) + ", TimeStamp=" + String.valueOf(this.timeStamp) + ", dispatcher=" + String.valueOf(this.dispatcher) + ", detail=" + (this.detail == null ? "[null]" : "\"" + this.detail + "\"") + ", transactionID=" + (this.transactionID == null ? "[null]" : "\"" + this.transactionID + "\"") + ")";
    }

    static {
        objTypeToMask.put(0, 1);
        objMaskToType.put(1, 0);
        objTypeToMask.put(1, 2);
        objMaskToType.put(2, 1);
        objTypeToMask.put(2, 4);
        objMaskToType.put(4, 2);
        objTypeToMask.put(3, 8);
        objMaskToType.put(8, 3);
        objTypeToMask.put(4, 16);
        objMaskToType.put(16, 4);
        objTypeToMask.put(5, 32);
        objMaskToType.put(32, 5);
        objTypeToMask.put(6, 64);
        objMaskToType.put(64, 6);
        objTypeToMask.put(7, 128);
        objMaskToType.put(128, 7);
        log = Logger.getLogger(Event.class);
    }
}

