/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.flywaydb.core.api.FlywayException;

public class PostgresUtils {
    public static final String PGCRYPTO = "pgcrypto";
    public static final Double PGCRYPTO_VERSION = 1.1;
    public static final Double POSTGRES_VERSION = 9.4;

    protected static Double getPgcryptoAvailableVersion(Connection connection) {
        Double version = null;
        String checkPgCryptoAvailable = "SELECT default_version AS version FROM pg_available_extensions WHERE name=?";
        try (PreparedStatement statement = connection.prepareStatement(checkPgCryptoAvailable);){
            statement.setString(1, PGCRYPTO);
            try (ResultSet results = statement.executeQuery();){
                if (results.next()) {
                    version = results.getDouble("version");
                }
            }
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to determine whether 'pgcrypto' extension is available.", (Throwable)e);
        }
        return version;
    }

    protected static Double getPgcryptoInstalledVersion(Connection connection) {
        Double version = null;
        String checkPgCryptoInstalled = "SELECT extversion AS version FROM pg_extension WHERE extname=?";
        try (PreparedStatement statement = connection.prepareStatement(checkPgCryptoInstalled);){
            statement.setString(1, PGCRYPTO);
            try (ResultSet results = statement.executeQuery();){
                if (results.next()) {
                    version = results.getDouble("version");
                }
            }
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to determine whether 'pgcrypto' extension is installed.", (Throwable)e);
        }
        return version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPgcryptoUpToDate() {
        DataSource dataSource = DatabaseUtils.getDataSource();
        try (Connection connection = dataSource.getConnection();){
            Double pgcryptoInstalled = PostgresUtils.getPgcryptoInstalledVersion(connection);
            if (pgcryptoInstalled != null && pgcryptoInstalled.compareTo(PGCRYPTO_VERSION) >= 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to determine whether 'pgcrypto' extension is up-to-date.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPgcryptoInSchema(String schema) {
        DataSource dataSource = DatabaseUtils.getDataSource();
        try (Connection connection = dataSource.getConnection();){
            String pgcryptoInstalledInSchema = "SELECT extversion FROM pg_extension,pg_namespace WHERE pg_extension.extnamespace=pg_namespace.oid AND extname=? AND nspname=?;";
            Double pgcryptoVersion = null;
            try (PreparedStatement statement = connection.prepareStatement(pgcryptoInstalledInSchema);){
                statement.setString(1, PGCRYPTO);
                statement.setString(2, schema);
                try (ResultSet results = statement.executeQuery();){
                    if (results.next()) {
                        pgcryptoVersion = results.getDouble("extversion");
                    }
                }
            }
            if (pgcryptoVersion != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to determine whether 'pgcrypto' extension is installed in schema '" + schema + "'.", (Throwable)e);
        }
    }

    protected static boolean checkCleanPermissions(Connection connection) {
        try {
            String username = connection.getMetaData().getUserName();
            String checkSuperuser = "SELECT rolsuper FROM pg_roles WHERE rolname=?;";
            boolean superuser = false;
            try (PreparedStatement statement = connection.prepareStatement(checkSuperuser);){
                statement.setString(1, username);
                try (ResultSet results = statement.executeQuery();){
                    if (results.next()) {
                        superuser = results.getBoolean("rolsuper");
                    }
                }
            }
            catch (SQLException e) {
                throw new FlywayException("Unable to determine if user '" + username + "' is a superuser.", (Throwable)e);
            }
            if (superuser) {
                return true;
            }
            String schema = DatabaseUtils.getSchemaName(connection);
            return !PostgresUtils.isPgcryptoInSchema(schema);
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to determine if DB user has 'clean' privileges.", (Throwable)e);
        }
    }
}

