/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.services.factory.DSpaceServicesFactory;

public class PasswordAuthentication
implements AuthenticationMethod {
    private static Logger log = Logger.getLogger(PasswordAuthentication.class);

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String email) throws SQLException {
        String[] domains = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("authentication-password.domain.valid");
        if (domains == null || domains.length == 0) {
            return true;
        }
        email = email.trim().toLowerCase();
        for (int i = 0; i < domains.length; ++i) {
            String check = domains[i].trim().toLowerCase();
            if (!email.endsWith(check)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return true;
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public List<Group> getSpecialGroups(Context context, HttpServletRequest request) {
        try {
            String groupName;
            if (context.getCurrentUser() != null && StringUtils.isNotBlank((CharSequence)EPersonServiceFactory.getInstance().getEPersonService().getPasswordHash(context.getCurrentUser()).toString()) && (groupName = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("authentication-password.login.specialgroup")) != null && !groupName.trim().equals("")) {
                Group specialGroup = EPersonServiceFactory.getInstance().getGroupService().findByName(context, groupName);
                if (specialGroup == null) {
                    log.warn((Object)LogManager.getHeader(context, "password_specialgroup", "Group defined in modules/authentication-password.cfg login.specialgroup does not exist"));
                    return ListUtils.EMPTY_LIST;
                }
                return Arrays.asList(specialGroup);
            }
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "getSpecialGroups", ""), (Throwable)e);
        }
        return ListUtils.EMPTY_LIST;
    }

    @Override
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        if (username != null && password != null) {
            EPerson eperson = null;
            log.info((Object)LogManager.getHeader(context, "authenticate", "attempting password auth of user=" + username));
            eperson = EPersonServiceFactory.getInstance().getEPersonService().findByEmail(context, username.toLowerCase());
            if (eperson == null) {
                return 4;
            }
            if (!eperson.canLogIn()) {
                return 5;
            }
            if (eperson.getRequireCertificate()) {
                log.warn((Object)LogManager.getHeader(context, "authenticate", "rejecting PasswordAuthentication because " + username + " requires certificate."));
                return 3;
            }
            if (EPersonServiceFactory.getInstance().getEPersonService().checkPassword(context, eperson, password)) {
                context.setCurrentUser(eperson);
                log.info((Object)LogManager.getHeader(context, "authenticate", "type=PasswordAuthentication"));
                return 1;
            }
            return 2;
        }
        return 5;
    }

    @Override
    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        return response.encodeRedirectURL(request.getContextPath() + "/password-login");
    }

    @Override
    public String loginPageTitle(Context context) {
        return "org.dspace.eperson.PasswordAuthentication.title";
    }
}

