/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;
import org.dspace.checker.BitstreamDispatcher;
import org.dspace.checker.ChecksumResult;
import org.dspace.checker.ChecksumResultCode;
import org.dspace.checker.ChecksumResultsCollector;
import org.dspace.checker.MostRecentChecksum;
import org.dspace.checker.ResultsLogger;
import org.dspace.checker.factory.CheckerServiceFactory;
import org.dspace.checker.service.ChecksumHistoryService;
import org.dspace.checker.service.ChecksumResultService;
import org.dspace.checker.service.MostRecentChecksumService;
import org.dspace.content.Bitstream;
import org.dspace.core.Context;
import org.dspace.storage.bitstore.factory.StorageServiceFactory;
import org.dspace.storage.bitstore.service.BitstreamStorageService;

public final class CheckerCommand {
    private static final Logger LOG = Logger.getLogger(CheckerCommand.class);
    private Context context;
    private MostRecentChecksumService checksumService = CheckerServiceFactory.getInstance().getMostRecentChecksumService();
    private ChecksumHistoryService checksumHistoryService = CheckerServiceFactory.getInstance().getChecksumHistoryService();
    private BitstreamStorageService bitstreamStorageService = StorageServiceFactory.getInstance().getBitstreamStorageService();
    private ChecksumResultService checksumResultService = CheckerServiceFactory.getInstance().getChecksumResultService();
    private Date processStartDate = null;
    private BitstreamDispatcher dispatcher = null;
    private ChecksumResultsCollector collector = null;
    private boolean reportVerbose = false;

    public CheckerCommand(Context context) {
        this.context = context;
    }

    public void process() throws SQLException {
        LOG.debug((Object)"Begin Checker Processing");
        if (this.dispatcher == null) {
            throw new IllegalStateException("No BitstreamDispatcher provided");
        }
        if (this.collector == null) {
            this.collector = new ResultsLogger(this.processStartDate);
        }
        this.checksumService.updateMissingBitstreams(this.context);
        Bitstream bitstream = this.dispatcher.next();
        while (bitstream != null) {
            LOG.debug((Object)("Processing bitstream id = " + bitstream.getID()));
            MostRecentChecksum info = this.checkBitstream(bitstream);
            if (this.reportVerbose || !ChecksumResultCode.CHECKSUM_MATCH.equals((Object)info.getChecksumResult().getResultCode())) {
                this.collector.collect(this.context, info);
            }
            bitstream = this.dispatcher.next();
        }
    }

    protected MostRecentChecksum checkBitstream(Bitstream bitstream) throws SQLException {
        MostRecentChecksum info = this.checksumService.findByBitstream(this.context, bitstream);
        if (info == null) {
            info = this.checksumService.getNonPersistedObject();
            this.processNullInfoBitstream(info);
        } else if (!info.isToBeProcessed()) {
            info.setChecksumResult(this.getChecksumResultByCode(ChecksumResultCode.BITSTREAM_NOT_PROCESSED));
        } else if (info.getBitstream().isDeleted()) {
            this.processDeletedBitstream(info);
        } else {
            this.processBitstream(info);
        }
        return info;
    }

    protected ChecksumResult compareChecksums(String checksumA, String checksumB) throws SQLException {
        ChecksumResult result = this.getChecksumResultByCode(ChecksumResultCode.CHECKSUM_NO_MATCH);
        if (checksumA == null || checksumB == null) {
            result = this.getChecksumResultByCode(ChecksumResultCode.CHECKSUM_PREV_NOT_FOUND);
        } else if (checksumA.equals(checksumB)) {
            result = this.getChecksumResultByCode(ChecksumResultCode.CHECKSUM_MATCH);
        }
        return result;
    }

    protected void processDeletedBitstream(MostRecentChecksum info) throws SQLException {
        info.setProcessStartDate(new Date());
        info.setChecksumResult(this.getChecksumResultByCode(ChecksumResultCode.BITSTREAM_MARKED_DELETED));
        info.setProcessEndDate(new Date());
        info.setToBeProcessed(false);
        this.checksumService.update(this.context, info);
        this.checksumHistoryService.addHistory(this.context, info);
    }

    protected void processNullInfoBitstream(MostRecentChecksum info) throws SQLException {
        info.setInfoFound(false);
        info.setProcessStartDate(new Date());
        info.setProcessEndDate(new Date());
        info.setChecksumResult(this.getChecksumResultByCode(ChecksumResultCode.BITSTREAM_INFO_NOT_FOUND));
    }

    protected void processBitstream(MostRecentChecksum info) throws SQLException {
        info.setProcessStartDate(new Date());
        try {
            Map checksumMap = this.bitstreamStorageService.computeChecksum(this.context, info.getBitstream());
            if (MapUtils.isNotEmpty((Map)checksumMap)) {
                info.setBitstreamFound(true);
                if (checksumMap.containsKey("checksum")) {
                    info.setCurrentChecksum(checksumMap.get("checksum").toString());
                }
                if (checksumMap.containsKey("checksum_algorithm")) {
                    info.setChecksumAlgorithm(checksumMap.get("checksum_algorithm").toString());
                }
            }
            info.setChecksumResult(this.compareChecksums(info.getExpectedChecksum(), info.getCurrentChecksum()));
        }
        catch (IOException e) {
            info.setChecksumResult(this.getChecksumResultByCode(ChecksumResultCode.BITSTREAM_NOT_FOUND));
            info.setToBeProcessed(false);
            LOG.error((Object)("Error retrieving bitstream ID " + info.getBitstream().getID() + " from asset store."), (Throwable)e);
        }
        catch (SQLException e) {
            info.setChecksumResult(this.getChecksumResultByCode(ChecksumResultCode.BITSTREAM_INFO_NOT_FOUND));
            LOG.error((Object)("Error retrieving metadata for bitstream ID " + info.getBitstream().getID()), (Throwable)e);
        }
        finally {
            info.setProcessEndDate(new Date());
            this.checksumService.update(this.context, info);
            this.checksumHistoryService.addHistory(this.context, info);
        }
    }

    protected ChecksumResult getChecksumResultByCode(ChecksumResultCode checksumResultCode) throws SQLException {
        return this.checksumResultService.findByCode(this.context, checksumResultCode);
    }

    public BitstreamDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(BitstreamDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public ChecksumResultsCollector getCollector() {
        return this.collector;
    }

    public void setCollector(ChecksumResultsCollector collector) {
        this.collector = collector;
    }

    public Date getProcessStartDate() {
        return this.processStartDate == null ? null : new Date(this.processStartDate.getTime());
    }

    public void setProcessStartDate(Date startDate) {
        this.processStartDate = startDate == null ? null : new Date(startDate.getTime());
    }

    public boolean isReportVerbose() {
        return this.reportVerbose;
    }

    public void setReportVerbose(boolean reportVerbose) {
        this.reportVerbose = reportVerbose;
    }
}

