/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Stack;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.harvest.HarvestThread;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.factory.HarvestServiceFactory;
import org.dspace.harvest.service.HarvestedCollectionService;

public class HarvestScheduler
implements Runnable {
    protected static Logger log = Logger.getLogger(HarvestScheduler.class);
    protected static EPerson harvestAdmin;
    protected Context mainContext = new Context();
    public static final Object lock;
    protected static Stack<HarvestThread> harvestThreads;
    protected static Integer maxActiveThreads;
    protected static volatile Integer activeThreads;
    public static final int HARVESTER_STATUS_RUNNING = 1;
    public static final int HARVESTER_STATUS_SLEEPING = 2;
    public static final int HARVESTER_STATUS_PAUSED = 3;
    public static final int HARVESTER_STATUS_STOPPED = 4;
    public static final int HARVESTER_INTERRUPT_NONE = 0;
    public static final int HARVESTER_INTERRUPT_PAUSE = 1;
    public static final int HARVESTER_INTERRUPT_STOP = 2;
    public static final int HARVESTER_INTERRUPT_RESUME = 3;
    public static final int HARVESTER_INTERRUPT_INSERT_THREAD = 4;
    public static final int HARVESTER_INTERRUPT_KILL_THREAD = 5;
    protected static int status;
    private static int interrupt;
    protected static UUID interruptValue;
    protected static long minHeartbeat;
    protected static long maxHeartbeat;
    private static final CollectionService collectionService;
    private static final HarvestedCollectionService harvestedCollectionService;

    public static boolean hasStatus(int statusToCheck) {
        return status == statusToCheck;
    }

    public static synchronized void setInterrupt(int newInterrupt) {
        interrupt = newInterrupt;
    }

    public static synchronized void setInterrupt(int newInterrupt, UUID newInterruptValue) {
        interrupt = newInterrupt;
        interruptValue = newInterruptValue;
    }

    public static int getInterrupt() {
        return interrupt;
    }

    public static String getStatus() {
        switch (status) {
            case 1: {
                switch (interrupt) {
                    case 1: {
                        return "The scheduler is finishing active harvests before pausing. ";
                    }
                    case 2: {
                        return "The scheduler is shutting down. ";
                    }
                }
                return "The scheduler is actively harvesting collections. ";
            }
            case 2: {
                return "The scheduler is waiting for collections to harvest. ";
            }
            case 3: {
                return "The scheduler is paused. ";
            }
        }
        return "Automatic harvesting is not active. ";
    }

    public HarvestScheduler() throws SQLException, AuthorizeException {
        String harvestAdminParam = ConfigurationManager.getProperty("oai", "harvester.eperson");
        harvestAdmin = null;
        if (harvestAdminParam != null && harvestAdminParam.length() > 0) {
            harvestAdmin = EPersonServiceFactory.getInstance().getEPersonService().findByEmail(this.mainContext, harvestAdminParam);
        }
        harvestThreads = new Stack();
        maxActiveThreads = ConfigurationManager.getIntProperty("oai", "harvester.maxThreads");
        if (maxActiveThreads == 0) {
            maxActiveThreads = 3;
        }
        if ((minHeartbeat = (long)(ConfigurationManager.getIntProperty("oai", "harvester.minHeartbeat") * 1000)) == 0L) {
            minHeartbeat = 30000L;
        }
        if ((maxHeartbeat = (long)(ConfigurationManager.getIntProperty("oai", "harvester.maxHeartbeat") * 1000)) == 0L) {
            maxHeartbeat = 3600000L;
        }
    }

    @Override
    public void run() {
        this.scheduleLoop();
    }

    /*
     * Exception decompiling
     */
    protected void scheduleLoop() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addThread(Context context, HarvestedCollection harvestedCollection) throws SQLException, IOException, AuthorizeException {
        log.debug((Object)("****** Entered the addThread method. Active threads: " + harvestThreads.toString()));
        context.setCurrentUser(harvestAdmin);
        harvestedCollection.setHarvestStatus(2);
        harvestedCollectionService.update(context, harvestedCollection);
        context.dispatchEvents();
        HarvestThread ht = new HarvestThread(harvestedCollection.getCollection().getID());
        harvestThreads.push(ht);
        log.debug((Object)("****** Queued up a thread. Active threads: " + harvestThreads.toString()));
        log.info((Object)("Thread queued up: " + ht.toString()));
    }

    static {
        lock = new Object();
        activeThreads = 0;
        status = 4;
        interrupt = 0;
        interruptValue = null;
        collectionService = ContentServiceFactory.getInstance().getCollectionService();
        harvestedCollectionService = HarvestServiceFactory.getInstance().getHarvestedCollectionService();
    }
}

