/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.conversion;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.rdf.conversion.DMRM;
import org.dspace.rdf.conversion.MetadataMappingException;

public class MetadataRDFMapping {
    private static final Logger log = Logger.getLogger(MetadataRDFMapping.class);
    protected final String name;
    protected final Pattern fulfills;
    protected final List<Resource> results;

    protected MetadataRDFMapping(String name, Pattern fulfills, List<Resource> results) {
        this.name = name;
        this.fulfills = fulfills;
        this.results = results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MetadataRDFMapping getMetadataRDFMapping(Resource mappingResource, String dsoIdentifier) {
        RDFNode conditionNode;
        RDFNode nameNode;
        String uri = null;
        if (mappingResource.getURI() != null) {
            uri = " (" + mappingResource.getURI() + ")";
        }
        if (log.isDebugEnabled()) {
            if (uri.equals("")) {
                log.debug((Object)"Processing blank node MetadataRDFMapping.");
            } else {
                log.debug((Object)("Processing MetadataRDFMapping" + uri + "."));
            }
        }
        try {
            nameNode = MetadataRDFMapping.getSingularProperty(mappingResource, DMRM.metadataName);
        }
        catch (IllegalArgumentException ex) {
            log.error((Object)("The Property 'metadataName' exists multiple times in one DSpaceMetadataRDFMapping, ignoring it" + uri + "."));
            return null;
        }
        if (nameNode == null) {
            log.error((Object)("Cannot find property 'metadataName', ignoring mapping" + uri + "."));
            return null;
        }
        if (!nameNode.isLiteral()) {
            log.error((Object)("Property 'metadataName' is not a literal, ignoring mapping" + uri + "."));
            return null;
        }
        String name = nameNode.asLiteral().getLexicalForm();
        log.debug((Object)("Found mapping name '" + name + "'."));
        try {
            conditionNode = MetadataRDFMapping.getSingularProperty(mappingResource, DMRM.condition);
        }
        catch (IllegalArgumentException ex) {
            log.error((Object)("There are multiple properties 'condition' in one DSpaceMetadataRDFMapping, ignoring it" + uri + "."));
            return null;
        }
        String regex = null;
        Pattern condition = null;
        if (conditionNode != null) {
            if (!conditionNode.isLiteral()) {
                log.error((Object)("Property 'condition' is not a literal, ignoring mapping" + uri + "."));
                return null;
            }
            regex = conditionNode.asLiteral().getLexicalForm();
            log.debug((Object)("Found property condition '" + regex + "'."));
        } else {
            log.debug((Object)"Didn't find a property \"condition\".");
        }
        if (regex != null) {
            try {
                condition = Pattern.compile(regex);
            }
            catch (PatternSyntaxException ex) {
                log.error((Object)("Property 'condition' does not specify a valid java regex pattern. Will ignore mapping" + uri + "."), (Throwable)ex);
                return null;
            }
        }
        ArrayList<Resource> results = new ArrayList<Resource>();
        StmtIterator mappingIter = mappingResource.listProperties(DMRM.creates);
        if (!mappingIter.hasNext()) {
            log.warn((Object)("No 'creates' property in a DSpaceMetadataRDFMapping, ignonring it" + uri + "."));
            return null;
        }
        while (mappingIter.hasNext()) {
            RDFNode result = mappingIter.nextStatement().getObject();
            if (!result.isResource()) {
                log.error((Object)("Mapping result" + uri + " is a Literal not a resource. Ignoring mapping."));
                return null;
            }
            results.add(result.asResource());
        }
        return new MetadataRDFMapping(name, condition, results);
    }

    public boolean matchesName(String name) {
        return StringUtils.equalsIgnoreCase((String)this.name, (String)name);
    }

    public boolean fulfills(String value) {
        if (this.fulfills == null) {
            return true;
        }
        if (!this.fulfills.matcher(value).matches()) {
            log.debug((Object)("Value '" + value + "' does not match regex '" + this.fulfills.toString() + "'."));
            return false;
        }
        return true;
    }

    public void convert(String value, String lang, String dsoIRI, Model m) {
        log.debug((Object)("Using convertion for field " + this.name + " on value: " + value + " for " + dsoIRI + "."));
        Iterator<Resource> iter = this.results.iterator();
        while (iter.hasNext()) {
            try {
                this.compileResult(m, iter.next(), dsoIRI, this.name, value, lang);
            }
            catch (MetadataMappingException ex) {
                log.error((Object)(ex.getMessage() + " Will ignore this mapping result."));
            }
        }
    }

    protected void compileResult(Model m, Resource result, String dsoIRI, String name, String value, String lang) throws MetadataMappingException {
        RDFNode objectNode;
        RDFNode predicateNode;
        RDFNode subjectNode;
        String uri = "";
        if (result.isURIResource()) {
            uri = " (" + result.getURI() + ")";
        }
        try {
            subjectNode = MetadataRDFMapping.getSingularProperty(result, DMRM.subject);
        }
        catch (IllegalArgumentException ex) {
            throw new MetadataMappingException("There are multiple 'subject' properties in a mapping result" + uri + ".");
        }
        if (subjectNode == null) {
            throw new MetadataMappingException("Mapping result" + uri + " does not have a subject.");
        }
        if (!subjectNode.isResource()) {
            throw new MetadataMappingException("Subject of a result" + uri + " is a Literal not a URIResource.");
        }
        log.debug((Object)("Found subject: " + subjectNode.toString()));
        try {
            predicateNode = MetadataRDFMapping.getSingularProperty(result, DMRM.predicate);
        }
        catch (IllegalArgumentException ex) {
            throw new MetadataMappingException("There are multiple 'predicate' properties in a mapping result" + uri + ".");
        }
        if (predicateNode == null) {
            throw new MetadataMappingException("Mapping result" + uri + " does not have a predicate.");
        }
        if (!predicateNode.isResource()) {
            throw new MetadataMappingException("Predicate of a result" + uri + " is a Literal not a URIResource.");
        }
        log.debug((Object)("Found predicate: " + predicateNode.toString()));
        try {
            objectNode = MetadataRDFMapping.getSingularProperty(result, DMRM.object);
        }
        catch (IllegalArgumentException ex) {
            throw new MetadataMappingException("There are multiple 'object' properties in a mapping result" + uri + ".");
        }
        if (objectNode == null) {
            throw new MetadataMappingException("Mapping result" + uri + " does not have a object.");
        }
        log.debug((Object)("Found object: " + objectNode.toString()));
        Resource subject = this.parseSubject(m, subjectNode.asResource(), dsoIRI, name, value);
        if (subject == null) {
            throw new MetadataMappingException("Cannot parse subject of a reified statement " + uri + ".");
        }
        Property predicate = this.parsePredicate(m, predicateNode.asResource(), dsoIRI, name, value);
        if (predicate == null) {
            throw new MetadataMappingException("Cannot parse predicate of a reified statement " + uri + ".");
        }
        RDFNode object = this.parseObject(m, objectNode, dsoIRI, name, value, lang);
        if (object == null) {
            throw new MetadataMappingException("Cannot parse object of a reified statement " + uri + ".");
        }
        m.add(subject, predicate, object);
    }

    protected Resource parseSubject(Model m, Resource subject, String dsoIRI, String name, String value) {
        if (subject.hasProperty(RDF.type, (RDFNode)DMRM.ResourceGenerator)) {
            String generatedIRI = this.parseResourceGenerator(subject, value, dsoIRI);
            if (generatedIRI == null) {
                log.debug((Object)"Generated subject IRI is null.");
                return null;
            }
            log.debug((Object)("Subject ResourceGenerator generated '" + generatedIRI + "'."));
            return m.createResource(generatedIRI);
        }
        return subject;
    }

    protected Property parsePredicate(Model m, Resource predicate, String dsoIRI, String name, String value) {
        if (predicate.hasProperty(RDF.type, (RDFNode)DMRM.ResourceGenerator)) {
            String generatedIRI = this.parseResourceGenerator(predicate, value, dsoIRI);
            if (generatedIRI == null) {
                log.debug((Object)"Generated predicate IRI is null.");
                return null;
            }
            log.debug((Object)("Property ResourceGenerator generated '" + generatedIRI + "'."));
            return m.createProperty(generatedIRI);
        }
        String uri = predicate.getURI();
        if (uri == null) {
            log.debug((Object)"A result predicate is blank node, but not a ResourceGenerator. Ingoring this result.");
            return null;
        }
        return m.createProperty(uri);
    }

    protected RDFNode parseObject(Model m, RDFNode objectNode, String dsoIRI, String name, String value, String lang) {
        if (objectNode.isLiteral()) {
            return objectNode;
        }
        Resource object = objectNode.asResource();
        if (object.hasProperty(RDF.type, (RDFNode)DMRM.LiteralGenerator)) {
            Literal literalValue = this.parseLiteralGenerator(m, object, value, lang);
            if (literalValue == null) {
                return null;
            }
            return literalValue;
        }
        if (object.hasProperty(RDF.type, (RDFNode)DMRM.ResourceGenerator)) {
            String generatedIRI = this.parseResourceGenerator(object, value, dsoIRI);
            if (generatedIRI == null) {
                log.debug((Object)"Generated predicate IRI is null.");
                return null;
            }
            log.debug((Object)("Property ResourceGenerator generated '" + generatedIRI + "'."));
            return m.createProperty(generatedIRI);
        }
        if (object.isAnon()) {
            Resource blank = m.createResource();
            StmtIterator iter = object.listProperties();
            while (iter.hasNext()) {
                Statement stmt = iter.nextStatement();
                Property predicate = stmt.getPredicate();
                blank.addProperty(predicate, this.parseObject(m, stmt.getObject(), dsoIRI, name, value, lang));
            }
            return blank;
        }
        return object;
    }

    protected String parseResourceGenerator(Resource resourceGenerator, String value, String dsoIRI) {
        if (resourceGenerator.isURIResource() && resourceGenerator.equals((Object)DMRM.DSpaceObjectIRI)) {
            return dsoIRI;
        }
        return this.parseValueProcessor(resourceGenerator, value);
    }

    protected Literal parseLiteralGenerator(Model m, Resource literalGenerator, String value, String lang) {
        String languageTag;
        String modifiedValue;
        block18: {
            if (literalGenerator.isURIResource() && literalGenerator.equals((Object)DMRM.DSpaceValue)) {
                return m.createLiteral(value);
            }
            modifiedValue = this.parseValueProcessor(literalGenerator, value);
            if (modifiedValue == null) {
                return null;
            }
            try {
                RDFNode literalTypeNode = MetadataRDFMapping.getSingularProperty(literalGenerator, DMRM.literalType);
                if (literalTypeNode != null) {
                    if (literalTypeNode.isURIResource()) {
                        return m.createTypedLiteral(modifiedValue, literalTypeNode.asResource().getURI());
                    }
                    log.warn((Object)"A LiteralGenerator has a property 'literalType' that either is a blank node or a Literal. Ignoring it.");
                }
            }
            catch (IllegalArgumentException ex) {
                log.error((Object)"A LiteralGenerator has multiple properties 'literalType'. Will ignore them.");
            }
            languageTag = null;
            try {
                RDFNode langNode = MetadataRDFMapping.getSingularProperty(literalGenerator, DMRM.literalLanguage);
                if (langNode != null) {
                    if (langNode.isLiteral()) {
                        languageTag = langNode.asLiteral().getLexicalForm();
                    } else {
                        log.warn((Object)"Found a property 'literalLanguage', but its object is not a literal! Ignoring it.");
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                log.warn((Object)"A LiteralGenerator has multiple properties 'literalLanguage'. Will ignore them.");
            }
            try {
                RDFNode dspaceLangNode = MetadataRDFMapping.getSingularProperty(literalGenerator, DMRM.dspaceLanguageTag);
                if (dspaceLangNode == null) break block18;
                boolean useDSpaceLang = false;
                if (dspaceLangNode.isLiteral()) {
                    try {
                        useDSpaceLang = dspaceLangNode.asLiteral().getBoolean();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (useDSpaceLang && !StringUtils.isEmpty((String)lang)) {
                    languageTag = lang.indexOf("_") == 2 ? lang.replaceFirst("_", "-") : lang;
                }
            }
            catch (IllegalArgumentException ex) {
                log.error((Object)"A LiteralGenerator has multiple properties 'dspaceLanguageTag'. Will ignore them.");
            }
        }
        if (languageTag != null) {
            return m.createLiteral(modifiedValue, languageTag);
        }
        return m.createLiteral(modifiedValue);
    }

    protected String parseValueProcessor(Resource valueProcessor, String value) {
        RDFNode patternNode;
        RDFNode modifierNode;
        try {
            modifierNode = MetadataRDFMapping.getSingularProperty(valueProcessor, DMRM.modifier);
        }
        catch (IllegalArgumentException ex) {
            log.error((Object)"The ResourceGenerator of a mapping result has multiple 'modifier' properties, skipping this result.");
            return null;
        }
        if (modifierNode != null) {
            RDFNode replacementNode;
            RDFNode matcherNode;
            if (!modifierNode.isResource()) {
                log.error((Object)"The modifier of a result is a Literal not an Resource! Ingoring this result.");
                return null;
            }
            Resource modifier = modifierNode.asResource();
            try {
                matcherNode = MetadataRDFMapping.getSingularProperty(modifier, DMRM.matcher);
            }
            catch (IllegalArgumentException ex) {
                log.error((Object)"The modifier of a mapping result has multiple 'matcher' properties. Ignoring this result.");
                return null;
            }
            if (matcherNode == null) {
                log.error((Object)"Found a modifier property to a result, but no matcher property! Ignoring this result!");
                return null;
            }
            if (!matcherNode.isLiteral()) {
                log.error((Object)"A matcher of a result modifier is not a Literal! Ignoring this result.");
                return null;
            }
            try {
                replacementNode = MetadataRDFMapping.getSingularProperty(modifier, DMRM.replacement);
            }
            catch (IllegalArgumentException ex) {
                log.error((Object)"The modifier of a mapping result has multiple 'replacement' properties. Ignoring this result.");
                return null;
            }
            if (replacementNode == null) {
                log.error((Object)"Found a modifier property to a result, but no replacement property! Ignoring this result!");
                return null;
            }
            if (!replacementNode.isLiteral()) {
                log.error((Object)"A replacement of a result modifier is not a Literal! Ignoring this result.");
                return null;
            }
            String matcher = matcherNode.asLiteral().getLexicalForm();
            String replacement = replacementNode.asLiteral().getLexicalForm();
            try {
                Pattern pattern = Pattern.compile(matcher);
                String modifiedValue = pattern.matcher(value).replaceAll(replacement);
                log.debug((Object)("Found matcher '" + matcher + "'.\nFound replacement '" + replacement + "'.\nmodified '" + value + "' => '" + modifiedValue + "'."));
                value = modifiedValue;
            }
            catch (PatternSyntaxException ex) {
                log.error((Object)"Property 'matcher' of a ValueModifider didn't specify a valid java regex pattern. Will ignore this result.", (Throwable)ex);
                return null;
            }
        }
        try {
            patternNode = MetadataRDFMapping.getSingularProperty(valueProcessor, DMRM.pattern);
        }
        catch (IllegalArgumentException ex) {
            log.error((Object)"The ValueProcessor of a mapping result has multiple 'pattern' properties, skipping this result.");
            return null;
        }
        if (patternNode == null) {
            log.debug((Object)"Cannot find the property 'pattern' of a ValueProcessor, will use \"$DSpaceValue\".");
            patternNode = valueProcessor.getModel().createLiteral("$DSpaceValue");
        }
        if (!patternNode.isLiteral()) {
            log.error((Object)"A 'pattern' property of a ValueProcessor is not a Literal! Skipping this result.");
            return null;
        }
        String pattern = patternNode.asLiteral().getLexicalForm();
        String result = pattern.replace("$DSpaceValue", value);
        log.debug((Object)("Found pattern " + pattern + ".\nCreated result: " + result));
        return result;
    }

    protected static RDFNode getSingularProperty(Resource r, Property p) throws IllegalArgumentException {
        List stmts = r.listProperties(p).toList();
        if (stmts.isEmpty()) {
            return null;
        }
        if (stmts.size() > 1) {
            throw new IllegalArgumentException("Property '" + p.getURI() + "' exists multiple times.");
        }
        return ((Statement)stmts.get(0)).getObject();
    }
}

