/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dspace.checker.ChecksumResultCode;
import org.dspace.checker.factory.CheckerServiceFactory;
import org.dspace.checker.service.ChecksumHistoryService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;

public final class ResultsPruner {
    private static final Logger LOG = Logger.getLogger(ResultsPruner.class);
    private long defaultDuration = 31536000000L;
    Map<ChecksumResultCode, Long> interests = new HashMap<ChecksumResultCode, Long>();
    private ChecksumHistoryService checksumHistoryService = CheckerServiceFactory.getInstance().getChecksumHistoryService();
    private Context context = null;

    public static ResultsPruner getDefaultPruner(Context context) {
        try {
            return ResultsPruner.getPruner(context, ConfigurationManager.getProperties());
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("VeryExceptionalException - config file not there! ", e);
        }
    }

    public static ResultsPruner getPruner(Context context, String propsFile) throws FileNotFoundException {
        Properties props = new Properties();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(propsFile);
            props.load(fin);
            ResultsPruner resultsPruner = ResultsPruner.getPruner(context, props);
            return resultsPruner;
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem loading properties file: " + e.getMessage(), e);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)e);
                }
            }
        }
    }

    public static ResultsPruner getPruner(Context context, Properties props) throws FileNotFoundException {
        ResultsPruner rp = new ResultsPruner(context);
        Pattern retentionPattern = Pattern.compile("checker\\.retention\\.(.*)");
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            long duration;
            String name = (String)en.nextElement();
            Matcher matcher = retentionPattern.matcher(name);
            if (!matcher.matches()) continue;
            String resultCode = matcher.group(1);
            try {
                duration = Utils.parseDuration(props.getProperty(name));
            }
            catch (ParseException e) {
                throw new IllegalStateException("Problem parsing duration: " + e.getMessage(), e);
            }
            ChecksumResultCode code = ChecksumResultCode.valueOf(resultCode);
            if (code == null) {
                throw new IllegalStateException("Checksum result code not found: " + resultCode);
            }
            if ("default".equals(resultCode)) {
                rp.setDefaultDuration(duration);
                continue;
            }
            rp.addInterested(code, duration);
        }
        return rp;
    }

    public ResultsPruner(Context context) {
        this.context = context;
    }

    public void addInterested(ChecksumResultCode result, long duration) {
        this.interests.put(result, duration);
    }

    public void addInterested(ChecksumResultCode result, String duration) throws ParseException {
        this.addInterested(result, Utils.parseDuration(duration));
    }

    public long getDefaultDuration() {
        return this.defaultDuration;
    }

    public int prune() throws SQLException {
        ChecksumResultCode[] codes;
        for (ChecksumResultCode code : codes = ChecksumResultCode.values()) {
            if (this.interests.containsKey((Object)code)) continue;
            this.interests.put(code, this.defaultDuration);
        }
        int result = this.checksumHistoryService.prune(this.context, this.interests);
        return result;
    }

    public void setDefaultDuration(long defaultDuration) {
        this.defaultDuration = defaultDuration;
    }
}

