/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObjectServiceImpl;
import org.dspace.content.Site;
import org.dspace.content.dao.SiteDAO;
import org.dspace.content.service.SiteService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.event.Event;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class SiteServiceImpl
extends DSpaceObjectServiceImpl<Site>
implements SiteService {
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected SiteDAO siteDAO;

    protected SiteServiceImpl() {
    }

    @Override
    public Site createSite(Context context) throws SQLException {
        Site site = this.findSite(context);
        if (site == null) {
            site = this.siteDAO.create(context, new Site());
            this.handleService.createHandle(context, site, this.configurationService.getProperty("handle.prefix") + "/0");
        }
        return site;
    }

    @Override
    public Site findSite(Context context) throws SQLException {
        return this.siteDAO.findSite(context);
    }

    @Override
    public Site find(Context context, UUID id) throws SQLException {
        return (Site)this.siteDAO.findByID(context, Site.class, id);
    }

    @Override
    public void updateLastModified(Context context, Site dso) throws SQLException, AuthorizeException {
    }

    @Override
    public void update(Context context, Site site) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException();
        }
        super.update(context, site);
        if (site.isMetadataModified()) {
            context.addEvent(new Event(4, site.getType(), site.getID(), site.getDetails(), this.getIdentifiers(context, site)));
        }
        if (site.isModified()) {
            context.addEvent(new Event(2, site.getType(), site.getID(), site.getDetails(), this.getIdentifiers(context, site)));
        }
        site.clearModified();
        site.clearDetails();
        this.siteDAO.save(context, site);
    }

    @Override
    public String getName(Site dso) {
        return ConfigurationManager.getProperty("dspace.name");
    }

    @Override
    public void delete(Context context, Site dso) throws SQLException, AuthorizeException, IOException {
        throw new AuthorizeException("Site object cannot be deleted");
    }

    @Override
    public int getSupportsTypeConstant() {
        return 5;
    }
}

