/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Utils {
    private static final int BUFF_SIZE = 4096;
    private static final byte[] buffer = new byte[4096];
    static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checksum(File file, String algorithm) throws IOException {
        String chkSum = null;
        try (FileInputStream in = null;){
            in = new FileInputStream(file);
            chkSum = Utils.checksum(in, algorithm);
        }
        return chkSum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String checksum(InputStream in, String algorithm) throws IOException {
        try {
            DigestInputStream din = new DigestInputStream(in, MessageDigest.getInstance(algorithm));
            while (true) {
                byte[] byArray = buffer;
                // MONITORENTER : buffer
                if (din.read(buffer) == -1) {
                    // MONITOREXIT : byArray
                    return Utils.toHex(din.getMessageDigest().digest());
                }
                // MONITOREXIT : byArray
            }
        }
        catch (NoSuchAlgorithmException nsaE) {
            throw new IOException(nsaE.getMessage(), nsaE);
        }
    }

    public static String toHex(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        char[] chars = new char[2 * data.length];
        for (int i = 0; i < data.length; ++i) {
            chars[2 * i] = HEX_CHARS[(data[i] & 0xF0) >>> 4];
            chars[2 * i + 1] = HEX_CHARS[data[i] & 0xF];
        }
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File inFile, File outFile) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(inFile);
            out = new FileOutputStream(outFile);
            Utils.copy(in, out);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        while (true) {
            byte[] byArray = buffer;
            // MONITORENTER : buffer
            int count = in.read(buffer);
            if (-1 == count) {
                // MONITOREXIT : byArray
                out.flush();
                return;
            }
            out.write(buffer, 0, count);
            // MONITOREXIT : byArray
        }
    }
}

