/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.license;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.dspace.license.CCLicense;
import org.dspace.license.CCLicenseField;
import org.dspace.license.factory.LicenseServiceFactory;
import org.dspace.license.service.CreativeCommonsService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jaxen.JaxenException;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class CCLookup {
    private static Logger log = Logger.getLogger(CCLookup.class);
    private String cc_root;
    private String jurisdiction;
    private List<String> lcFilter = new ArrayList<String>();
    private Document license_doc = null;
    private String rdfString = null;
    private String errorMessage = null;
    private boolean success = false;
    private SAXBuilder parser = new SAXBuilder();
    private List<CCLicense> licenses = new ArrayList<CCLicense>();
    private List<CCLicenseField> licenseFields = new ArrayList<CCLicenseField>();
    protected CreativeCommonsService creativeCommonsService = LicenseServiceFactory.getInstance().getCreativeCommonsService();

    public CCLookup() {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.cc_root = configurationService.getProperty("cc.api.rooturl");
        String jurisProp = configurationService.getProperty("cc.license.jurisdiction");
        this.jurisdiction = jurisProp != null ? jurisProp : "";
        String[] filters = configurationService.getArrayProperty("cc.license.classfilter");
        if (filters != null) {
            for (String name : filters) {
                this.lcFilter.add(name.trim());
            }
        }
    }

    public String getLicenseId(String class_label) {
        for (int i = 0; i < this.licenses.size(); ++i) {
            if (!this.licenses.get(i).getLicenseName().equals(class_label)) continue;
            return this.licenses.get(i).getLicenseId();
        }
        return "";
    }

    public Collection<CCLicense> getLicenses(String language) {
        try {
            JDOMXPath xp_Licenses = new JDOMXPath("//licenses/license");
            JDOMXPath xp_LicenseID = new JDOMXPath("@id");
            URL classUrl = new URL(this.cc_root + "/?locale=" + language);
            Document classDoc = this.parser.build(classUrl);
            List results = xp_Licenses.selectNodes((Object)classDoc);
            this.licenses.clear();
            for (int i = 0; i < results.size(); ++i) {
                Element license = (Element)results.get(i);
                String liD = ((Attribute)xp_LicenseID.selectSingleNode((Object)license)).getValue();
                if (this.lcFilter.contains(liD)) continue;
                this.licenses.add(new CCLicense(liD, license.getText(), i));
            }
        }
        catch (JaxenException jaxen_e) {
            return null;
        }
        catch (JDOMException jdom_e) {
            return null;
        }
        catch (IOException io_e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
        return this.licenses;
    }

    public Collection<CCLicenseField> getLicenseFields(String license, String language) {
        Document fieldDoc;
        URL classUrl;
        JDOMXPath xp_Enum;
        JDOMXPath xp_FieldType;
        JDOMXPath xp_Label;
        JDOMXPath xp_Description;
        JDOMXPath xp_LicenseID;
        JDOMXPath xp_LicenseField;
        List results = null;
        List enumOptions = null;
        try {
            xp_LicenseField = new JDOMXPath("//field");
            xp_LicenseID = new JDOMXPath("@id");
            xp_Description = new JDOMXPath("description");
            xp_Label = new JDOMXPath("label");
            xp_FieldType = new JDOMXPath("type");
            xp_Enum = new JDOMXPath("enum");
        }
        catch (JaxenException e) {
            return null;
        }
        try {
            classUrl = new URL(this.cc_root + "/license/" + license + "?locale=" + language);
        }
        catch (Exception err) {
            return null;
        }
        try {
            fieldDoc = this.parser.build(classUrl);
        }
        catch (JDOMException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        this.licenseFields.clear();
        try {
            results = xp_LicenseField.selectNodes((Object)fieldDoc);
        }
        catch (JaxenException e) {
            return null;
        }
        for (int i = 0; i < results.size(); ++i) {
            Element field = (Element)results.get(i);
            try {
                CCLicenseField cclicensefield = new CCLicenseField(((Attribute)xp_LicenseID.selectSingleNode((Object)field)).getValue(), ((Element)xp_Label.selectSingleNode((Object)field)).getText());
                cclicensefield.setDescription(((Element)xp_Description.selectSingleNode((Object)field)).getText());
                cclicensefield.setType(((Element)xp_FieldType.selectSingleNode((Object)field)).getText());
                enumOptions = xp_Enum.selectNodes((Object)field);
                for (int j = 0; j < enumOptions.size(); ++j) {
                    String id = ((Attribute)xp_LicenseID.selectSingleNode(enumOptions.get(j))).getValue();
                    String label = ((Element)xp_Label.selectSingleNode(enumOptions.get(j))).getText();
                    cclicensefield.getEnum().put(id, label);
                }
                this.licenseFields.add(cclicensefield);
                continue;
            }
            catch (JaxenException e) {
                return null;
            }
        }
        return this.licenseFields;
    }

    public void issue(String licenseId, Map answers, String lang) throws IOException {
        String issueUrl = this.cc_root + "/license/" + licenseId + "/issue";
        String answer_doc = "<answers>\n<locale>" + lang + "</locale>\n" + "<license-" + licenseId + ">\n";
        Iterator keys = answers.keySet().iterator();
        try {
            String current = (String)keys.next();
            while (true) {
                answer_doc = answer_doc + "<" + current + ">" + (String)answers.get(current) + "</" + current + ">\n";
                current = (String)keys.next();
            }
        }
        catch (NoSuchElementException current) {
            URL post_url;
            String post_data;
            answer_doc = answer_doc + "</license-" + licenseId + ">\n</answers>\n";
            try {
                post_data = URLEncoder.encode("answers", "UTF-8") + "=" + URLEncoder.encode(answer_doc, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return;
            }
            try {
                post_url = new URL(issueUrl);
            }
            catch (MalformedURLException e) {
                return;
            }
            URLConnection connection = post_url.openConnection();
            connection.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(post_data);
            writer.flush();
            try {
                InputStream stream = connection.getInputStream();
                this.license_doc = this.parser.build(stream);
            }
            catch (JDOMException jde) {
                log.warn((Object)jde.getMessage());
            }
            catch (Exception e) {
                log.warn((Object)e.getCause());
            }
            return;
        }
    }

    public void issue(String licenseURI) throws IOException {
        URL request_url;
        String issueUrl = this.cc_root + "/details?license-uri=" + licenseURI;
        try {
            request_url = new URL(issueUrl);
        }
        catch (MalformedURLException e) {
            return;
        }
        URLConnection connection = request_url.openConnection();
        connection.setDoOutput(true);
        try {
            InputStream stream = connection.getInputStream();
            this.license_doc = this.parser.build(stream);
        }
        catch (JDOMException jde) {
            log.warn((Object)jde.getMessage());
        }
        catch (Exception e) {
            log.warn((Object)e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLicenseUrl() {
        String text = null;
        try {
            JDOMXPath xp_LicenseName = new JDOMXPath("//result/license-uri");
            text = ((Element)xp_LicenseName.selectSingleNode((Object)this.license_doc)).getText();
            return text;
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
            this.setSuccess(false);
            text = "An error occurred getting the license - uri.";
            return text;
        }
        finally {
            return text;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLicenseName() {
        String text = null;
        try {
            JDOMXPath xp_LicenseName = new JDOMXPath("//result/license-name");
            text = ((Element)xp_LicenseName.selectSingleNode((Object)this.license_doc)).getText();
            return text;
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
            this.setSuccess(false);
            text = "An error occurred on the license name.";
            return text;
        }
        finally {
            return text;
        }
    }

    public Document getLicenseDocument() {
        return this.license_doc;
    }

    public String getRdf() throws IOException {
        String result = "";
        try {
            result = this.creativeCommonsService.fetchLicenseRDF(this.license_doc);
        }
        catch (Exception e) {
            log.warn((Object)("An error occurred getting the rdf . . ." + e.getMessage()));
            this.setSuccess(false);
        }
        return result;
    }

    public boolean isSuccess() {
        this.setSuccess(false);
        String text = null;
        try {
            JDOMXPath xp_Success = new JDOMXPath("//message");
            text = ((Element)xp_Success.selectSingleNode((Object)this.license_doc)).getText();
            this.setErrorMessage(text);
        }
        catch (Exception e) {
            log.warn((Object)("There was an issue . . . " + text));
            this.setSuccess(true);
        }
        return this.success;
    }

    private void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

