/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.search;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.eperson.Group;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.search.HarvestedItemInfo;

public class Harvest {
    private static final Logger log = Logger.getLogger(Harvest.class);
    protected static final AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected static final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public static List<HarvestedItemInfo> harvest(Context context, DSpaceObject scope, String startDate, String endDate, int offset, int limit, boolean items, boolean collections, boolean withdrawn, boolean nonAnon) throws SQLException, ParseException {
        DiscoverQuery discoverQuery = new DiscoverQuery();
        discoverQuery.addFilterQueries("search.resourcetype:2");
        if (scope != null) {
            discoverQuery.addFieldPresentQueries("location:" + scope.getID());
        }
        if (startDate != null) {
            discoverQuery.addFilterQueries("lastModified => " + new DCDate(startDate).toString());
        }
        if (endDate != null) {
            discoverQuery.addFilterQueries("lastModified <= " + new DCDate(startDate).toString());
        }
        if (!withdrawn) {
            discoverQuery.addFilterQueries("archived: true OR withdrawn: false");
        } else {
            discoverQuery.addFilterQueries("archived: true OR withdrawn: true");
        }
        discoverQuery.setSortField("search.resourceid", DiscoverQuery.SORT_ORDER.asc);
        LinkedList<HarvestedItemInfo> infoObjects = new LinkedList<HarvestedItemInfo>();
        int index = 0;
        int itemCounter = 0;
        try {
            DiscoverResult discoverResult = SearchUtils.getSearchService().search(context, discoverQuery);
            Iterator<DSpaceObject> dsoIterator = discoverResult.getDspaceObjects().iterator();
            while (dsoIterator.hasNext() && (limit == 0 || itemCounter < limit)) {
                DSpaceObject dso = dsoIterator.next();
                HarvestedItemInfo itemInfo = new HarvestedItemInfo();
                itemInfo.context = context;
                itemInfo.handle = dso.getHandle();
                itemInfo.itemID = dso.getID();
                itemInfo.datestamp = ((Item)dso).getLastModified();
                itemInfo.withdrawn = ((Item)dso).isWithdrawn();
                if (collections) {
                    Harvest.fillCollections(context, itemInfo);
                }
                if (items) {
                    itemInfo.item = (Item)itemService.find(context, itemInfo.itemID);
                }
                if (nonAnon || itemInfo.item == null || withdrawn && itemInfo.withdrawn) {
                    if (++index <= offset) continue;
                    infoObjects.add(itemInfo);
                    ++itemCounter;
                    continue;
                }
                if (!Harvest.anonAccessAllowed(context, itemInfo) || ++index <= offset) continue;
                infoObjects.add(itemInfo);
                ++itemCounter;
            }
        }
        catch (SearchServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return infoObjects;
    }

    public static HarvestedItemInfo getSingle(Context context, String handle, boolean collections) throws SQLException {
        Item i = (Item)handleService.resolveToObject(context, handle);
        if (i == null) {
            return null;
        }
        HarvestedItemInfo itemInfo = new HarvestedItemInfo();
        itemInfo.context = context;
        itemInfo.item = i;
        itemInfo.handle = handle;
        itemInfo.withdrawn = i.isWithdrawn();
        itemInfo.datestamp = i.getLastModified();
        itemInfo.itemID = i.getID();
        if (collections) {
            Harvest.fillCollections(context, itemInfo);
        }
        return itemInfo;
    }

    private static void fillCollections(Context context, HarvestedItemInfo itemInfo) throws SQLException {
        List<Collection> collections = itemInfo.item.getCollections();
        itemInfo.collectionHandles = new ArrayList<String>();
        for (Collection collection : collections) {
            itemInfo.collectionHandles.add(collection.getHandle());
        }
    }

    private static boolean anonAccessAllowed(Context context, HarvestedItemInfo itemInfo) throws SQLException {
        List<Group> authorizedGroups = authorizeService.getAuthorizedGroups(context, itemInfo.item, 0);
        for (Group authorizedGroup : authorizedGroups) {
            if (!authorizedGroup.getName().equals("Anonymous")) continue;
            return true;
        }
        return false;
    }
}

