/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.indexer;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.indexer.AuthorityIndexerInterface;
import org.dspace.authority.service.AuthorityValueService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class DSpaceAuthorityIndexer
implements AuthorityIndexerInterface,
InitializingBean {
    private static final Logger log = Logger.getLogger(DSpaceAuthorityIndexer.class);
    protected Iterator<Item> itemIterator;
    protected Item currentItem;
    protected List<String> metadataFields;
    protected int currentFieldIndex;
    protected int currentMetadataIndex;
    protected AuthorityValue nextValue;
    protected Context context;
    @Autowired(required=true)
    protected AuthorityValueService authorityValueService;
    @Autowired(required=true)
    protected ItemService itemService;
    protected boolean useCache;
    protected Map<String, AuthorityValue> cache;
    @Autowired(required=true)
    protected ConfigurationService configurationService;

    public void afterPropertiesSet() throws Exception {
        String field;
        int counter = 1;
        this.metadataFields = new ArrayList<String>();
        while ((field = this.configurationService.getProperty("authority.author.indexer.field." + counter)) != null) {
            this.metadataFields.add(field);
            ++counter;
        }
    }

    @Override
    public void init(Context context, Item item) {
        ArrayList<Item> itemList = new ArrayList<Item>();
        itemList.add(item);
        this.itemIterator = itemList.iterator();
        this.currentItem = this.itemIterator.next();
        this.initialize(context);
    }

    @Override
    public void init(Context context) {
        this.init(context, false);
    }

    @Override
    public void init(Context context, boolean useCache) {
        try {
            this.itemIterator = this.itemService.findAll(context);
            this.currentItem = this.itemIterator.next();
        }
        catch (SQLException e) {
            log.error((Object)"Error while retrieving all items in the metadata indexer");
        }
        this.initialize(context);
        this.useCache = useCache;
    }

    protected void initialize(Context context) {
        this.context = context;
        this.currentFieldIndex = 0;
        this.currentMetadataIndex = 0;
        this.useCache = false;
        this.cache = new HashMap<String, AuthorityValue>();
    }

    @Override
    public AuthorityValue nextValue() {
        return this.nextValue;
    }

    @Override
    public boolean hasMore() throws SQLException, AuthorizeException {
        if (this.currentItem == null) {
            return false;
        }
        String metadataField = this.metadataFields.get(this.currentFieldIndex);
        List<MetadataValue> values = this.itemService.getMetadataByMetadataString(this.currentItem, metadataField);
        if (this.currentMetadataIndex < values.size()) {
            this.prepareNextValue(metadataField, values.get(this.currentMetadataIndex));
            ++this.currentMetadataIndex;
            return true;
        }
        if (this.currentFieldIndex + 1 < this.metadataFields.size()) {
            ++this.currentFieldIndex;
            this.currentMetadataIndex = 0;
            return this.hasMore();
        }
        this.context.uncacheEntity(this.currentItem);
        if (this.itemIterator.hasNext()) {
            this.currentItem = this.itemIterator.next();
            this.currentFieldIndex = 0;
            this.currentMetadataIndex = 0;
        } else {
            this.currentItem = null;
        }
        return this.hasMore();
    }

    protected void prepareNextValue(String metadataField, MetadataValue value) throws SQLException, AuthorizeException {
        AuthorityValue cachedAuthorityValue;
        boolean requiresItemUpdate;
        this.nextValue = null;
        String content = value.getValue();
        String authorityKey = value.getAuthority();
        boolean bl = requiresItemUpdate = StringUtils.isBlank((String)authorityKey) || StringUtils.startsWith((String)authorityKey, (String)"will be generated::");
        if (StringUtils.isNotBlank((String)authorityKey) && !authorityKey.startsWith("will be generated::")) {
            this.nextValue = this.authorityValueService.findByUID(this.context, authorityKey);
        }
        if (this.nextValue == null && StringUtils.isBlank((String)authorityKey) && this.useCache && (cachedAuthorityValue = this.cache.get(content)) != null) {
            this.nextValue = cachedAuthorityValue;
        }
        if (this.nextValue == null) {
            this.nextValue = this.authorityValueService.generate(this.context, authorityKey, content, metadataField.replaceAll("\\.", "_"));
        }
        if (this.nextValue != null && requiresItemUpdate) {
            this.nextValue.updateItem(this.context, this.currentItem, value);
            try {
                this.itemService.update(this.context, this.currentItem);
            }
            catch (Exception e) {
                log.error((Object)"Error creating a metadatavalue's authority", (Throwable)e);
            }
        }
        if (this.useCache) {
            this.cache.put(content, this.nextValue);
        }
    }

    @Override
    public void close() {
        this.itemIterator = null;
        this.cache.clear();
    }

    @Override
    public boolean isConfiguredProperly() {
        boolean isConfiguredProperly = true;
        if (CollectionUtils.isEmpty(this.metadataFields)) {
            log.warn((Object)"Authority indexer not properly configured, no metadata fields configured for indexing. Check the \"authority.author.indexer.field\" properties.");
            isConfiguredProperly = false;
        }
        return isConfiguredProperly;
    }
}

