/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.mail.MessagingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dspace.checker.factory.CheckerServiceFactory;
import org.dspace.checker.service.SimpleReporterService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;

public class DailyReportEmailer {
    private static Logger log = Logger.getLogger(DailyReportEmailer.class);

    public void sendReport(File attachment, int numberOfBitstreams) throws IOException, MessagingException {
        if (numberOfBitstreams > 0) {
            String hostname = ConfigurationManager.getProperty("dspace.hostname");
            Email email = new Email();
            email.setSubject("Checksum checker Report - " + numberOfBitstreams + " Bitstreams found with POSSIBLE issues on " + hostname);
            email.setContent("report is attached ...");
            email.addAttachment(attachment, "checksum_checker_report.txt");
            email.addRecipient(ConfigurationManager.getProperty("mail.admin"));
            email.send();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        Options options = new Options();
        options.addOption("h", "help", false, "Help");
        options.addOption("d", "Deleted", false, "Send E-mail report for all bitstreams set as deleted for today");
        options.addOption("m", "Missing", false, "Send E-mail report for all bitstreams not found in assetstore for today");
        options.addOption("c", "Changed", false, "Send E-mail report for all bitstreams where checksum has been changed for today");
        options.addOption("a", "All", false, "Send all E-mail reports");
        options.addOption("u", "Unchecked", false, "Send the Unchecked bitstream report");
        options.addOption("n", "Not Processed", false, "Send E-mail report for all bitstreams set to longer be processed for today");
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException e) {
            log.fatal((Object)e);
            System.exit(1);
        }
        if (line.hasOption('h')) {
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp("Checksum Reporter\n", options);
            System.out.println("\nSend Deleted bitstream email report: DailyReportEmailer -d");
            System.out.println("\nSend Missing bitstreams email report: DailyReportEmailer -m");
            System.out.println("\nSend Checksum Changed email report: DailyReportEmailer -c");
            System.out.println("\nSend bitstream not to be processed email report: DailyReportEmailer -n");
            System.out.println("\nSend Un-checked bitstream report: DailyReportEmailer -u");
            System.out.println("\nSend All email reports: DailyReportEmailer");
            System.exit(0);
        }
        SimpleReporterService reporter = CheckerServiceFactory.getInstance().getSimpleReporterService();
        DailyReportEmailer emailer = new DailyReportEmailer();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(6, -1);
        Date yesterday = calendar.getTime();
        calendar.add(6, 2);
        Date tomorrow = calendar.getTime();
        File report = null;
        OutputStreamWriter writer = null;
        Context context = null;
        try {
            context = new Context(Context.Mode.READ_ONLY);
            int numBitstreams = 0;
            String dirLocation = ConfigurationManager.getProperty("log.report.dir");
            File directory = new File(dirLocation);
            if (!directory.exists() || !directory.isDirectory()) {
                throw new IllegalStateException("directory :" + dirLocation + " does not exist");
            }
            report = File.createTempFile("checker_report", ".txt", directory);
            writer = new FileWriter(report);
            if (line.hasOption("a") || line.getOptions().length == 0) {
                writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                numBitstreams += reporter.getDeletedBitstreamReport(context, yesterday, tomorrow, writer);
                writer.write("\n--------------------------------- Report Spacer ---------------------------\n\n");
                numBitstreams += reporter.getChangedChecksumReport(context, yesterday, tomorrow, writer);
                writer.write("\n--------------------------------- Report Spacer ---------------------------\n\n");
                numBitstreams += reporter.getBitstreamNotFoundReport(context, yesterday, tomorrow, writer);
                writer.write("\n--------------------------------- Report Spacer ---------------------------\n\n");
                numBitstreams += reporter.getNotToBeProcessedReport(context, yesterday, tomorrow, writer);
                writer.write("\n--------------------------------- Report Spacer ---------------------------\n\n");
                writer.write("\n--------------------------------- End Report ---------------------------\n\n");
                writer.flush();
                writer.close();
                emailer.sendReport(report, numBitstreams += reporter.getUncheckedBitstreamsReport(context, writer));
            } else {
                if (line.hasOption("d")) {
                    writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                    writer.flush();
                    writer.close();
                    emailer.sendReport(report, numBitstreams += reporter.getDeletedBitstreamReport(context, yesterday, tomorrow, writer));
                }
                if (line.hasOption("m")) {
                    writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                    writer.flush();
                    writer.close();
                    emailer.sendReport(report, numBitstreams += reporter.getBitstreamNotFoundReport(context, yesterday, tomorrow, writer));
                }
                if (line.hasOption("c")) {
                    writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                    writer.flush();
                    writer.close();
                    emailer.sendReport(report, numBitstreams += reporter.getChangedChecksumReport(context, yesterday, tomorrow, writer));
                }
                if (line.hasOption("n")) {
                    writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                    writer.flush();
                    writer.close();
                    emailer.sendReport(report, numBitstreams += reporter.getNotToBeProcessedReport(context, yesterday, tomorrow, writer));
                }
                if (line.hasOption("u")) {
                    writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                    writer.flush();
                    writer.close();
                    emailer.sendReport(report, numBitstreams += reporter.getUncheckedBitstreamsReport(context, writer));
                }
            }
        }
        catch (IOException | SQLException | MessagingException e) {
            log.fatal((Object)e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    log.fatal((Object)"Could not close writer", (Throwable)e);
                }
            }
            if (report != null && report.exists() && !report.delete()) {
                log.error((Object)"Unable to delete report file");
            }
        }
    }
}

