/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.dspace.core.ReloadableEntity;
import org.dspace.storage.rdbms.DatabaseConfigVO;

public interface DBConnection<T> {
    public T getSession() throws SQLException;

    public boolean isTransActionAlive();

    public boolean isSessionAlive();

    public void rollback() throws SQLException;

    public void closeDBConnection() throws SQLException;

    public void commit() throws SQLException;

    public void shutdown();

    public String getType();

    public DataSource getDataSource();

    public DatabaseConfigVO getDatabaseConfig() throws SQLException;

    public void setConnectionMode(boolean var1, boolean var2) throws SQLException;

    public boolean isOptimizedForBatchProcessing();

    public long getCacheSize() throws SQLException;

    public <E extends ReloadableEntity> E reloadEntity(E var1) throws SQLException;

    public <E extends ReloadableEntity> void uncacheEntity(E var1) throws SQLException;
}

