/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.curate.AbstractCurationTask;
import org.dspace.curate.Curator;
import org.dspace.curate.Suspendable;

@Suspendable
public class RequiredMetadata
extends AbstractCurationTask {
    protected DCInputsReader reader = null;
    protected Map<String, List<String>> reqMap = new HashMap<String, List<String>>();

    @Override
    public void init(Curator curator, String taskId) throws IOException {
        super.init(curator, taskId);
        try {
            this.reader = new DCInputsReader();
        }
        catch (DCInputsReaderException dcrE) {
            throw new IOException(dcrE.getMessage(), dcrE);
        }
    }

    @Override
    public int perform(DSpaceObject dso) throws IOException {
        if (dso.getType() == 2) {
            Item item = (Item)dso;
            int count = 0;
            try {
                StringBuilder sb = new StringBuilder();
                String handle = item.getHandle();
                if (handle == null) {
                    handle = "in workflow";
                }
                sb.append("Item: ").append(handle);
                for (String req : this.getReqList(item.getOwningCollection().getHandle())) {
                    List<MetadataValue> vals = this.itemService.getMetadataByMetadataString(item, req);
                    if (vals.size() != 0) continue;
                    sb.append(" missing required field: ").append(req);
                    ++count;
                }
                if (count == 0) {
                    sb.append(" has all required fields");
                }
                this.report(sb.toString());
                this.setResult(sb.toString());
            }
            catch (DCInputsReaderException dcrE) {
                throw new IOException(dcrE.getMessage(), dcrE);
            }
            return count == 0 ? 0 : 1;
        }
        this.setResult("Object skipped");
        return 2;
    }

    protected List<String> getReqList(String handle) throws DCInputsReaderException {
        List<String> reqList = this.reqMap.get(handle);
        if (reqList == null) {
            reqList = this.reqMap.get("default");
        }
        if (reqList == null) {
            reqList = new ArrayList<String>();
            DCInputSet inputs = this.reader.getInputs(handle);
            for (int i = 0; i < inputs.getNumberPages(); ++i) {
                for (DCInput input : inputs.getPageRows(i, true, true)) {
                    if (!input.isRequired()) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append(input.getSchema()).append(".");
                    sb.append(input.getElement()).append(".");
                    String qual = input.getQualifier();
                    if (qual == null) {
                        qual = "";
                    }
                    sb.append(qual);
                    reqList.add(sb.toString());
                }
            }
            this.reqMap.put(inputs.getFormName(), reqList);
        }
        return reqList;
    }
}

