/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.dspace.app.util.XMLUtils;
import org.dspace.core.ConfigurationManager;
import org.dspace.submit.lookup.PubmedUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PubmedService {
    private static final Logger log = Logger.getLogger(PubmedService.class);
    protected int timeout = 1000;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Record getByPubmedID(String pubmedid) throws HttpException, IOException, ParserConfigurationException, SAXException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pubmedid.trim());
        List<Record> items = this.getByPubmedIDs(ids);
        if (items != null && items.size() > 0) {
            return items.get(0);
        }
        return null;
    }

    public List<Record> search(String title, String author, int year) throws HttpException, IOException {
        StringBuffer query = new StringBuffer();
        if (StringUtils.isNotBlank((String)title)) {
            query.append("((").append(title).append("[TI]) OR (");
            query.append("(").append(title).append("[book]))");
        }
        if (StringUtils.isNotBlank((String)author)) {
            if (query.length() > 0) {
                query.append(" AND ");
            }
            query.append("(").append(author).append("[AU])");
        }
        if (year != -1) {
            if (query.length() > 0) {
                query.append(" AND ");
            }
            query.append(year).append("[DP]");
        }
        return this.search(query.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Record> search(String query) throws IOException, HttpException {
        List<Record> results = new ArrayList<Record>();
        if (!ConfigurationManager.getBooleanProperty("submission-lookup", "remoteservice.demo")) {
            HttpGet method = null;
            try {
                DefaultHttpClient client = new DefaultHttpClient();
                client.getParams().setIntParameter("http.connection.timeout", this.timeout);
                URIBuilder uriBuilder = new URIBuilder("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi");
                uriBuilder.addParameter("db", "pubmed");
                uriBuilder.addParameter("datetype", "edat");
                uriBuilder.addParameter("retmax", "10");
                uriBuilder.addParameter("term", query);
                method = new HttpGet(uriBuilder.build());
                HttpResponse response = client.execute((HttpUriRequest)method);
                StatusLine statusLine = response.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                if (statusCode != 200) {
                    throw new RuntimeException("WS call failed: " + statusLine);
                }
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                factory.setIgnoringElementContentWhitespace(true);
                try {
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document inDoc = builder.parse(response.getEntity().getContent());
                    Element xmlRoot = inDoc.getDocumentElement();
                    Element idList = XMLUtils.getSingleElement(xmlRoot, "IdList");
                    List<String> pubmedIDs = XMLUtils.getElementValueList(idList, "Id");
                    results = this.getByPubmedIDs(pubmedIDs);
                }
                catch (ParserConfigurationException e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
                catch (SAXException e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        } else {
            InputStream stream = null;
            try {
                File file = new File(ConfigurationManager.getProperty("dspace.dir") + "/config/crosswalks/demo/pubmed-search.xml");
                stream = new FileInputStream(file);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                factory.setIgnoringElementContentWhitespace(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document inDoc = builder.parse(stream);
                Element xmlRoot = inDoc.getDocumentElement();
                Element idList = XMLUtils.getSingleElement(xmlRoot, "IdList");
                List<String> pubmedIDs = XMLUtils.getElementValueList(idList, "Id");
                results = this.getByPubmedIDs(pubmedIDs);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Record> getByPubmedIDs(List<String> pubmedIDs) throws HttpException, IOException, ParserConfigurationException, SAXException {
        ArrayList<Record> results = new ArrayList<Record>();
        HttpGet method = null;
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            client.getParams().setIntParameter("http.connection.timeout", 5 * this.timeout);
            try {
                URIBuilder uriBuilder = new URIBuilder("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi");
                uriBuilder.addParameter("db", "pubmed");
                uriBuilder.addParameter("retmode", "xml");
                uriBuilder.addParameter("rettype", "full");
                uriBuilder.addParameter("id", StringUtils.join(pubmedIDs.iterator(), (String)","));
                method = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException("Request not sent", ex);
            }
            HttpResponse response = client.execute((HttpUriRequest)method);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode != 200) {
                throw new RuntimeException("WS call failed: " + statusLine);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document inDoc = builder.parse(response.getEntity().getContent());
            Element xmlRoot = inDoc.getDocumentElement();
            List<Element> pubArticles = XMLUtils.getElementList(xmlRoot, "PubmedArticle");
            for (Element xmlArticle : pubArticles) {
                Record pubmedItem = null;
                try {
                    pubmedItem = PubmedUtils.convertPubmedDomToRecord(xmlArticle);
                    results.add(pubmedItem);
                }
                catch (Exception e) {
                    throw new RuntimeException("PubmedID is not valid or not exist: " + e.getMessage(), e);
                }
            }
            ArrayList<Record> arrayList = results;
            return arrayList;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public List<Record> search(String doi, String pmid) throws HttpException, IOException {
        StringBuffer query = new StringBuffer();
        if (StringUtils.isNotBlank((String)doi)) {
            query.append(doi);
            query.append("[AID]");
        }
        if (StringUtils.isNotBlank((String)pmid)) {
            if (query.length() > 0) {
                query.append(" OR ");
            }
            query.append(pmid).append("[PMID]");
        }
        return this.search(query.toString());
    }
}

