/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.dao.MetadataFieldDAO;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.springframework.beans.factory.annotation.Autowired;

public class MetadataFieldServiceImpl
implements MetadataFieldService {
    private static Logger log = Logger.getLogger(MetadataFieldServiceImpl.class);
    @Autowired(required=true)
    protected MetadataFieldDAO metadataFieldDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected MetadataValueService metadataValueService;

    protected MetadataFieldServiceImpl() {
    }

    @Override
    public MetadataField create(Context context, MetadataSchema metadataSchema, String element, String qualifier, String scopeNote) throws AuthorizeException, SQLException, NonUniqueMetadataException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modify the metadata registry");
        }
        if (this.hasElement(context, -1, metadataSchema, element, qualifier)) {
            throw new NonUniqueMetadataException("Please make " + element + "." + qualifier + " unique within schema #" + metadataSchema.getID());
        }
        MetadataField metadataField = new MetadataField();
        metadataField.setElement(element);
        metadataField.setQualifier(qualifier);
        metadataField.setScopeNote(scopeNote);
        metadataField.setMetadataSchema(metadataSchema);
        metadataField = this.metadataFieldDAO.create(context, metadataField);
        this.metadataFieldDAO.save(context, metadataField);
        log.info((Object)LogManager.getHeader(context, "create_metadata_field", "metadata_field_id=" + metadataField.getID()));
        return metadataField;
    }

    @Override
    public MetadataField find(Context context, int id) throws SQLException {
        return (MetadataField)this.metadataFieldDAO.findByID(context, MetadataField.class, id);
    }

    @Override
    public MetadataField findByElement(Context context, MetadataSchema metadataSchema, String element, String qualifier) throws SQLException {
        return this.metadataFieldDAO.findByElement(context, metadataSchema, element, qualifier);
    }

    @Override
    public MetadataField findByElement(Context context, String metadataSchemaName, String element, String qualifier) throws SQLException {
        return this.metadataFieldDAO.findByElement(context, metadataSchemaName, element, qualifier);
    }

    @Override
    public List<MetadataField> findFieldsByElementNameUnqualified(Context context, String metadataSchemaName, String element) throws SQLException {
        return this.metadataFieldDAO.findFieldsByElementNameUnqualified(context, metadataSchemaName, element);
    }

    @Override
    public List<MetadataField> findAll(Context context) throws SQLException {
        return this.metadataFieldDAO.findAll(context, MetadataField.class);
    }

    @Override
    public List<MetadataField> findAllInSchema(Context context, MetadataSchema metadataSchema) throws SQLException {
        return this.metadataFieldDAO.findAllInSchema(context, metadataSchema);
    }

    @Override
    public void update(Context context, MetadataField metadataField) throws SQLException, AuthorizeException, NonUniqueMetadataException, IOException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modiffy the Dublin Core registry");
        }
        if (this.hasElement(context, metadataField.getID(), metadataField.getMetadataSchema(), metadataField.getElement(), metadataField.getQualifier())) {
            throw new NonUniqueMetadataException("Please make " + metadataField.getMetadataSchema().getName() + "." + metadataField.getElement() + "." + metadataField.getQualifier());
        }
        this.metadataFieldDAO.save(context, metadataField);
        log.info((Object)LogManager.getHeader(context, "update_metadatafieldregistry", "metadata_field_id=" + metadataField.getID() + "element=" + metadataField.getElement() + "qualifier=" + metadataField.getQualifier()));
    }

    @Override
    public void delete(Context context, MetadataField metadataField) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modify the metadata registry");
        }
        List<MetadataValue> values = null;
        try {
            values = this.metadataValueService.findByField(context, metadataField);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!CollectionUtils.isEmpty(values)) {
            throw new IllegalStateException("Metadata field " + metadataField.toString() + " cannot be deleted as it is currently used by one or more objects.");
        }
        this.metadataFieldDAO.delete(context, metadataField);
        log.info((Object)LogManager.getHeader(context, "delete_metadata_field", "metadata_field_id=" + metadataField.getID()));
    }

    protected boolean hasElement(Context context, int fieldId, MetadataSchema metadataSchema, String element, String qualifier) throws SQLException {
        return this.metadataFieldDAO.find(context, fieldId, metadataSchema, element, qualifier) != null;
    }
}

