/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.dspace.content.Community;
import org.dspace.content.MetadataField;
import org.dspace.content.dao.CommunityDAO;
import org.dspace.core.AbstractHibernateDSODAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;

public class CommunityDAOImpl
extends AbstractHibernateDSODAO<Community>
implements CommunityDAO {
    protected CommunityDAOImpl() {
    }

    @Override
    public List<Community> findAll(Context context, MetadataField sortField) throws SQLException {
        return this.findAll(context, sortField, null, null);
    }

    @Override
    public List<Community> findAll(Context context, MetadataField sortField, Integer limit, Integer offset) throws SQLException {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT ").append(Community.class.getSimpleName()).append(" FROM Community as ").append(Community.class.getSimpleName()).append(" ");
        this.addMetadataLeftJoin(queryBuilder, Community.class.getSimpleName(), Arrays.asList(sortField));
        this.addMetadataSortQuery(queryBuilder, Arrays.asList(sortField), ListUtils.EMPTY_LIST);
        Query query = this.createQuery(context, queryBuilder.toString());
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        query.setParameter(sortField.toString(), (Object)sortField.getID());
        return this.list(query);
    }

    @Override
    public Community findByAdminGroup(Context context, Group group) throws SQLException {
        Criteria criteria = this.createCriteria(context, Community.class);
        criteria.add((Criterion)Restrictions.eq((String)"admins", (Object)group));
        return (Community)this.singleResult(criteria);
    }

    @Override
    public List<Community> findAllNoParent(Context context, MetadataField sortField) throws SQLException {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT community FROM Community as community ");
        this.addMetadataLeftJoin(queryBuilder, Community.class.getSimpleName().toLowerCase(), Arrays.asList(sortField));
        this.addMetadataValueWhereQuery(queryBuilder, ListUtils.EMPTY_LIST, null, " community.parentCommunities IS EMPTY");
        this.addMetadataSortQuery(queryBuilder, Arrays.asList(sortField), ListUtils.EMPTY_LIST);
        Query query = this.createQuery(context, queryBuilder.toString());
        query.setParameter(sortField.toString(), (Object)sortField.getID());
        query.setCacheable(true);
        return this.findMany(context, query);
    }

    @Override
    public List<Community> findAuthorized(Context context, EPerson ePerson, List<Integer> actions) throws SQLException {
        Criteria criteria = this.createCriteria(context, Community.class);
        criteria.createAlias("resourcePolicies", "resourcePolicy");
        Disjunction actionQuery = Restrictions.or((Criterion[])new Criterion[0]);
        for (Integer action : actions) {
            actionQuery.add((Criterion)Restrictions.eq((String)"resourcePolicy.actionId", (Object)action));
        }
        criteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"resourcePolicy.resourceTypeId", (Object)4), Restrictions.eq((String)"resourcePolicy.eperson", (Object)ePerson), actionQuery}));
        criteria.setCacheable(true);
        return this.list(criteria);
    }

    @Override
    public List<Community> findAuthorizedByGroup(Context context, EPerson ePerson, List<Integer> actions) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select c from Community c join c.resourcePolicies rp join rp.epersonGroup rpGroup WHERE ");
        for (int i = 0; i < actions.size(); ++i) {
            Integer action = actions.get(i);
            if (i != 0) {
                query.append(" AND ");
            }
            query.append("rp.actionId=").append(action);
        }
        query.append(" AND rp.resourceTypeId=").append(4);
        query.append(" AND rp.epersonGroup.id IN (select g.id from Group g where (from EPerson e where e.id = :eperson_id) in elements(epeople))");
        Query hibernateQuery = this.createQuery(context, query.toString());
        hibernateQuery.setParameter("eperson_id", (Object)ePerson.getID());
        hibernateQuery.setCacheable(true);
        return this.list(hibernateQuery);
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM Community"));
    }
}

