/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson.dao.impl;

import java.sql.SQLException;
import java.util.List;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.Group2GroupCache;
import org.dspace.eperson.dao.Group2GroupCacheDAO;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;

public class Group2GroupCacheDAOImpl
extends AbstractHibernateDAO<Group2GroupCache>
implements Group2GroupCacheDAO {
    protected Group2GroupCacheDAOImpl() {
    }

    @Override
    public List<Group2GroupCache> findByParent(Context context, Group group) throws SQLException {
        Criteria criteria = this.createCriteria(context, Group2GroupCache.class);
        criteria.add((Criterion)Restrictions.eq((String)"parent.id", (Object)group.getID()));
        criteria.setCacheable(true);
        return this.list(criteria);
    }

    @Override
    public List<Group2GroupCache> findByChildren(Context context, Iterable<Group> groups) throws SQLException {
        Criteria criteria = this.createCriteria(context, Group2GroupCache.class);
        Disjunction orDisjunction = Restrictions.or((Criterion[])new Criterion[0]);
        for (Group group : groups) {
            orDisjunction.add((Criterion)Restrictions.eq((String)"child.id", (Object)group.getID()));
        }
        criteria.add((Criterion)orDisjunction);
        criteria.setCacheable(true);
        return this.list(criteria);
    }

    @Override
    public Group2GroupCache findByParentAndChild(Context context, Group parent, Group child) throws SQLException {
        Query query = this.createQuery(context, "FROM Group2GroupCache g WHERE g.parent = :parentGroup AND g.child = :childGroup");
        query.setParameter("parentGroup", (Object)parent);
        query.setParameter("childGroup", (Object)child);
        query.setCacheable(true);
        return (Group2GroupCache)this.singleResult(query);
    }

    @Override
    public Group2GroupCache find(Context context, Group parent, Group child) throws SQLException {
        Criteria criteria = this.createCriteria(context, Group2GroupCache.class);
        criteria.add((Criterion)Restrictions.eq((String)"parent.id", (Object)parent.getID()));
        criteria.add((Criterion)Restrictions.eq((String)"child.id", (Object)child.getID()));
        criteria.setCacheable(true);
        return (Group2GroupCache)this.uniqueResult(criteria);
    }

    @Override
    public void deleteAll(Context context) throws SQLException {
        this.createQuery(context, "delete from Group2GroupCache").executeUpdate();
    }
}

