/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.xmlworkflow.RoleMembers;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.service.WorkflowRequirementsService;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.storedcomponents.InProgressUser;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.InProgressUserService;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkflowRequirementsServiceImpl
implements WorkflowRequirementsService {
    @Autowired(required=true)
    protected InProgressUserService inProgressUserService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected PoolTaskService poolTaskService;
    @Autowired(required=true)
    protected XmlWorkflowFactory workflowFactory;
    @Autowired(required=true)
    protected XmlWorkflowItemService xmlWorkflowItemService;
    @Autowired(required=true)
    protected XmlWorkflowService xmlWorkflowService;

    protected WorkflowRequirementsServiceImpl() {
    }

    @Override
    public void addClaimedUser(Context context, XmlWorkflowItem wfi, Step step, EPerson user) throws SQLException, AuthorizeException, IOException {
        PoolTask task = this.poolTaskService.findByWorkflowIdAndEPerson(context, wfi, user);
        if (task != null && task.getEperson() != null) {
            this.xmlWorkflowService.deletePooledTask(context, wfi, task);
        }
        InProgressUser ipu = (InProgressUser)this.inProgressUserService.create(context);
        ipu.setWorkflowItem(wfi);
        ipu.setUser(user);
        ipu.setFinished(false);
        this.inProgressUserService.update(context, ipu);
        this.xmlWorkflowService.grantUserAllItemPolicies(context, wfi.getItem(), user);
        int totalUsers = this.inProgressUserService.getNumberOfInProgressUsers(context, wfi) + this.inProgressUserService.getNumberOfFinishedUsers(context, wfi);
        if (totalUsers == step.getRequiredUsers()) {
            this.xmlWorkflowService.deleteAllPooledTasks(context, wfi);
        }
        this.xmlWorkflowItemService.update(context, wfi);
    }

    @Override
    public void removeClaimedUser(Context context, XmlWorkflowItem wfi, EPerson user, String stepID) throws SQLException, IOException, WorkflowConfigurationException, AuthorizeException {
        int totalUsers = this.inProgressUserService.getNumberOfInProgressUsers(context, wfi) + this.inProgressUserService.getNumberOfFinishedUsers(context, wfi);
        this.inProgressUserService.delete(context, this.inProgressUserService.findByWorkflowItemAndEPerson(context, wfi, user));
        this.xmlWorkflowService.removeUserItemPolicies(context, wfi.getItem(), user);
        Workflow workflow = this.workflowFactory.getWorkflow(wfi.getCollection());
        Step step = workflow.getStep(stepID);
        if (totalUsers == step.getRequiredUsers()) {
            List<InProgressUser> toIgnore = this.inProgressUserService.findByWorkflowItem(context, wfi);
            RoleMembers roleMembers = step.getRole().getMembers(context, wfi);
            for (InProgressUser ipu : toIgnore) {
                roleMembers.removeEperson(ipu.getUser());
            }
            step.getUserSelectionMethod().getProcessingAction().regenerateTasks(context, wfi, roleMembers);
        } else {
            RoleMembers role = step.getRole().getMembers(context, wfi);
            ArrayList<EPerson> epersons = role.getEPersons();
            for (EPerson eperson : epersons) {
                if (!eperson.getID().equals(user.getID())) continue;
                RoleMembers memberToRegenerateTasksFor = new RoleMembers();
                memberToRegenerateTasksFor.addEPerson(user);
                step.getUserSelectionMethod().getProcessingAction().regenerateTasks(context, wfi, memberToRegenerateTasksFor);
                break;
            }
        }
        this.itemService.update(context, wfi.getItem());
    }

    @Override
    public void addFinishedUser(Context c, XmlWorkflowItem wfi, EPerson user) throws AuthorizeException, SQLException {
        InProgressUser ipu = this.inProgressUserService.findByWorkflowItemAndEPerson(c, wfi, user);
        ipu.setFinished(true);
        this.inProgressUserService.update(c, ipu);
    }

    @Override
    public void clearInProgressUsers(Context c, XmlWorkflowItem wfi) throws AuthorizeException, SQLException {
        Iterator<InProgressUser> ipus = this.inProgressUserService.findByWorkflowItem(c, wfi).iterator();
        while (ipus.hasNext()) {
            InProgressUser ipu = ipus.next();
            ipus.remove();
            this.inProgressUserService.delete(c, ipu);
        }
    }
}

