/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectLegacySupport;
import org.dspace.content.Item;
import org.dspace.content.comparator.NameAscendingComparator;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.proxy.HibernateProxyHelper;

@Entity
@Table(name="collection")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, include="non-lazy")
public class Collection
extends DSpaceObject
implements DSpaceObjectLegacySupport {
    @Column(name="collection_id", insertable=false, updatable=false)
    private Integer legacyId;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="logo_bitstream_id")
    private Bitstream logo;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="template_item_id")
    private Item template;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="workflow_step_1")
    private Group workflowStep1;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="workflow_step_2")
    private Group workflowStep2;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="workflow_step_3")
    private Group workflowStep3;
    @OneToOne
    @JoinColumn(name="submitter")
    private Group submitters;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="admin")
    private Group admins;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinTable(name="community2collection", joinColumns={@JoinColumn(name="collection_id")}, inverseJoinColumns={@JoinColumn(name="community_id")})
    private Set<Community> communities = new HashSet<Community>();
    @Transient
    private transient CollectionService collectionService;
    @Transient
    public static final String COPYRIGHT_TEXT = "copyright_text";
    @Transient
    public static final String INTRODUCTORY_TEXT = "introductory_text";
    @Transient
    public static final String SHORT_DESCRIPTION = "short_description";
    @Transient
    public static final String SIDEBAR_TEXT = "side_bar_text";
    @Transient
    public static final String PROVENANCE_TEXT = "provenance_description";

    protected Collection() {
    }

    @Override
    public String getName() {
        String value = this.getCollectionService().getMetadataFirstValue(this, "dc", "title", null, "*");
        return value == null ? "" : value;
    }

    public Bitstream getLogo() {
        return this.logo;
    }

    protected void setLogo(Bitstream logo) {
        this.logo = logo;
        this.setModified();
    }

    public Group getSubmitters() {
        return this.submitters;
    }

    void setSubmitters(Group submitters) {
        this.submitters = submitters;
        this.setModified();
    }

    public Group getAdministrators() {
        return this.admins;
    }

    void setAdmins(Group admins) {
        this.admins = admins;
        this.setModified();
    }

    public Group getWorkflowStep1() {
        return this.workflowStep1;
    }

    public Group getWorkflowStep2() {
        return this.workflowStep2;
    }

    public Group getWorkflowStep3() {
        return this.workflowStep3;
    }

    void setWorkflowStep1(Group workflowStep1) {
        this.workflowStep1 = workflowStep1;
        this.setModified();
    }

    void setWorkflowStep2(Group workflowStep2) {
        this.workflowStep2 = workflowStep2;
        this.setModified();
    }

    void setWorkflowStep3(Group workflowStep3) {
        this.workflowStep3 = workflowStep3;
        this.setModified();
    }

    public String getLicenseCollection() {
        return this.getCollectionService().getMetadata(this, "license");
    }

    public void setLicense(Context context, String license) throws SQLException {
        this.getCollectionService().setMetadata(context, this, "license", license);
    }

    public Item getTemplateItem() throws SQLException {
        return this.template;
    }

    void setTemplateItem(Item template) {
        this.template = template;
        this.setModified();
    }

    public List<Community> getCommunities() throws SQLException {
        Community[] output = this.communities.toArray(new Community[0]);
        Arrays.sort(output, new NameAscendingComparator());
        return Arrays.asList(output);
    }

    void addCommunity(Community community) {
        this.communities.add(community);
        this.setModified();
    }

    void removeCommunity(Community community) {
        this.communities.remove(community);
        this.setModified();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)other);
        if (this.getClass() != objClass) {
            return false;
        }
        Collection otherCollection = (Collection)other;
        return this.getID().equals(otherCollection.getID());
    }

    public int hashCode() {
        int hash = 5;
        hash += 71 * hash + this.getType();
        hash += 71 * hash + this.getID().hashCode();
        return hash;
    }

    @Override
    public int getType() {
        return 3;
    }

    public void setWorkflowGroup(Context context, int step, Group g) throws SQLException, AuthorizeException {
        this.getCollectionService().setWorkflowGroup(context, this, step, g);
    }

    @Override
    public Integer getLegacyId() {
        return this.legacyId;
    }

    private CollectionService getCollectionService() {
        if (this.collectionService == null) {
            this.collectionService = ContentServiceFactory.getInstance().getCollectionService();
        }
        return this.collectionService;
    }
}

