/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectServiceImpl;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.Thumbnail;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.authority.Choices;
import org.dspace.content.dao.ItemDAO;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.event.Event;
import org.dspace.harvest.HarvestedItem;
import org.dspace.harvest.service.HarvestedItemService;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.service.IdentifierService;
import org.dspace.services.ConfigurationService;
import org.dspace.versioning.service.VersioningService;
import org.dspace.workflow.WorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class ItemServiceImpl
extends DSpaceObjectServiceImpl<Item>
implements ItemService {
    private static final Logger log = Logger.getLogger(Item.class);
    @Autowired(required=true)
    protected ItemDAO itemDAO;
    @Autowired(required=true)
    protected CommunityService communityService;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected BundleService bundleService;
    @Autowired(required=true)
    protected BitstreamFormatService bitstreamFormatService;
    @Autowired(required=true)
    protected MetadataSchemaService metadataSchemaService;
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected InstallItemService installItemService;
    @Autowired(required=true)
    protected ResourcePolicyService resourcePolicyService;
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected IdentifierService identifierService;
    @Autowired(required=true)
    protected VersioningService versioningService;
    @Autowired(required=true)
    protected HarvestedItemService harvestedItemService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected WorkspaceItemService workspaceItemService;
    @Autowired(required=true)
    protected WorkflowItemService workflowItemService;

    protected ItemServiceImpl() {
    }

    @Override
    public Thumbnail getThumbnail(Context context, Item item, boolean requireOriginal) throws SQLException {
        Bitstream thumbBitstream;
        List<Bundle> originalBundles = this.getBundles(item, "ORIGINAL");
        Bitstream primaryBitstream = null;
        if (CollectionUtils.isNotEmpty(originalBundles)) {
            primaryBitstream = originalBundles.get(0).getPrimaryBitstream();
        }
        if (primaryBitstream != null) {
            if (primaryBitstream.getFormat(context).getMIMEType().equals("text/html")) {
                return null;
            }
            thumbBitstream = this.bitstreamService.getBitstreamByName(item, "THUMBNAIL", primaryBitstream.getName() + ".jpg");
        } else {
            if (requireOriginal) {
                primaryBitstream = this.bitstreamService.getFirstBitstream(item, "ORIGINAL");
            }
            thumbBitstream = this.bitstreamService.getFirstBitstream(item, "THUMBNAIL");
        }
        if (thumbBitstream != null) {
            return new Thumbnail(thumbBitstream, primaryBitstream);
        }
        return null;
    }

    @Override
    public Item find(Context context, UUID id) throws SQLException {
        Item item = (Item)this.itemDAO.findByID(context, Item.class, id);
        if (item == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_item", "not_found,item_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_item", "item_id=" + id));
        }
        return item;
    }

    @Override
    public Item create(Context context, WorkspaceItem workspaceItem) throws SQLException, AuthorizeException {
        if (workspaceItem.getItem() != null) {
            throw new IllegalArgumentException("Attempting to create an item for a workspace item that already contains an item");
        }
        Item item = this.createItem(context);
        workspaceItem.setItem(item);
        log.info((Object)LogManager.getHeader(context, "create_item", "item_id=" + item.getID()));
        return item;
    }

    @Override
    public Item createTemplateItem(Context context, Collection collection) throws SQLException, AuthorizeException {
        if (collection == null || collection.getTemplateItem() != null) {
            throw new IllegalArgumentException("Collection is null or already contains template item.");
        }
        AuthorizeUtil.authorizeManageTemplateItem(context, collection);
        if (collection.getTemplateItem() == null) {
            Item template = this.createItem(context);
            collection.setTemplateItem(template);
            template.setTemplateItemOf(collection);
            log.info((Object)LogManager.getHeader(context, "create_template_item", "collection_id=" + collection.getID() + ",template_item_id=" + template.getID()));
            return template;
        }
        return collection.getTemplateItem();
    }

    @Override
    public Iterator<Item> findAll(Context context) throws SQLException {
        return this.itemDAO.findAll(context, true);
    }

    @Override
    public Iterator<Item> findAllUnfiltered(Context context) throws SQLException {
        return this.itemDAO.findAll(context, true, true);
    }

    @Override
    public Iterator<Item> findBySubmitter(Context context, EPerson eperson) throws SQLException {
        return this.itemDAO.findBySubmitter(context, eperson);
    }

    @Override
    public Iterator<Item> findBySubmitterDateSorted(Context context, EPerson eperson, Integer limit) throws SQLException {
        MetadataField metadataField = this.metadataFieldService.findByElement(context, "dc", "date", "accessioned");
        if (metadataField == null) {
            throw new IllegalArgumentException("Required metadata field 'dc.date.accessioned' doesn't exist!");
        }
        return this.itemDAO.findBySubmitter(context, eperson, metadataField, limit);
    }

    @Override
    public Iterator<Item> findByCollection(Context context, Collection collection) throws SQLException {
        return this.findByCollection(context, collection, null, null);
    }

    @Override
    public Iterator<Item> findByCollection(Context context, Collection collection, Integer limit, Integer offset) throws SQLException {
        return this.itemDAO.findArchivedByCollection(context, collection, limit, offset);
    }

    @Override
    public Iterator<Item> findAllByCollection(Context context, Collection collection) throws SQLException {
        return this.itemDAO.findAllByCollection(context, collection);
    }

    @Override
    public Iterator<Item> findAllByCollection(Context context, Collection collection, Integer limit, Integer offset) throws SQLException {
        return this.itemDAO.findAllByCollection(context, collection, limit, offset);
    }

    @Override
    public Iterator<Item> findInArchiveOrWithdrawnDiscoverableModifiedSince(Context context, Date since) throws SQLException {
        return this.itemDAO.findAll(context, true, true, true, since);
    }

    @Override
    public Iterator<Item> findInArchiveOrWithdrawnNonDiscoverableModifiedSince(Context context, Date since) throws SQLException {
        return this.itemDAO.findAll(context, true, true, false, since);
    }

    @Override
    public void updateLastModified(Context context, Item item) throws SQLException, AuthorizeException {
        item.setLastModified(new Date());
        this.update(context, item);
        context.addEvent(new Event(2, 2, item.getID(), null, this.getIdentifiers(context, item)));
    }

    @Override
    public boolean isIn(Item item, Collection collection) throws SQLException {
        List<Collection> collections = item.getCollections();
        return collections != null && collections.contains(collection);
    }

    @Override
    public List<Community> getCommunities(Context context, Item item) throws SQLException {
        ArrayList<Community> result = new ArrayList<Community>();
        List<Collection> collections = item.getCollections();
        for (Collection collection : collections) {
            result.addAll(this.communityService.getAllParents(context, collection));
        }
        return result;
    }

    @Override
    public List<Bundle> getBundles(Item item, String name) throws SQLException {
        ArrayList<Bundle> matchingBundles = new ArrayList<Bundle>();
        List<Bundle> bunds = item.getBundles();
        for (Bundle bund : bunds) {
            if (!name.equals(bund.getName())) continue;
            matchingBundles.add(bund);
        }
        return matchingBundles;
    }

    @Override
    public void addBundle(Context context, Item item, Bundle bundle) throws SQLException, AuthorizeException {
        this.authorizeService.authorizeAction(context, item, 3);
        log.info((Object)LogManager.getHeader(context, "add_bundle", "item_id=" + item.getID() + ",bundle_id=" + bundle.getID()));
        if (item.getBundles().contains(bundle)) {
            return;
        }
        this.authorizeService.inheritPolicies(context, item, bundle);
        item.addBundle(bundle);
        bundle.addItem(item);
        context.addEvent(new Event(8, 2, item.getID(), 1, bundle.getID(), bundle.getName(), this.getIdentifiers(context, item)));
    }

    @Override
    public void removeBundle(Context context, Item item, Bundle bundle) throws SQLException, AuthorizeException, IOException {
        this.authorizeService.authorizeAction(context, item, 4);
        log.info((Object)LogManager.getHeader(context, "remove_bundle", "item_id=" + item.getID() + ",bundle_id=" + bundle.getID()));
        context.addEvent(new Event(16, 2, item.getID(), 1, bundle.getID(), bundle.getName(), this.getIdentifiers(context, item)));
        this.bundleService.delete(context, bundle);
    }

    @Override
    public Bitstream createSingleBitstream(Context context, InputStream is, Item item, String name) throws AuthorizeException, IOException, SQLException {
        Bundle bnd = this.bundleService.create(context, item, name);
        Bitstream bitstream = this.bitstreamService.create(context, bnd, is);
        this.addBundle(context, item, bnd);
        return bitstream;
    }

    @Override
    public Bitstream createSingleBitstream(Context context, InputStream is, Item item) throws AuthorizeException, IOException, SQLException {
        return this.createSingleBitstream(context, is, item, "ORIGINAL");
    }

    @Override
    public List<Bitstream> getNonInternalBitstreams(Context context, Item item) throws SQLException {
        ArrayList<Bitstream> bitstreamList = new ArrayList<Bitstream>();
        List<Bundle> bunds = item.getBundles();
        for (Bundle bund : bunds) {
            List<Bitstream> bitstreams = bund.getBitstreams();
            for (Bitstream bitstream : bitstreams) {
                if (bitstream.getFormat(context).isInternal()) continue;
                bitstreamList.add(bitstream);
            }
        }
        return bitstreamList;
    }

    protected Item createItem(Context context) throws SQLException, AuthorizeException {
        Item item = this.itemDAO.create(context, new Item());
        item.setDiscoverable(true);
        context.turnOffAuthorisationSystem();
        this.update(context, item);
        context.restoreAuthSystemState();
        context.addEvent(new Event(1, 2, item.getID(), null, this.getIdentifiers(context, item)));
        log.info((Object)LogManager.getHeader(context, "create_item", "item_id=" + item.getID()));
        return item;
    }

    @Override
    public void removeDSpaceLicense(Context context, Item item) throws SQLException, AuthorizeException, IOException {
        List<Bundle> bunds = this.getBundles(item, "LICENSE");
        for (Bundle bund : bunds) {
            this.removeBundle(context, item, bund);
        }
    }

    @Override
    public void removeLicenses(Context context, Item item) throws SQLException, AuthorizeException, IOException {
        BitstreamFormat bf = this.bitstreamFormatService.findByShortDescription(context, "License");
        int licensetype = bf.getID();
        List<Bundle> bunds = item.getBundles();
        for (Bundle bund : bunds) {
            boolean removethisbundle = false;
            List<Bitstream> bits = bund.getBitstreams();
            for (Bitstream bit : bits) {
                BitstreamFormat bft = bit.getFormat(context);
                if (bft.getID() != licensetype) continue;
                removethisbundle = true;
            }
            if (!removethisbundle) continue;
            this.removeBundle(context, item, bund);
        }
    }

    @Override
    public void update(Context context, Item item) throws SQLException, AuthorizeException {
        List<Bitstream> streams;
        if (!this.canEdit(context, item)) {
            this.authorizeService.authorizeAction(context, item, 1);
        }
        log.info((Object)LogManager.getHeader(context, "update_item", "item_id=" + item.getID()));
        super.update(context, item);
        int sequence = 0;
        List<Bundle> bunds = item.getBundles();
        for (Bundle bund : bunds) {
            streams = bund.getBitstreams();
            for (Bitstream bitstream : streams) {
                if (bitstream.getSequenceID() <= sequence) continue;
                sequence = bitstream.getSequenceID();
            }
        }
        ++sequence;
        for (Bundle bund : bunds) {
            streams = bund.getBitstreams();
            for (Bitstream stream : streams) {
                if (stream.getSequenceID() >= 0) continue;
                stream.setSequenceID(sequence);
                ++sequence;
                this.bitstreamService.update(context, stream);
            }
        }
        if (item.isMetadataModified() || item.isModified()) {
            item.setLastModified(new Date());
            this.itemDAO.save(context, item);
            if (item.isMetadataModified()) {
                context.addEvent(new Event(4, item.getType(), item.getID(), item.getDetails(), this.getIdentifiers(context, item)));
            }
            context.addEvent(new Event(2, 2, item.getID(), null, this.getIdentifiers(context, item)));
            item.clearModified();
            item.clearDetails();
        }
    }

    @Override
    public void withdraw(Context context, Item item) throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeWithdrawItem(context, item);
        String timestamp = DCDate.getCurrent().toString();
        EPerson e = context.getCurrentUser();
        StringBuilder prov = new StringBuilder();
        prov.append("Item withdrawn by ").append(e.getFullName()).append(" (").append(e.getEmail()).append(") on ").append(timestamp).append("\n").append("Item was in collections:\n");
        List<Collection> colls = item.getCollections();
        for (Collection coll : colls) {
            prov.append(coll.getName()).append(" (ID: ").append(coll.getID()).append(")\n");
        }
        item.setWithdrawn(true);
        item.setArchived(false);
        prov.append(this.installItemService.getBitstreamProvenanceMessage(context, item));
        this.addMetadata(context, item, "dc", "description", "provenance", "en", prov.toString());
        this.update(context, item);
        context.addEvent(new Event(2, 2, item.getID(), "WITHDRAW", this.getIdentifiers(context, item)));
        this.authorizeService.switchPoliciesAction(context, item, 0, 12);
        for (Bundle bnd : item.getBundles()) {
            this.authorizeService.switchPoliciesAction(context, bnd, 0, 12);
            for (Bitstream bs : bnd.getBitstreams()) {
                this.authorizeService.switchPoliciesAction(context, bs, 0, 12);
            }
        }
        log.info((Object)LogManager.getHeader(context, "withdraw_item", "user=" + e.getEmail() + ",item_id=" + item.getID()));
    }

    @Override
    public void reinstate(Context context, Item item) throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeReinstateItem(context, item);
        String timestamp = DCDate.getCurrent().toString();
        List<Collection> colls = item.getCollections();
        EPerson e = context.getCurrentUser();
        StringBuilder prov = new StringBuilder();
        prov.append("Item reinstated by ").append(e.getFullName()).append(" (").append(e.getEmail()).append(") on ").append(timestamp).append("\n").append("Item was in collections:\n");
        for (Collection coll : colls) {
            prov.append(coll.getName()).append(" (ID: ").append(coll.getID()).append(")\n");
        }
        item.setWithdrawn(false);
        item.setArchived(true);
        prov.append(this.installItemService.getBitstreamProvenanceMessage(context, item));
        this.addMetadata(context, item, "dc", "description", "provenance", "en", prov.toString());
        this.update(context, item);
        context.addEvent(new Event(2, 2, item.getID(), "REINSTATE", this.getIdentifiers(context, item)));
        for (Bundle bnd : item.getBundles()) {
            this.authorizeService.switchPoliciesAction(context, bnd, 12, 0);
            for (Bitstream bs : bnd.getBitstreams()) {
                this.authorizeService.switchPoliciesAction(context, bs, 12, 0);
            }
        }
        if (this.authorizeService.getPoliciesActionFilter(context, item, 12).size() != 0) {
            this.authorizeService.switchPoliciesAction(context, item, 12, 0);
        } else if (colls.size() > 0) {
            this.adjustItemPolicies(context, item, item.getOwningCollection());
        }
        log.info((Object)LogManager.getHeader(context, "reinstate_item", "user=" + e.getEmail() + ",item_id=" + item.getID()));
    }

    @Override
    public void delete(Context context, Item item) throws SQLException, AuthorizeException, IOException {
        this.authorizeService.authorizeAction(context, item, 2);
        this.rawDelete(context, item);
    }

    @Override
    public int getSupportsTypeConstant() {
        return 2;
    }

    protected void rawDelete(Context context, Item item) throws AuthorizeException, SQLException, IOException {
        this.authorizeService.authorizeAction(context, item, 4);
        context.addEvent(new Event(32, 2, item.getID(), item.getHandle(), this.getIdentifiers(context, item)));
        log.info((Object)LogManager.getHeader(context, "delete_item", "item_id=" + item.getID()));
        this.removeAllBundles(context, item);
        this.handleService.unbindHandle(context, item);
        this.removeVersion(context, item);
        HarvestedItem hi = this.harvestedItemService.find(context, item);
        if (hi != null) {
            this.harvestedItemService.delete(context, hi);
        }
        item.clearCollections();
        item.setOwningCollection(null);
        this.itemDAO.delete(context, item);
    }

    @Override
    public void removeAllBundles(Context context, Item item) throws AuthorizeException, SQLException, IOException {
        Iterator<Bundle> bundles = item.getBundles().iterator();
        while (bundles.hasNext()) {
            Bundle bundle = bundles.next();
            bundles.remove();
            this.deleteBundle(context, item, bundle);
        }
    }

    protected void deleteBundle(Context context, Item item, Bundle b) throws AuthorizeException, SQLException, IOException {
        this.authorizeService.authorizeAction(context, item, 4);
        this.bundleService.delete(context, b);
        log.info((Object)LogManager.getHeader(context, "remove_bundle", "item_id=" + item.getID() + ",bundle_id=" + b.getID()));
        context.addEvent(new Event(16, 2, item.getID(), 1, b.getID(), b.getName()));
    }

    protected void removeVersion(Context context, Item item) throws AuthorizeException, SQLException {
        if (this.versioningService.getVersion(context, item) != null) {
            this.versioningService.removeVersion(context, item);
        } else {
            try {
                this.identifierService.delete(context, item);
            }
            catch (IdentifierException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean isOwningCollection(Item item, Collection collection) {
        Collection owningCollection = item.getOwningCollection();
        return owningCollection != null && collection.getID().equals(owningCollection.getID());
    }

    @Override
    public void replaceAllItemPolicies(Context context, Item item, List<ResourcePolicy> newpolicies) throws SQLException, AuthorizeException {
        this.authorizeService.removeAllPolicies(context, item);
        this.authorizeService.addPolicies(context, newpolicies, item);
    }

    @Override
    public void replaceAllBitstreamPolicies(Context context, Item item, List<ResourcePolicy> newpolicies) throws SQLException, AuthorizeException {
        List<Bundle> bunds = item.getBundles();
        for (Bundle mybundle : bunds) {
            this.bundleService.replaceAllBitstreamPolicies(context, mybundle, newpolicies);
        }
    }

    @Override
    public void removeGroupPolicies(Context context, Item item, Group group) throws SQLException, AuthorizeException {
        this.authorizeService.removeGroupPolicies(context, item, group);
        List<Bundle> bunds = item.getBundles();
        for (Bundle mybundle : bunds) {
            List<Bitstream> bs = mybundle.getBitstreams();
            for (Bitstream bitstream : bs) {
                this.authorizeService.removeGroupPolicies(context, bitstream, group);
            }
            this.authorizeService.removeGroupPolicies(context, mybundle, group);
        }
    }

    @Override
    public void inheritCollectionDefaultPolicies(Context context, Item item, Collection collection) throws SQLException, AuthorizeException {
        this.adjustItemPolicies(context, item, collection);
        this.adjustBundleBitstreamPolicies(context, item, collection);
        log.debug((Object)LogManager.getHeader(context, "item_inheritCollectionDefaultPolicies", "item_id=" + item.getID()));
    }

    @Override
    public void adjustBundleBitstreamPolicies(Context context, Item item, Collection collection) throws SQLException, AuthorizeException {
        List<ResourcePolicy> defaultCollectionPolicies = this.authorizeService.getPoliciesActionFilter(context, collection, 9);
        if (defaultCollectionPolicies.size() < 1) {
            throw new SQLException("Collection " + collection.getID() + " (" + collection.getHandle() + ") has no default bitstream READ policies");
        }
        List<Bundle> bunds = item.getBundles();
        for (Bundle mybundle : bunds) {
            this.authorizeService.removeAllPoliciesByDSOAndType(context, mybundle, ResourcePolicy.TYPE_SUBMISSION);
            this.authorizeService.removeAllPoliciesByDSOAndType(context, mybundle, ResourcePolicy.TYPE_WORKFLOW);
            this.addDefaultPoliciesNotInPlace(context, mybundle, defaultCollectionPolicies);
            for (Bitstream bitstream : mybundle.getBitstreams()) {
                this.authorizeService.removeAllPoliciesByDSOAndType(context, bitstream, ResourcePolicy.TYPE_SUBMISSION);
                this.authorizeService.removeAllPoliciesByDSOAndType(context, bitstream, ResourcePolicy.TYPE_WORKFLOW);
                this.addDefaultPoliciesNotInPlace(context, bitstream, defaultCollectionPolicies);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustItemPolicies(Context context, Item item, Collection collection) throws SQLException, AuthorizeException {
        List<ResourcePolicy> defaultCollectionPolicies = this.authorizeService.getPoliciesActionFilter(context, collection, 10);
        if (defaultCollectionPolicies.size() < 1) {
            throw new SQLException("Collection " + collection.getID() + " (" + collection.getHandle() + ") has no default item READ policies");
        }
        try {
            context.turnOffAuthorisationSystem();
            this.authorizeService.removeAllPoliciesByDSOAndType(context, item, ResourcePolicy.TYPE_SUBMISSION);
            this.authorizeService.removeAllPoliciesByDSOAndType(context, item, ResourcePolicy.TYPE_WORKFLOW);
            this.addDefaultPoliciesNotInPlace(context, item, defaultCollectionPolicies);
        }
        finally {
            context.restoreAuthSystemState();
        }
    }

    @Override
    public void move(Context context, Item item, Collection from, Collection to) throws SQLException, AuthorizeException, IOException {
        this.move(context, item, from, to, false);
    }

    @Override
    public void move(Context context, Item item, Collection from, Collection to, boolean inheritDefaultPolicies) throws SQLException, AuthorizeException, IOException {
        if (!this.canEdit(context, item)) {
            this.authorizeService.authorizeAction(context, item, 1);
        }
        this.collectionService.addItem(context, to, item);
        this.collectionService.removeItem(context, from, item);
        if (this.isOwningCollection(item, from)) {
            log.info((Object)LogManager.getHeader(context, "move_item", "item_id=" + item.getID() + ", from collection_id=" + from.getID() + " to collection_id=" + to.getID()));
            item.setOwningCollection(to);
            if (inheritDefaultPolicies) {
                log.info((Object)LogManager.getHeader(context, "move_item", "Updating item with inherited policies"));
                this.inheritCollectionDefaultPolicies(context, item, to);
            }
            context.turnOffAuthorisationSystem();
            this.update(context, item);
            context.restoreAuthSystemState();
        } else {
            context.addEvent(new Event(2, 2, item.getID(), null, this.getIdentifiers(context, item)));
        }
    }

    @Override
    public boolean hasUploadedFiles(Item item) throws SQLException {
        List<Bundle> bundles = this.getBundles(item, "ORIGINAL");
        for (Bundle bundle : bundles) {
            if (!CollectionUtils.isNotEmpty(bundle.getBitstreams())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Collection> getCollectionsNotLinked(Context context, Item item) throws SQLException {
        List<Collection> allCollections = this.collectionService.findAll(context);
        List<Collection> linkedCollections = item.getCollections();
        ArrayList<Collection> notLinkedCollections = new ArrayList<Collection>(allCollections.size() - linkedCollections.size());
        if (allCollections.size() - linkedCollections.size() == 0) {
            return notLinkedCollections;
        }
        for (Collection collection : allCollections) {
            boolean alreadyLinked = false;
            for (Collection linkedCommunity : linkedCollections) {
                if (!collection.getID().equals(linkedCommunity.getID())) continue;
                alreadyLinked = true;
                break;
            }
            if (alreadyLinked) continue;
            notLinkedCollections.add(collection);
        }
        return notLinkedCollections;
    }

    @Override
    public boolean canEdit(Context context, Item item) throws SQLException {
        if (this.authorizeService.authorizeActionBoolean(context, item, 1)) {
            return true;
        }
        if (item.getOwningCollection() == null) {
            return !this.isInProgressSubmission(context, item);
        }
        return this.collectionService.canEditBoolean(context, item.getOwningCollection(), false);
    }

    @Override
    public boolean isInProgressSubmission(Context context, Item item) throws SQLException {
        return this.workspaceItemService.findByItem(context, item) != null || this.workflowItemService.findByItem(context, item) != null;
    }

    protected void addDefaultPoliciesNotInPlace(Context context, DSpaceObject dso, List<ResourcePolicy> defaultCollectionPolicies) throws SQLException, AuthorizeException {
        for (ResourcePolicy defaultPolicy : defaultCollectionPolicies) {
            if (this.authorizeService.isAnIdenticalPolicyAlreadyInPlace(context, dso, defaultPolicy.getGroup(), 0, defaultPolicy.getID())) continue;
            ResourcePolicy newPolicy = this.resourcePolicyService.clone(context, defaultPolicy);
            newPolicy.setdSpaceObject(dso);
            newPolicy.setAction(0);
            newPolicy.setRpType(ResourcePolicy.TYPE_INHERITED);
            this.resourcePolicyService.update(context, newPolicy);
        }
    }

    @Override
    public Iterator<Item> findByMetadataField(Context context, String schema, String element, String qualifier, String value) throws SQLException, AuthorizeException, IOException {
        MetadataSchema mds = this.metadataSchemaService.find(context, schema);
        if (mds == null) {
            throw new IllegalArgumentException("No such metadata schema: " + schema);
        }
        MetadataField mdf = this.metadataFieldService.findByElement(context, mds, element, qualifier);
        if (mdf == null) {
            throw new IllegalArgumentException("No such metadata field: schema=" + schema + ", element=" + element + ", qualifier=" + qualifier);
        }
        if ("*".equals(value)) {
            return this.itemDAO.findByMetadataField(context, mdf, null, true);
        }
        return this.itemDAO.findByMetadataField(context, mdf, value, true);
    }

    @Override
    public Iterator<Item> findByMetadataQuery(Context context, List<List<MetadataField>> listFieldList, List<String> query_op, List<String> query_val, List<UUID> collectionUuids, String regexClause, int offset, int limit) throws SQLException, AuthorizeException, IOException {
        return this.itemDAO.findByMetadataQuery(context, listFieldList, query_op, query_val, collectionUuids, regexClause, offset, limit);
    }

    @Override
    public DSpaceObject getAdminObject(Context context, Item item, int action) throws SQLException {
        DSpaceObject adminObject = null;
        Collection collection = (Collection)this.getParentObject(context, item);
        Community community = null;
        if (collection != null && CollectionUtils.isNotEmpty(collection.getCommunities())) {
            community = collection.getCommunities().get(0);
        }
        switch (action) {
            case 3: {
                if (AuthorizeConfiguration.canItemAdminPerformBitstreamCreation()) {
                    adminObject = item;
                    break;
                }
                if (AuthorizeConfiguration.canCollectionAdminPerformBitstreamCreation()) {
                    adminObject = collection;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminPerformBitstreamCreation()) break;
                adminObject = community;
                break;
            }
            case 4: {
                if (AuthorizeConfiguration.canItemAdminPerformBitstreamDeletion()) {
                    adminObject = item;
                    break;
                }
                if (AuthorizeConfiguration.canCollectionAdminPerformBitstreamDeletion()) {
                    adminObject = collection;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminPerformBitstreamDeletion()) break;
                adminObject = community;
                break;
            }
            case 2: {
                if (item.getOwningCollection() != null) {
                    if (AuthorizeConfiguration.canCollectionAdminPerformItemDeletion()) {
                        adminObject = collection;
                        break;
                    }
                    if (!AuthorizeConfiguration.canCommunityAdminPerformItemDeletion()) break;
                    adminObject = community;
                    break;
                }
                if (AuthorizeConfiguration.canCollectionAdminManageTemplateItem()) {
                    adminObject = collection;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminManageCollectionTemplateItem()) break;
                adminObject = community;
                break;
            }
            case 1: {
                if (item.getOwningCollection() == null) {
                    if (AuthorizeConfiguration.canCollectionAdminManageTemplateItem()) {
                        adminObject = collection;
                        break;
                    }
                    if (!AuthorizeConfiguration.canCommunityAdminManageCollectionTemplateItem()) break;
                    adminObject = community;
                    break;
                }
                adminObject = item;
                break;
            }
            default: {
                adminObject = item;
            }
        }
        return adminObject;
    }

    @Override
    public DSpaceObject getParentObject(Context context, Item item) throws SQLException {
        Collection ownCollection = item.getOwningCollection();
        if (ownCollection != null) {
            return ownCollection;
        }
        return item.getTemplateItemOf();
    }

    @Override
    public Iterator<Item> findByAuthorityValue(Context context, String schema, String element, String qualifier, String value) throws SQLException, AuthorizeException {
        MetadataSchema mds = this.metadataSchemaService.find(context, schema);
        if (mds == null) {
            throw new IllegalArgumentException("No such metadata schema: " + schema);
        }
        MetadataField mdf = this.metadataFieldService.findByElement(context, mds, element, qualifier);
        if (mdf == null) {
            throw new IllegalArgumentException("No such metadata field: schema=" + schema + ", element=" + element + ", qualifier=" + qualifier);
        }
        return this.itemDAO.findByAuthorityValue(context, mdf, value, true);
    }

    @Override
    public Iterator<Item> findByMetadataFieldAuthority(Context context, String mdString, String authority) throws SQLException, AuthorizeException {
        String[] elements = this.getElementsFilled(mdString);
        String schema = elements[0];
        String element = elements[1];
        String qualifier = elements[2];
        MetadataSchema mds = this.metadataSchemaService.find(context, schema);
        if (mds == null) {
            throw new IllegalArgumentException("No such metadata schema: " + schema);
        }
        MetadataField mdf = this.metadataFieldService.findByElement(context, mds, element, qualifier);
        if (mdf == null) {
            throw new IllegalArgumentException("No such metadata field: schema=" + schema + ", element=" + element + ", qualifier=" + qualifier);
        }
        return this.findByAuthorityValue(context, mds.getName(), mdf.getElement(), mdf.getQualifier(), authority);
    }

    @Override
    public boolean isItemListedForUser(Context context, Item item) {
        try {
            if (this.authorizeService.isAdmin(context)) {
                return true;
            }
            if (this.authorizeService.authorizeActionBoolean(context, item, 0) && item.isDiscoverable()) {
                return true;
            }
            log.debug((Object)("item(" + item.getID() + ") " + item.getName() + " is unlisted."));
            return false;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            return false;
        }
    }

    @Override
    public int countItems(Context context, Collection collection) throws SQLException {
        return this.itemDAO.countItems(context, collection, true, false);
    }

    @Override
    public int countAllItems(Context context, Collection collection) throws SQLException {
        return this.itemDAO.countItems(context, collection, true, false) + this.itemDAO.countItems(context, collection, false, true);
    }

    @Override
    public int countItems(Context context, Community community) throws SQLException {
        List<Collection> collections = this.communityService.getAllCollections(context, community);
        return this.itemDAO.countItems(context, collections, true, false);
    }

    @Override
    public int countAllItems(Context context, Community community) throws SQLException {
        List<Collection> collections = this.communityService.getAllCollections(context, community);
        return this.itemDAO.countItems(context, collections, true, false) + this.itemDAO.countItems(context, collections, false, true);
    }

    @Override
    protected void getAuthoritiesAndConfidences(String fieldKey, Collection collection, List<String> values, List<String> authorities, List<Integer> confidences, int i) {
        Choices c = this.choiceAuthorityService.getBestMatch(fieldKey, values.get(i), collection, null);
        authorities.add(c.values.length > 0 ? c.values[0].authority : null);
        confidences.add(c.confidence);
    }

    @Override
    public Item findByIdOrLegacyId(Context context, String id) throws SQLException {
        if (StringUtils.isNumeric((String)id)) {
            return this.findByLegacyId(context, Integer.parseInt(id));
        }
        return this.find(context, UUID.fromString(id));
    }

    @Override
    public Item findByLegacyId(Context context, int id) throws SQLException {
        return this.itemDAO.findByLegacyId(context, id, Item.class);
    }

    @Override
    public Iterator<Item> findByLastModifiedSince(Context context, Date last) throws SQLException {
        return this.itemDAO.findByLastModifiedSince(context, last);
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.itemDAO.countRows(context);
    }

    @Override
    public int countNotArchivedItems(Context context) throws SQLException {
        return this.itemDAO.countItems(context, false, false);
    }

    @Override
    public int countWithdrawnItems(Context context) throws SQLException {
        return this.itemDAO.countItems(context, false, true);
    }

    @Override
    public boolean canCreateNewVersion(Context context, Item item) throws SQLException {
        if (this.authorizeService.isAdmin(context, item)) {
            return true;
        }
        if (context.getCurrentUser() != null && context.getCurrentUser().equals(item.getSubmitter())) {
            return (Boolean)this.configurationService.getPropertyAsType("versioning.submitterCanCreateNewVersion", (Object)false);
        }
        return false;
    }
}

