/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.dao.WorkspaceItemDAO;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.BasicTransformerAdapter;
import org.hibernate.transform.ResultTransformer;

public class WorkspaceItemDAOImpl
extends AbstractHibernateDAO<WorkspaceItem>
implements WorkspaceItemDAO {
    protected WorkspaceItemDAOImpl() {
    }

    @Override
    public List<WorkspaceItem> findByEPerson(Context context, EPerson ep) throws SQLException {
        Query query = this.createQuery(context, "from WorkspaceItem ws where ws.item.submitter = :submitter order by workspaceItemId");
        query.setParameter("submitter", (Object)ep);
        return this.list(query);
    }

    @Override
    public List<WorkspaceItem> findByCollection(Context context, Collection c) throws SQLException {
        Criteria criteria = this.createCriteria(context, WorkspaceItem.class);
        criteria.add((Criterion)Restrictions.eq((String)"collection", (Object)c));
        return this.list(criteria);
    }

    @Override
    public WorkspaceItem findByItem(Context context, Item i) throws SQLException {
        Criteria criteria = this.createCriteria(context, WorkspaceItem.class);
        criteria.add((Criterion)Restrictions.eq((String)"item", (Object)i));
        return (WorkspaceItem)this.uniqueResult(criteria);
    }

    @Override
    public List<WorkspaceItem> findAll(Context context) throws SQLException {
        Criteria criteria = this.createCriteria(context, WorkspaceItem.class);
        criteria.addOrder(Order.asc((String)"item"));
        return this.list(criteria);
    }

    @Override
    public List<WorkspaceItem> findWithSupervisedGroup(Context context) throws SQLException {
        Criteria criteria = this.createCriteria(context, WorkspaceItem.class);
        criteria.add(Restrictions.isNotEmpty((String)"supervisorGroups"));
        criteria.addOrder(Order.asc((String)"workspaceItemId"));
        return this.list(criteria);
    }

    @Override
    public List<WorkspaceItem> findBySupervisedGroupMember(Context context, EPerson ePerson) throws SQLException {
        Criteria criteria = this.createCriteria(context, WorkspaceItem.class);
        criteria.createAlias("supervisorGroups", "supervisorGroup");
        criteria.createAlias("supervisorGroup.epeople", "person");
        criteria.add((Criterion)Restrictions.eq((String)"person.id", (Object)ePerson.getID()));
        return this.list(criteria);
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) from WorkspaceItem"));
    }

    @Override
    public List<Map.Entry<Integer, Long>> getStageReachedCounts(Context context) throws SQLException {
        Query query = this.createQuery(context, "SELECT wi.stageReached as stage_reached, count(*) as cnt from WorkspaceItem wi group by wi.stageReached order by wi.stageReached");
        query.setResultTransformer((ResultTransformer)new BasicTransformerAdapter(){

            public Object transformTuple(Object[] tuple, String[] aliases) {
                return new AbstractMap.SimpleImmutableEntry<Integer, Long>((Integer)tuple[0], (Long)tuple[1]);
            }
        });
        return query.list();
    }
}

