/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.util.List;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.discovery.SolrServiceIndexPlugin;

public class SolrServiceFileInfoPlugin
implements SolrServiceIndexPlugin {
    private static final String BUNDLE_NAME = "ORIGINAL";
    private static final String SOLR_FIELD_NAME_FOR_FILENAMES = "original_bundle_filenames";
    private static final String SOLR_FIELD_NAME_FOR_DESCRIPTIONS = "original_bundle_descriptions";

    @Override
    public void additionalIndex(Context context, DSpaceObject dso, SolrInputDocument document) {
        Item item;
        List<Bundle> bundles;
        if (dso instanceof Item && (bundles = (item = (Item)dso).getBundles()) != null) {
            for (Bundle bundle : bundles) {
                List<Bitstream> bitstreams;
                String bundleName = bundle.getName();
                if (bundleName == null || !bundleName.equals(BUNDLE_NAME) || (bitstreams = bundle.getBitstreams()) == null) continue;
                for (Bitstream bitstream : bitstreams) {
                    document.addField(SOLR_FIELD_NAME_FOR_FILENAMES, (Object)bitstream.getName());
                    String description = bitstream.getDescription();
                    if (description == null || description.isEmpty()) continue;
                    document.addField(SOLR_FIELD_NAME_FOR_DESCRIPTIONS, (Object)description);
                }
            }
        }
    }
}

