/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectServiceImpl;
import org.dspace.content.MetadataField;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.Group2GroupCache;
import org.dspace.eperson.dao.Group2GroupCacheDAO;
import org.dspace.eperson.dao.GroupDAO;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.event.Event;
import org.dspace.util.UUIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GroupServiceImpl
extends DSpaceObjectServiceImpl<Group>
implements GroupService {
    private static final Logger log = LoggerFactory.getLogger(GroupServiceImpl.class);
    @Autowired(required=true)
    protected GroupDAO groupDAO;
    @Autowired(required=true)
    protected Group2GroupCacheDAO group2GroupCacheDAO;
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected EPersonService ePersonService;
    @Autowired(required=true)
    protected CommunityService communityService;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;

    protected GroupServiceImpl() {
    }

    @Override
    public Group create(Context context) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("You must be an admin to create an EPerson Group");
        }
        Group g = this.groupDAO.create(context, new Group());
        log.info(LogManager.getHeader(context, "create_group", "group_id=" + g.getID()));
        context.addEvent(new Event(1, 6, g.getID(), null, this.getIdentifiers(context, g)));
        this.update(context, g);
        return g;
    }

    @Override
    public void setName(Group group, String name) throws SQLException {
        if (group.isPermanent().booleanValue()) {
            log.error("Attempt to rename permanent Group {} to {}.", (Object)group.getName(), (Object)name);
            throw new SQLException("Attempt to rename a permanent Group");
        }
        group.setName(name);
    }

    @Override
    public void addMember(Context context, Group group, EPerson e) {
        if (this.isDirectMember(group, e)) {
            return;
        }
        group.addMember(e);
        e.getGroups().add(group);
        context.addEvent(new Event(8, 6, group.getID(), 7, e.getID(), e.getEmail(), this.getIdentifiers(context, group)));
    }

    @Override
    public void addMember(Context context, Group groupParent, Group groupChild) throws SQLException {
        if (groupParent.contains(groupChild) || groupParent.getID() == groupChild.getID()) {
            return;
        }
        groupParent.addMember(groupChild);
        groupChild.addParentGroup(groupParent);
        context.addEvent(new Event(8, 6, groupParent.getID(), 6, groupChild.getID(), groupChild.getName(), this.getIdentifiers(context, groupParent)));
    }

    @Override
    public void removeMember(Context context, Group group, EPerson ePerson) {
        if (group.remove(ePerson)) {
            context.addEvent(new Event(16, 6, group.getID(), 7, ePerson.getID(), ePerson.getEmail(), this.getIdentifiers(context, group)));
        }
    }

    @Override
    public void removeMember(Context context, Group groupParent, Group childGroup) throws SQLException {
        if (groupParent.remove(childGroup)) {
            childGroup.removeParentGroup(groupParent);
            context.addEvent(new Event(16, 6, groupParent.getID(), 6, childGroup.getID(), childGroup.getName(), this.getIdentifiers(context, groupParent)));
        }
    }

    @Override
    public boolean isDirectMember(Group group, EPerson ePerson) {
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)group.getName(), (CharSequence)"Anonymous") || group.contains(ePerson);
    }

    @Override
    public boolean isMember(Group owningGroup, Group childGroup) {
        return owningGroup.contains(childGroup);
    }

    @Override
    public boolean isParentOf(Context context, Group parentGroup, Group childGroup) throws SQLException {
        return this.group2GroupCacheDAO.findByParentAndChild(context, parentGroup, childGroup) != null;
    }

    @Override
    public boolean isMember(Context context, Group group) throws SQLException {
        return this.isMember(context, context.getCurrentUser(), group);
    }

    @Override
    public boolean isMember(Context context, EPerson ePerson, Group group) throws SQLException {
        if (group == null) {
            return false;
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)group.getName(), (CharSequence)"Anonymous")) {
            return true;
        }
        Boolean cachedGroupMembership = context.getCachedGroupMembership(group, ePerson);
        if (cachedGroupMembership != null) {
            return cachedGroupMembership;
        }
        boolean isMember = false;
        if (ePerson != null) {
            isMember = this.isEPersonInGroup(context, group, ePerson);
        }
        if (!isMember && CollectionUtils.isNotEmpty(context.getSpecialGroups()) && this.isAuthenticatedUser(context, ePerson)) {
            Iterator<Group> it = context.getSpecialGroups().iterator();
            while (it.hasNext() && !isMember) {
                Group specialGroup = it.next();
                if (!specialGroup.equals(group) && !this.isParentOf(context, group, specialGroup)) continue;
                isMember = true;
            }
        }
        context.cacheGroupMembership(group, ePerson, isMember);
        return isMember;
    }

    private boolean isAuthenticatedUser(Context context, EPerson ePerson) {
        return ObjectUtils.equals((Object)context.getCurrentUser(), (Object)ePerson);
    }

    @Override
    public boolean isMember(Context context, String groupName) throws SQLException {
        return this.isMember(context, this.findByName(context, groupName));
    }

    @Override
    public boolean isMember(Context context, EPerson eperson, String groupName) throws SQLException {
        return this.isMember(context, eperson, this.findByName(context, groupName));
    }

    @Override
    public List<Group> allMemberGroups(Context context, EPerson ePerson) throws SQLException {
        return new ArrayList<Group>(this.allMemberGroupsSet(context, ePerson));
    }

    @Override
    public Set<Group> allMemberGroupsSet(Context context, EPerson ePerson) throws SQLException {
        Set<Group> cachedGroupMembership = context.getCachedAllMemberGroupsSet(ePerson);
        if (cachedGroupMembership != null) {
            return cachedGroupMembership;
        }
        HashSet<Group> groups = new HashSet<Group>();
        if (ePerson != null) {
            groups.addAll(this.groupDAO.findByEPerson(context, ePerson));
        }
        if (context.getCurrentUser() == null || context.getCurrentUser().equals(ePerson)) {
            List<Group> specialGroups = context.getSpecialGroups();
            for (Group special : specialGroups) {
                groups.add(special);
            }
        }
        groups.add(this.findByName(context, "Anonymous"));
        List<Group2GroupCache> groupCache = this.group2GroupCacheDAO.findByChildren(context, groups);
        for (Group2GroupCache group2GroupCache : groupCache) {
            groups.add(group2GroupCache.getParent());
        }
        context.cacheAllMemberGroupsSet(ePerson, groups);
        return groups;
    }

    @Override
    public List<EPerson> allMembers(Context c, Group g) throws SQLException {
        List<Group2GroupCache> group2GroupCaches = this.group2GroupCacheDAO.findByParent(c, g);
        HashSet<Group> groups = new HashSet<Group>();
        for (Group2GroupCache group2GroupCache : group2GroupCaches) {
            groups.add(group2GroupCache.getChild());
        }
        HashSet<EPerson> childGroupChildren = new HashSet<EPerson>(this.ePersonService.findByGroups(c, groups));
        childGroupChildren.addAll(g.getMembers());
        return new ArrayList<EPerson>(childGroupChildren);
    }

    @Override
    public Group find(Context context, UUID id) throws SQLException {
        if (id == null) {
            return null;
        }
        return (Group)this.groupDAO.findByID(context, Group.class, id);
    }

    @Override
    public Group findByName(Context context, String name) throws SQLException {
        if (name == null) {
            return null;
        }
        return this.groupDAO.findByName(context, name);
    }

    @Override
    @Deprecated
    public List<Group> findAll(Context context, int sortField) throws SQLException {
        if (sortField == 1) {
            return this.findAll(context, null);
        }
        throw new UnsupportedOperationException("You can only find all groups sorted by name with this method");
    }

    @Override
    public List<Group> findAll(Context context, List<MetadataField> metadataSortFields) throws SQLException {
        if (CollectionUtils.isEmpty(metadataSortFields)) {
            return this.groupDAO.findAll(context);
        }
        return this.groupDAO.findAll(context, metadataSortFields);
    }

    @Override
    public List<Group> search(Context context, String groupIdentifier) throws SQLException {
        return this.search(context, groupIdentifier, -1, -1);
    }

    @Override
    public List<Group> search(Context context, String groupIdentifier, int offset, int limit) throws SQLException {
        ArrayList<Group> groups = new ArrayList();
        UUID uuid = UUIDUtils.fromString(groupIdentifier);
        if (uuid == null) {
            groups = this.groupDAO.findByNameLike(context, groupIdentifier, offset, limit);
        } else {
            Group group = this.find(context, uuid);
            if (group != null) {
                groups.add(group);
            }
        }
        return groups;
    }

    @Override
    public int searchResultCount(Context context, String groupIdentifier) throws SQLException {
        int result = 0;
        UUID uuid = UUIDUtils.fromString(groupIdentifier);
        if (uuid == null) {
            result = this.groupDAO.countByNameLike(context, groupIdentifier);
        } else {
            Group group = this.find(context, uuid);
            if (group != null) {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public void delete(Context context, Group group) throws SQLException {
        if (group.isPermanent().booleanValue()) {
            log.error("Attempt to delete permanent Group $", (Object)group.getName());
            throw new SQLException("Attempt to delete a permanent Group");
        }
        context.addEvent(new Event(32, 6, group.getID(), group.getName(), this.getIdentifiers(context, group)));
        group.getSupervisedItems().clear();
        this.authorizeService.removeGroupPolicies(context, group);
        group.getMemberGroups().clear();
        group.getParentGroups().clear();
        Iterator<EPerson> ePeople = group.getMembers().iterator();
        while (ePeople.hasNext()) {
            EPerson ePerson = ePeople.next();
            ePeople.remove();
            ePerson.getGroups().remove(group);
        }
        this.group2GroupCacheDAO.deleteAll(context);
        this.groupDAO.delete(context, group);
        this.rethinkGroupCache(context, false);
        log.info(LogManager.getHeader(context, "delete_group", "group_id=" + group.getID()));
    }

    @Override
    public int getSupportsTypeConstant() {
        return 6;
    }

    @Override
    public boolean isEmpty(Group group) {
        boolean hasMembers;
        boolean bl = hasMembers = !group.getMembers().isEmpty();
        if (hasMembers) {
            return false;
        }
        for (Group subGroup : group.getMemberGroups()) {
            hasMembers = !this.isEmpty(subGroup);
            if (!hasMembers) continue;
            return false;
        }
        return !hasMembers;
    }

    @Override
    public void initDefaultGroupNames(Context context) throws SQLException, AuthorizeException {
        Group adminGroup;
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Group anonymousGroup = groupService.findByName(context, "Anonymous");
        if (anonymousGroup == null) {
            anonymousGroup = groupService.create(context);
            anonymousGroup.setName("Anonymous");
            anonymousGroup.setPermanent(true);
            groupService.update(context, anonymousGroup);
        }
        if ((adminGroup = groupService.findByName(context, "Administrator")) == null) {
            adminGroup = groupService.create(context);
            adminGroup.setName("Administrator");
            adminGroup.setPermanent(true);
            groupService.update(context, adminGroup);
        }
    }

    @Override
    public List<Group> getEmptyGroups(Context context) throws SQLException {
        return this.groupDAO.getEmptyGroups(context);
    }

    @Override
    public void update(Context context, Group group) throws SQLException, AuthorizeException {
        super.update(context, group);
        this.groupDAO.save(context, group);
        if (group.isMetadataModified()) {
            context.addEvent(new Event(4, 6, group.getID(), group.getDetails(), this.getIdentifiers(context, group)));
            group.clearDetails();
        }
        if (group.isGroupsChanged()) {
            this.rethinkGroupCache(context, true);
            group.clearGroupsChanged();
        }
        log.info(LogManager.getHeader(context, "update_group", "group_id=" + group.getID()));
    }

    protected boolean isEPersonInGroup(Context context, Group group, EPerson ePerson) throws SQLException {
        return this.groupDAO.findByIdAndMembership(context, group.getID(), ePerson) != null;
    }

    protected void rethinkGroupCache(Context context, boolean flushQueries) throws SQLException {
        HashMap<UUID, Set<UUID>> parents = new HashMap<UUID, Set<UUID>>();
        List<Pair<UUID, UUID>> group2groupResults = this.groupDAO.getGroup2GroupResults(context, flushQueries);
        for (Pair<UUID, UUID> pair : group2groupResults) {
            Set<UUID> children;
            UUID parent = (UUID)pair.getLeft();
            UUID child = (UUID)pair.getRight();
            if (!parents.containsKey(parent)) {
                children = new HashSet<UUID>();
                children.add(child);
                parents.put(parent, children);
                continue;
            }
            children = (Set)parents.get(parent);
            children.add(child);
        }
        for (Map.Entry entry : parents.entrySet()) {
            Set<UUID> myChildren = this.getChildren(parents, (UUID)entry.getKey());
            ((Set)entry.getValue()).addAll(myChildren);
        }
        this.group2GroupCacheDAO.deleteAll(context);
        for (Map.Entry entry : parents.entrySet()) {
            UUID key = (UUID)entry.getKey();
            for (UUID child : (Set)entry.getValue()) {
                Group parentGroup = this.find(context, key);
                Group childGroup = this.find(context, child);
                if (parentGroup == null || childGroup == null || this.group2GroupCacheDAO.find(context, parentGroup, childGroup) != null) continue;
                Group2GroupCache group2GroupCache = this.group2GroupCacheDAO.create(context, new Group2GroupCache());
                group2GroupCache.setParent(parentGroup);
                group2GroupCache.setChild(childGroup);
                this.group2GroupCacheDAO.save(context, group2GroupCache);
            }
        }
    }

    @Override
    public DSpaceObject getParentObject(Context context, Group group) throws SQLException {
        if (group == null) {
            return null;
        }
        if (AuthorizeConfiguration.canCollectionAdminManageAdminGroup() || AuthorizeConfiguration.canCollectionAdminManageSubmitters() || AuthorizeConfiguration.canCollectionAdminManageWorkflows() || AuthorizeConfiguration.canCommunityAdminManageAdminGroup() || AuthorizeConfiguration.canCommunityAdminManageCollectionAdminGroup() || AuthorizeConfiguration.canCommunityAdminManageCollectionSubmitters() || AuthorizeConfiguration.canCommunityAdminManageCollectionWorkflows()) {
            Collection collection = this.collectionService.findByGroup(context, group);
            if (collection != null) {
                if (group.equals(collection.getWorkflowStep1()) || group.equals(collection.getWorkflowStep2()) || group.equals(collection.getWorkflowStep3())) {
                    if (AuthorizeConfiguration.canCollectionAdminManageWorkflows()) {
                        return collection;
                    }
                    if (AuthorizeConfiguration.canCommunityAdminManageCollectionWorkflows()) {
                        return this.collectionService.getParentObject(context, collection);
                    }
                }
                if (group.equals(collection.getSubmitters())) {
                    if (AuthorizeConfiguration.canCollectionAdminManageSubmitters()) {
                        return collection;
                    }
                    if (AuthorizeConfiguration.canCommunityAdminManageCollectionSubmitters()) {
                        return this.collectionService.getParentObject(context, collection);
                    }
                }
                if (group.equals(collection.getAdministrators())) {
                    if (AuthorizeConfiguration.canCollectionAdminManageAdminGroup()) {
                        return collection;
                    }
                    if (AuthorizeConfiguration.canCommunityAdminManageCollectionAdminGroup()) {
                        return this.collectionService.getParentObject(context, collection);
                    }
                }
            } else if (AuthorizeConfiguration.canCommunityAdminManageAdminGroup()) {
                return this.communityService.findByAdminGroup(context, group);
            }
        }
        return null;
    }

    @Override
    public void updateLastModified(Context context, Group dso) {
    }

    protected Set<UUID> getChildren(Map<UUID, Set<UUID>> parents, UUID parent) {
        HashSet<UUID> myChildren = new HashSet<UUID>();
        if (!parents.containsKey(parent)) {
            return myChildren;
        }
        Set<UUID> children = parents.get(parent);
        for (UUID child : children) {
            myChildren.add(child);
            myChildren.addAll(this.getChildren(parents, child));
        }
        return myChildren;
    }

    @Override
    public Group findByIdOrLegacyId(Context context, String id) throws SQLException {
        if (StringUtils.isNumeric((String)id)) {
            return this.findByLegacyId(context, Integer.parseInt(id));
        }
        return this.find(context, UUIDUtils.fromString(id));
    }

    @Override
    public Group findByLegacyId(Context context, int id) throws SQLException {
        return this.groupDAO.findByLegacyId(context, id, Group.class);
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.groupDAO.countRows(context);
    }

    @Override
    public List<Group> findByMetadataField(Context context, String searchValue, MetadataField metadataField) throws SQLException {
        return this.groupDAO.findByMetadataField(context, searchValue, metadataField);
    }
}

