/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.bitstore;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.checker.service.ChecksumHistoryService;
import org.dspace.content.Bitstream;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.storage.bitstore.BitStoreService;
import org.dspace.storage.bitstore.service.BitstreamStorageService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class BitstreamStorageServiceImpl
implements BitstreamStorageService,
InitializingBean {
    private static Logger log = Logger.getLogger(BitstreamStorageServiceImpl.class);
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected ChecksumHistoryService checksumHistoryService;
    private Map<Integer, BitStoreService> stores = new HashMap<Integer, BitStoreService>();
    private int incoming;
    protected final String REGISTERED_FLAG = "-R";

    protected BitstreamStorageServiceImpl() {
    }

    public void afterPropertiesSet() throws Exception {
        for (Map.Entry<Integer, BitStoreService> storeEntry : this.stores.entrySet()) {
            storeEntry.getValue().init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID store(Context context, Bitstream bitstream, InputStream is) throws SQLException, IOException {
        String id = Utils.generateKey();
        bitstream.setDeleted(true);
        bitstream.setInternalId(id);
        bitstream.setStoreNumber(this.incoming);
        this.stores.get(this.incoming).put(bitstream, is);
        bitstream.setDeleted(false);
        try {
            context.turnOffAuthorisationSystem();
            this.bitstreamService.update(context, bitstream);
        }
        catch (AuthorizeException e) {
            log.error((Object)e);
        }
        finally {
            context.restoreAuthSystemState();
        }
        UUID bitstreamId = bitstream.getID();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stored bitstreamID " + bitstreamId));
        }
        return bitstreamId;
    }

    @Override
    public UUID register(Context context, Bitstream bitstream, int assetstore, String bitstreamPath) throws SQLException, IOException, AuthorizeException {
        String sInternalId = "-R" + bitstreamPath;
        bitstream.setDeleted(true);
        bitstream.setInternalId(sInternalId);
        bitstream.setStoreNumber(assetstore);
        this.bitstreamService.update(context, bitstream);
        HashMap<String, Object> wantedMetadata = new HashMap<String, Object>();
        wantedMetadata.put("size_bytes", null);
        wantedMetadata.put("checksum", null);
        wantedMetadata.put("checksum_algorithm", null);
        Map receivedMetadata = this.stores.get(assetstore).about(bitstream, wantedMetadata);
        if (MapUtils.isEmpty((Map)receivedMetadata)) {
            String message = "Not able to register bitstream:" + bitstream.getID() + " at path: " + bitstreamPath;
            log.error((Object)message);
            throw new IOException(message);
        }
        if (receivedMetadata.containsKey("checksum_algorithm")) {
            bitstream.setChecksumAlgorithm(receivedMetadata.get("checksum_algorithm").toString());
        }
        if (receivedMetadata.containsKey("checksum")) {
            bitstream.setChecksum(receivedMetadata.get("checksum").toString());
        }
        if (receivedMetadata.containsKey("size_bytes")) {
            bitstream.setSizeBytes(Long.valueOf(receivedMetadata.get("size_bytes").toString()));
        }
        bitstream.setDeleted(false);
        this.bitstreamService.update(context, bitstream);
        UUID bitstreamId = bitstream.getID();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered bitstream " + bitstreamId + " at location " + bitstreamPath));
        }
        return bitstreamId;
    }

    @Override
    public Map computeChecksum(Context context, Bitstream bitstream) throws IOException {
        HashMap<String, Object> wantedMetadata = new HashMap<String, Object>();
        wantedMetadata.put("checksum", null);
        wantedMetadata.put("checksum_algorithm", null);
        Map receivedMetadata = this.stores.get(bitstream.getStoreNumber()).about(bitstream, wantedMetadata);
        return receivedMetadata;
    }

    @Override
    public boolean isRegisteredBitstream(String internalId) {
        return internalId.startsWith("-R");
    }

    @Override
    public InputStream retrieve(Context context, Bitstream bitstream) throws SQLException, IOException {
        Integer storeNumber = bitstream.getStoreNumber();
        return this.stores.get(storeNumber).get(bitstream);
    }

    @Override
    public void cleanup(boolean deleteDbRecords, boolean verbose) throws SQLException, IOException, AuthorizeException {
        Context context = null;
        int commitCounter = 0;
        try {
            context = new Context(Context.Mode.BATCH_EDIT);
            context.turnOffAuthorisationSystem();
            List<Bitstream> storage = this.bitstreamService.findDeletedBitstreams(context);
            for (Bitstream bitstream : storage) {
                UUID bid = bitstream.getID();
                HashMap<String, Object> wantedMetadata = new HashMap<String, Object>();
                wantedMetadata.put("size_bytes", null);
                wantedMetadata.put("modified", null);
                Map receivedMetadata = this.stores.get(bitstream.getStoreNumber()).about(bitstream, wantedMetadata);
                if (MapUtils.isEmpty((Map)receivedMetadata)) {
                    log.debug((Object)"bitstore.about is empty, so file is not present");
                    if (deleteDbRecords) {
                        log.debug((Object)"deleting record");
                        if (verbose) {
                            System.out.println(" - Deleting bitstream information (ID: " + bid + ")");
                        }
                        this.checksumHistoryService.deleteByBitstream(context, bitstream);
                        if (verbose) {
                            System.out.println(" - Deleting bitstream record from database (ID: " + bid + ")");
                        }
                        this.bitstreamService.expunge(context, bitstream);
                    }
                    context.uncacheEntity(bitstream);
                    continue;
                }
                if (this.isRecent(Long.valueOf(receivedMetadata.get("modified").toString()))) {
                    log.debug((Object)"file is recent");
                    context.uncacheEntity(bitstream);
                    continue;
                }
                if (deleteDbRecords) {
                    log.debug((Object)"deleting db record");
                    if (verbose) {
                        System.out.println(" - Deleting bitstream information (ID: " + bid + ")");
                    }
                    this.checksumHistoryService.deleteByBitstream(context, bitstream);
                    if (verbose) {
                        System.out.println(" - Deleting bitstream record from database (ID: " + bid + ")");
                    }
                    this.bitstreamService.expunge(context, bitstream);
                }
                if (this.isRegisteredBitstream(bitstream.getInternalId())) {
                    context.uncacheEntity(bitstream);
                    continue;
                }
                if (this.bitstreamService.findDuplicateInternalIdentifier(context, bitstream).isEmpty()) {
                    this.stores.get(bitstream.getStoreNumber()).remove(bitstream);
                    String message = "Deleted bitstreamID " + bid + ", internalID " + bitstream.getInternalId();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)message);
                    }
                    if (verbose) {
                        System.out.println(message);
                    }
                }
                if (++commitCounter % 100 == 0) {
                    context.dispatchEvents();
                }
                context.uncacheEntity(bitstream);
            }
            System.out.print("Committing changes to the database...");
            context.complete();
            System.out.println(" Done!");
        }
        catch (IOException | SQLException sqle) {
            if (verbose) {
                System.err.println("Error: " + sqle.getMessage());
            }
            context.abort();
            throw sqle;
        }
        finally {
            if (context != null) {
                context.restoreAuthSystemState();
            }
        }
    }

    @Override
    public Bitstream clone(Context context, Bitstream bitstream) throws SQLException, IOException, AuthorizeException {
        Bitstream clonedBitstream = this.bitstreamService.clone(context, bitstream);
        clonedBitstream.setStoreNumber(bitstream.getStoreNumber());
        List<MetadataValue> metadataValues = this.bitstreamService.getMetadata(bitstream, "*", "*", "*", "*");
        for (MetadataValue metadataValue : metadataValues) {
            this.bitstreamService.addMetadata(context, clonedBitstream, metadataValue.getMetadataField(), metadataValue.getLanguage(), metadataValue.getValue(), metadataValue.getAuthority(), metadataValue.getConfidence());
        }
        this.bitstreamService.update(context, clonedBitstream);
        return clonedBitstream;
    }

    @Override
    public void migrate(Context context, Integer assetstoreSource, Integer assetstoreDestination, boolean deleteOld, Integer batchCommitSize) throws IOException, SQLException, AuthorizeException {
        Iterator<Bitstream> allBitstreamsInSource = this.bitstreamService.findByStoreNumber(context, assetstoreSource);
        Integer processedCounter = 0;
        while (allBitstreamsInSource.hasNext()) {
            Bitstream bitstream = allBitstreamsInSource.next();
            log.info((Object)("Copying bitstream:" + bitstream.getID() + " from assetstore[" + assetstoreSource + "] to assetstore[" + assetstoreDestination + "] Name:" + bitstream.getName() + ", SizeBytes:" + bitstream.getSize()));
            InputStream inputStream = this.retrieve(context, bitstream);
            this.stores.get(assetstoreDestination).put(bitstream, inputStream);
            bitstream.setStoreNumber(assetstoreDestination);
            this.bitstreamService.update(context, bitstream);
            if (deleteOld) {
                log.info((Object)("Removing bitstream:" + bitstream.getID() + " from assetstore[" + assetstoreSource + "]"));
                this.stores.get(assetstoreSource).remove(bitstream);
            }
            Integer n = processedCounter;
            Integer n2 = processedCounter = Integer.valueOf(processedCounter + 1);
            context.uncacheEntity(bitstream);
            if (processedCounter % batchCommitSize != 0) continue;
            log.info((Object)("Migration Commit Checkpoint: " + processedCounter));
            context.dispatchEvents();
        }
        log.info((Object)("Assetstore Migration from assetstore[" + assetstoreSource + "] to assetstore[" + assetstoreDestination + "] completed. " + processedCounter + " objects were transferred."));
    }

    @Override
    public void printStores(Context context) {
        try {
            for (Integer storeNumber : this.stores.keySet()) {
                long countBitstreams = this.bitstreamService.countByStoreNumber(context, storeNumber);
                System.out.println("store[" + storeNumber + "] == " + this.stores.get(storeNumber).getClass().getSimpleName() + ", which has " + countBitstreams + " bitstreams.");
            }
            System.out.println("Incoming assetstore is store[" + this.incoming + "]");
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
    }

    public int getIncoming() {
        return this.incoming;
    }

    public void setIncoming(int incoming) {
        this.incoming = incoming;
    }

    public void setStores(Map<Integer, BitStoreService> stores) {
        this.stores = stores;
    }

    public Map<Integer, BitStoreService> getStores() {
        return this.stores;
    }

    protected boolean isRecent(Long lastModified) {
        long now = new Date().getTime();
        if (lastModified >= now) {
            return true;
        }
        return now - lastModified < 60000L;
    }
}

