/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.dspace.core.Context;
import org.dspace.workflow.WorkflowException;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class Workflow {
    protected XmlWorkflowFactory xmlWorkflowFactory = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory();
    private String id;
    private Step firstStep;
    private HashMap<String, Step> steps;
    private LinkedHashMap<String, Role> roles;

    public Workflow(String workflowID, LinkedHashMap<String, Role> roles) {
        this.id = workflowID;
        this.roles = roles;
        this.steps = new HashMap();
    }

    public Step getFirstStep() {
        return this.firstStep;
    }

    public String getID() {
        return this.id;
    }

    public Step getStep(String stepID) throws WorkflowConfigurationException, IOException {
        if (this.steps.get(this.id) != null) {
            return this.steps.get(this.id);
        }
        Step step = this.xmlWorkflowFactory.createStep(this, stepID);
        if (step == null) {
            throw new WorkflowConfigurationException("Step definition not found for: " + stepID);
        }
        this.steps.put(stepID, step);
        return step;
    }

    public Step getNextStep(Context context, XmlWorkflowItem wfi, Step currentStep, int outcome) throws IOException, WorkflowConfigurationException, WorkflowException, SQLException {
        String nextStepID = currentStep.getNextStepID(outcome);
        if (nextStepID != null) {
            Step nextStep = this.getStep(nextStepID);
            if (nextStep == null) {
                throw new WorkflowException("Error while processing outcome, the following action was undefined: " + nextStepID);
            }
            if (nextStep.isValidStep(context, wfi)) {
                return nextStep;
            }
            return this.getNextStep(context, wfi, nextStep, 0);
        }
        return null;
    }

    public void setFirstStep(Step firstStep) {
        this.firstStep = firstStep;
    }

    public HashMap<String, Role> getRoles() {
        return this.roles;
    }
}

