/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dspace.app.util.GoogleBitstreamComparator;
import org.dspace.app.util.Util;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.jdom.Element;

public class GoogleMetadata {
    private static final Logger log = Logger.getLogger(GoogleMetadata.class);
    protected static final String GOOGLE_PREFIX = "google.";
    protected ItemService itemService;
    protected Item item;
    protected String itemURL;
    protected static Map<String, String> googleScholarSettings = new HashMap<String, String>();
    protected ListMultimap<String, String> metadataMappings = ArrayListMultimap.create();
    protected final String TITLE = "citation_title";
    protected final String JOURNAL_TITLE = "citation_journal_title";
    protected final String PUBLISHER = "citation_publisher";
    protected final String AUTHORS = "citation_author";
    protected final String DATE = "citation_date";
    protected final String VOLUME = "citation_volume";
    protected final String ISSUE = "citation_issue";
    protected final String FIRSTPAGE = "citation_firstpage";
    protected final String LASTPAGE = "citation_lastpage";
    protected final String DOI = "citation_doi";
    protected final String PMID = "citation_pmid";
    protected final String ABSTRACT = "citation_abstract_html_url";
    protected final String FULLTEXT = "citation_fulltext_html_url";
    protected final String PDF = "citation_pdf_url";
    protected final String ISSN = "citation_issn";
    protected final String ISBN = "citation_isbn";
    protected final String LANGUAGE = "citation_language";
    protected final String KEYWORDS = "citation_keywords";
    protected final String CONFERENCE = "citation_conference";
    protected final String DISSERTATION_ID = "identifiers.dissertation";
    protected final String DISSERTATION_NAME = "citation_dissertation_name";
    protected final String DISSERTATION_INSTITUTION = "citation_dissertation_institution";
    protected final String PATENT_ID = "identifiers.patent";
    protected final String PATENT_NUMBER = "citation_patent_number";
    protected final String PATENT_COUNTRY = "citation_patent_country";
    protected final String TECH_REPORT_ID = "identifiers.technical_report";
    protected final String TECH_REPORT_NUMBER = "citation_technical_report_number";
    protected final String TECH_REPORT_INSTITUTION = "citation_technical_report_institution";
    protected final int SINGLE = 0;
    protected final int MULTI = 1;
    protected final int ALL_FIELDS_IN_OPTION = 2;
    private static GoogleBitstreamComparator googleBitstreamComparator = null;

    public static void logConfiguration() {
        log.debug((Object)"Google Metadata Configuration Mapping:");
        for (String name : googleScholarSettings.keySet()) {
            log.debug((Object)("  " + name + " => " + googleScholarSettings.get(name)));
        }
    }

    public GoogleMetadata(Context context, Item item) throws SQLException {
        this.item = item;
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.itemURL = HandleServiceFactory.getInstance().getHandleService().resolveToURL(context, item.getHandle());
        googleBitstreamComparator = new GoogleBitstreamComparator(context, googleScholarSettings);
        this.parseItem();
    }

    protected boolean addSingleField(String fieldName) {
        String config = googleScholarSettings.get(fieldName);
        if (null == config || config.equals("")) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing " + fieldName));
        }
        if (config.equals("$handle")) {
            if (null != this.itemURL && !this.itemURL.equals("")) {
                this.metadataMappings.put((Object)fieldName, (Object)this.itemURL);
                return true;
            }
            return false;
        }
        if (config.equals("$simple-pdf")) {
            String pdf_url = this.getPDFSimpleUrl(this.item);
            if (pdf_url.length() > 0) {
                this.metadataMappings.put((Object)fieldName, (Object)pdf_url);
                return true;
            }
            return false;
        }
        MetadataValue v = this.resolveMetadataField(config);
        if (null != v && null != v.getValue() && !v.getValue().trim().equals("")) {
            this.metadataMappings.put((Object)fieldName, (Object)v.getValue());
            return true;
        }
        return false;
    }

    protected MetadataValue resolveMetadataField(String configFilter) {
        ArrayList<MetadataValue> fields = this.resolveMetadata(configFilter, 0);
        if (null != fields && fields.size() > 0) {
            return fields.get(0);
        }
        return null;
    }

    protected ArrayList<MetadataValue> resolveMetadataFields(String configFilter) {
        ArrayList<MetadataValue> fields = this.resolveMetadata(configFilter, 1);
        if (null != fields && fields.size() > 0) {
            return fields;
        }
        return null;
    }

    protected ArrayList<MetadataValue> resolveMetadata(String configFilter, int returnType) {
        if (null == configFilter || configFilter.trim().equals("") || !configFilter.contains(".")) {
            log.error((Object)("The configuration string [" + configFilter + "] is invalid."));
            return null;
        }
        configFilter = configFilter.trim();
        ArrayList<ArrayList<String>> parsedOptions = this.parseOptions(configFilter);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Resolved Fields For This Item Per Configuration Filter:");
            for (int i = 0; i < parsedOptions.size(); ++i) {
                ArrayList<String> optionFields = parsedOptions.get(i);
                log.debug((Object)("Option " + (i + 1) + ":"));
                for (String f : optionFields) {
                    log.debug((Object)("{" + f + "}"));
                }
            }
        }
        for (ArrayList<String> optionFields : parsedOptions) {
            int optionMatches = 0;
            ArrayList<MetadataValue> resolvedFields = new ArrayList<MetadataValue>();
            for (String field : optionFields) {
                String[] components = this.parseComponents(field);
                List<MetadataValue> values = this.itemService.getMetadata(this.item, components[0], components[1], components[2], "*");
                if (values.size() <= 0) continue;
                for (MetadataValue v : values) {
                    resolvedFields.add(v);
                    if (returnType != 0 || resolvedFields.isEmpty()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Resolved Field Value For This Item:");
                        for (MetadataValue r : resolvedFields) {
                            log.debug((Object)("{" + r.getValue() + "}"));
                        }
                    }
                    return resolvedFields;
                }
            }
            if (resolvedFields.isEmpty()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resolved Field Values For This Item:");
                for (MetadataValue v : resolvedFields) {
                    log.debug((Object)("{" + v.getValue() + "}"));
                }
            }
            if (!(2 == returnType ? resolvedFields.size() == optionMatches : 1 == returnType)) continue;
            return resolvedFields;
        }
        return null;
    }

    protected ArrayList<ArrayList<String>> parseOptions(String configFilter) {
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<ArrayList<String>> parsedOptions = new ArrayList<ArrayList<String>>();
        if (null == configFilter || configFilter.equals("")) {
            return null;
        }
        if (configFilter.contains("|")) {
            String[] configOptions = configFilter.split("\\|");
            for (String option : configOptions) {
                options.add(option.trim());
            }
        } else {
            options = new ArrayList();
            options.add(configFilter);
        }
        for (String option : options) {
            ArrayList<String> fields;
            ArrayList<String> parsedFields = new ArrayList<String>();
            if (option.contains(",")) {
                fields = this.parseFields(option);
            } else {
                fields = new ArrayList();
                fields.add(option);
            }
            for (String field : fields) {
                if (field.contains("*")) {
                    ArrayList<String> wc = this.parseWildcard(field);
                    for (String wcField : wc) {
                        if (parsedFields.contains(wcField)) continue;
                        parsedFields.add(wcField);
                    }
                    continue;
                }
                if (parsedFields.contains(field)) continue;
                parsedFields.add(field);
            }
            parsedOptions.add(parsedFields);
        }
        if (null != parsedOptions) {
            return parsedOptions;
        }
        return null;
    }

    protected ArrayList<String> parseFields(String configString) {
        ArrayList<String> fields = new ArrayList<String>();
        for (String field : configString.split("\\,")) {
            fields.add(field.trim());
        }
        return fields;
    }

    protected String[] parseComponents(String field) {
        int index = 0;
        String[] components = new String[3];
        for (String c : field.split("\\.")) {
            components[index] = c.trim();
            ++index;
        }
        return components;
    }

    protected ArrayList<String> parseWildcard(String field) {
        if (!field.contains("*")) {
            return null;
        }
        String[] components = this.parseComponents(field);
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].trim().equals("*")) continue;
            components[i] = "*";
        }
        List<MetadataValue> allMD = this.itemService.getMetadata(this.item, components[0], components[1], components[2], "*");
        ArrayList<String> expandedDC = new ArrayList<String>();
        for (MetadataValue metadataValue : allMD) {
            if (expandedDC.contains(this.buildFieldName(metadataValue))) continue;
            expandedDC.add(this.buildFieldName(metadataValue));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Field Names From Expanded Wildcard \"" + field + "\""));
            for (String string : expandedDC) {
                log.debug((Object)("    " + string));
            }
        }
        return expandedDC;
    }

    protected String buildFieldName(MetadataValue v) {
        StringBuilder name = new StringBuilder();
        MetadataField metadataField = v.getMetadataField();
        MetadataSchema metadataSchema = v.getMetadataField().getMetadataSchema();
        name.append(metadataSchema.getName()).append(".").append(metadataField.getElement());
        if (null != metadataField.getQualifier()) {
            name.append("." + metadataField.getQualifier());
        }
        return name.toString();
    }

    protected void parseItem() {
        this.addSingleField("citation_title");
        this.addMultipleValues("citation_author");
        this.addSingleField("citation_date");
        this.addSingleField("citation_issn");
        this.addSingleField("citation_isbn");
        this.addSingleField("citation_journal_title");
        this.addSingleField("citation_volume");
        this.addSingleField("citation_issue");
        this.addSingleField("citation_firstpage");
        this.addSingleField("citation_lastpage");
        this.addSingleField("citation_doi");
        this.addSingleField("citation_pmid");
        this.addSingleField("citation_abstract_html_url");
        this.addSingleField("citation_fulltext_html_url");
        this.addSingleField("citation_pdf_url");
        this.addSingleField("citation_language");
        this.addAggregateValues("citation_keywords", ";");
        this.addSingleField("citation_conference");
        if (this.itemIsDissertation()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ITEM TYPE:  DISSERTATION");
            }
            this.addSingleField("citation_dissertation_name");
            this.addSingleField("citation_dissertation_institution");
        }
        if (this.itemIsPatent()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ITEM TYPE:  PATENT");
            }
            this.addSingleField("citation_patent_number");
            String countryConfig = googleScholarSettings.get("citation_patent_country");
            if (null != countryConfig && !countryConfig.trim().equals("")) {
                this.metadataMappings.put((Object)"citation_patent_country", (Object)countryConfig.trim());
            }
            this.addSingleField("citation_publisher");
        }
        if (this.itemIsTechReport()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ITEM TYPE:  TECH REPORT");
            }
            this.addSingleField("citation_technical_report_number");
            this.addSingleField("citation_technical_report_institution");
        }
        if (!this.itemIsDissertation() && !this.itemIsTechReport()) {
            this.addSingleField("citation_publisher");
        }
    }

    public Collection<Map.Entry<String, String>> getMappings() {
        return this.metadataMappings.entries();
    }

    public List<Element> disseminateList() {
        ArrayList<Element> metas = new ArrayList<Element>();
        for (Map.Entry<String, String> m : this.getMappings()) {
            Element e = new Element("meta");
            e.setNamespace(null);
            e.setAttribute("name", m.getKey());
            e.setAttribute("content", m.getValue());
            metas.add(e);
        }
        return metas;
    }

    public List<String> getTitle() {
        return this.metadataMappings.get((Object)"citation_title");
    }

    public List<String> getJournalTitle() {
        return this.metadataMappings.get((Object)"citation_journal_title");
    }

    public List<String> getPublisher() {
        return this.metadataMappings.get((Object)"citation_publisher");
    }

    public List<String> getAuthors() {
        return this.metadataMappings.get((Object)"citation_author");
    }

    public List<String> getDate() {
        return this.metadataMappings.get((Object)"citation_date");
    }

    public List<String> getVolume() {
        return this.metadataMappings.get((Object)"citation_volume");
    }

    public List<String> getIssue() {
        return this.metadataMappings.get((Object)"citation_issue");
    }

    public List<String> getFirstpage() {
        return this.metadataMappings.get((Object)"citation_firstpage");
    }

    public List<String> getLastpage() {
        return this.metadataMappings.get((Object)"citation_lastpage");
    }

    public List<String> getDOI() {
        return this.metadataMappings.get((Object)"citation_doi");
    }

    public List<String> getPmid() {
        return this.metadataMappings.get((Object)"citation_pmid");
    }

    public List<String> getAbstractHTMLURL() {
        return this.metadataMappings.get((Object)"citation_abstract_html_url");
    }

    public List<String> getFulltextHTMLURL() {
        return this.metadataMappings.get((Object)"citation_fulltext_html_url");
    }

    public List<String> getPDFURL() {
        return this.metadataMappings.get((Object)"citation_pdf_url");
    }

    public List<String> getISSN() {
        return this.metadataMappings.get((Object)"citation_issn");
    }

    public List<String> getISBN() {
        return this.metadataMappings.get((Object)"citation_isbn");
    }

    public List<String> getLanguage() {
        return this.metadataMappings.get((Object)"citation_language");
    }

    public List<String> getKeywords() {
        return this.metadataMappings.get((Object)"citation_keywords");
    }

    public List<String> getConference() {
        return this.metadataMappings.get((Object)"citation_conference");
    }

    public List<String> getDissertationName() {
        return this.metadataMappings.get((Object)"citation_dissertation_name");
    }

    public List<String> getDissertationInstitution() {
        return this.metadataMappings.get((Object)"citation_dissertation_institution");
    }

    public List<String> getPatentNumber() {
        return this.metadataMappings.get((Object)"citation_patent_number");
    }

    public List<String> getPatentCountry() {
        return this.metadataMappings.get((Object)"citation_patent_country");
    }

    public List<String> getTechnicalReportNumber() {
        return this.metadataMappings.get((Object)"citation_technical_report_number");
    }

    public List<String> getTechnicalReportInstitution() {
        return this.metadataMappings.get((Object)"citation_technical_report_institution");
    }

    protected String getPDFSimpleUrl(Item item) {
        try {
            Bitstream bitstream = this.findLinkableFulltext(item);
            if (bitstream != null) {
                StringBuilder path = new StringBuilder();
                path.append(ConfigurationManager.getProperty("dspace.url"));
                if (item.getHandle() != null) {
                    path.append("/bitstream/");
                    path.append(item.getHandle());
                    path.append("/");
                    path.append(bitstream.getSequenceID());
                } else {
                    path.append("/retrieve/");
                    path.append(bitstream.getID());
                }
                path.append("/");
                path.append(Util.encodeBitstreamName(bitstream.getName(), "UTF-8"));
                return path.toString();
            }
        }
        catch (UnsupportedEncodingException ex) {
            log.debug((Object)ex.getMessage());
        }
        catch (SQLException ex) {
            log.debug((Object)ex.getMessage());
        }
        return "";
    }

    protected Bitstream findLinkableFulltext(Item item) throws SQLException {
        Bitstream bestSoFar = null;
        List<Bundle> contentBundles = this.itemService.getBundles(item, "ORIGINAL");
        for (Bundle bundle : contentBundles) {
            List<Bitstream> bitstreams = bundle.getBitstreams();
            Collections.sort(bitstreams, googleBitstreamComparator);
            for (Bitstream candidate : bitstreams) {
                if (candidate.equals(bundle.getPrimaryBitstream())) {
                    if (!this.isPublic(candidate)) continue;
                    return candidate;
                }
                if (bestSoFar != null || !this.isPublic(candidate)) continue;
                bestSoFar = candidate;
            }
        }
        return bestSoFar;
    }

    protected boolean isPublic(Bitstream bitstream) {
        if (bitstream == null) {
            return false;
        }
        boolean result = false;
        Context context = null;
        try {
            context = new Context();
            result = AuthorizeServiceFactory.getInstance().getAuthorizeService().authorizeActionBoolean(context, bitstream, 0, true);
        }
        catch (SQLException e) {
            log.error((Object)("Cannot determine whether bitstream is public, assuming it isn't. bitstream_id=" + bitstream.getID()), (Throwable)e);
        }
        return result;
    }

    protected void addAggregateValues(String field, String delimiter) {
        String authorConfig = googleScholarSettings.get(field);
        ArrayList<MetadataValue> fields = this.resolveMetadataFields(authorConfig);
        if (null != fields && !fields.isEmpty()) {
            StringBuilder fieldMetadata = new StringBuilder();
            int count = 0;
            for (MetadataValue metadataValue : fields) {
                fieldMetadata.append(metadataValue.getValue());
                if (count >= fields.size() - 1) continue;
                fieldMetadata.append(delimiter).append(" ");
                ++count;
            }
            this.metadataMappings.put((Object)field, (Object)fieldMetadata.toString());
        }
    }

    protected void addMultipleValues(String FIELD2) {
        String fieldConfig = googleScholarSettings.get(FIELD2);
        ArrayList<MetadataValue> fields = this.resolveMetadataFields(fieldConfig);
        if (null != fields && !fields.isEmpty()) {
            for (MetadataValue field : fields) {
                this.metadataMappings.put((Object)FIELD2, (Object)field.getValue());
            }
        }
    }

    protected boolean itemIsDissertation() {
        String dConfig = googleScholarSettings.get("identifiers.dissertation");
        if (null == dConfig || dConfig.trim().equals("")) {
            return false;
        }
        return this.identifyItemType(dConfig);
    }

    protected boolean itemIsPatent() {
        String dConfig = googleScholarSettings.get("identifiers.patent");
        if (null == dConfig || dConfig.trim().equals("")) {
            return false;
        }
        return this.identifyItemType(dConfig);
    }

    protected boolean itemIsTechReport() {
        String dConfig = googleScholarSettings.get("identifiers.technical_report");
        if (null == dConfig || dConfig.trim().equals("")) {
            return false;
        }
        return this.identifyItemType(dConfig);
    }

    protected boolean identifyItemType(String dConfig) {
        ArrayList<ArrayList<String>> options = this.parseOptions(dConfig);
        HashMap mdPairs = new HashMap();
        for (ArrayList<String> option : options) {
            String pair = option.get(0);
            String[] parsedPair = pair.split("\\:");
            if (2 == parsedPair.length) {
                if (mdPairs.containsKey(parsedPair[0].trim())) {
                    ((ArrayList)mdPairs.get(parsedPair[0].trim())).add(parsedPair[1]);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Registering Type Identifier:  " + parsedPair[0] + " => " + parsedPair[1]));
                    continue;
                }
                ArrayList<String> newField = new ArrayList<String>();
                newField.add(parsedPair[1].trim());
                mdPairs.put(parsedPair[0].trim(), newField);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Registering Type Identifier:  " + parsedPair[0] + " => " + parsedPair[1]));
                continue;
            }
            log.error((Object)"Malformed field identifier name/value pair");
        }
        StringBuilder sb = new StringBuilder();
        for (String value : mdPairs.keySet()) {
            sb.append(value).append(" | ");
        }
        ArrayList<MetadataValue> presentMD = this.resolveMetadataFields(sb.toString());
        if (null != presentMD && presentMD.size() != 0) {
            for (MetadataValue v : presentMD) {
                String fieldName = this.buildFieldName(v);
                if (!mdPairs.containsKey(fieldName)) continue;
                for (String configValue : (ArrayList)mdPairs.get(fieldName)) {
                    if (!configValue.equals(v.getValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        File loadedFile = null;
        URL url = null;
        InputStream is = null;
        String googleConfigFile = ConfigurationManager.getProperty("google-metadata.config");
        log.info((Object)("Using [" + googleConfigFile + "] for Google Metadata configuration"));
        loadedFile = new File(googleConfigFile);
        try {
            url = loadedFile.toURL();
        }
        catch (MalformedURLException mux) {
            log.error((Object)("Can't find Google Metadata configuration file: " + googleConfigFile), (Throwable)mux);
        }
        Properties properties = new Properties();
        try {
            is = url.openStream();
            properties.load(is);
        }
        catch (IOException iox) {
            log.error((Object)("Could not read Google Metadata configuration file: " + googleConfigFile), (Throwable)iox);
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = ((String)propertyNames.nextElement()).trim();
            if (!key.startsWith(GOOGLE_PREFIX)) continue;
            String name = key.substring(GOOGLE_PREFIX.length());
            String field = properties.getProperty(key);
            if (null == name || name.equals("") || null == field || field.equals("")) continue;
            googleScholarSettings.put(name.trim(), field.trim());
        }
        if (log.isDebugEnabled()) {
            GoogleMetadata.logConfiguration();
        }
    }
}

