/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.dao.ItemDAO;
import org.dspace.core.AbstractHibernateDSODAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class ItemDAOImpl
extends AbstractHibernateDSODAO<Item>
implements ItemDAO {
    private static final Logger log = Logger.getLogger(ItemDAOImpl.class);

    protected ItemDAOImpl() {
    }

    @Override
    public Iterator<Item> findAll(Context context, boolean archived) throws SQLException {
        Query query = this.createQuery(context, "FROM Item WHERE inArchive= :in_archive order by id");
        query.setParameter("in_archive", (Object)archived);
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findAll(Context context, boolean archived, boolean withdrawn) throws SQLException {
        Query query = this.createQuery(context, "FROM Item WHERE inArchive= :in_archive or withdrawn = :withdrawn order by id");
        query.setParameter("in_archive", (Object)archived);
        query.setParameter("withdrawn", (Object)withdrawn);
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findAll(Context context, boolean archived, boolean withdrawn, boolean discoverable, Date lastModified) throws SQLException {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("SELECT i FROM Item i");
        queryStr.append(" WHERE (inArchive = :in_archive OR withdrawn = :withdrawn)");
        queryStr.append(" AND discoverable = :discoverable");
        if (lastModified != null) {
            queryStr.append(" AND last_modified > :last_modified");
        }
        queryStr.append(" order by id");
        Query query = this.createQuery(context, queryStr.toString());
        query.setParameter("in_archive", (Object)archived);
        query.setParameter("withdrawn", (Object)withdrawn);
        query.setParameter("discoverable", (Object)discoverable);
        if (lastModified != null) {
            query.setTimestamp("last_modified", lastModified);
        }
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findBySubmitter(Context context, EPerson eperson) throws SQLException {
        Query query = this.createQuery(context, "FROM Item WHERE inArchive= :in_archive and submitter= :submitter order by id");
        query.setParameter("in_archive", (Object)true);
        query.setParameter("submitter", (Object)eperson);
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findBySubmitter(Context context, EPerson eperson, MetadataField metadataField, int limit) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT item FROM Item as item ");
        this.addMetadataLeftJoin(query, Item.class.getSimpleName().toLowerCase(), Collections.singletonList(metadataField));
        query.append(" WHERE item.inArchive = :in_archive");
        query.append(" AND item.submitter =:submitter");
        this.addMetadataSortQuery(query, Collections.singletonList(metadataField), null, Collections.singletonList("desc"));
        Query hibernateQuery = this.createQuery(context, query.toString());
        hibernateQuery.setParameter(metadataField.toString(), (Object)metadataField.getID());
        hibernateQuery.setParameter("in_archive", (Object)true);
        hibernateQuery.setParameter("submitter", (Object)eperson);
        hibernateQuery.setMaxResults(limit);
        return this.iterate(hibernateQuery);
    }

    @Override
    public Iterator<Item> findByMetadataField(Context context, MetadataField metadataField, String value, boolean inArchive) throws SQLException {
        String hqlQueryString = "SELECT item FROM Item as item join item.metadata metadatavalue WHERE item.inArchive=:in_archive AND metadatavalue.metadataField = :metadata_field";
        if (value != null) {
            hqlQueryString = hqlQueryString + " AND STR(metadatavalue.value) = :text_value";
        }
        Query query = this.createQuery(context, hqlQueryString + " order by item.id");
        query.setParameter("in_archive", (Object)inArchive);
        query.setParameter("metadata_field", (Object)metadataField);
        if (value != null) {
            query.setParameter("text_value", (Object)value);
        }
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findByMetadataQuery(Context context, List<List<MetadataField>> listFieldList, List<String> query_op, List<String> query_val, List<UUID> collectionUuids, String regexClause, int offset, int limit) throws SQLException {
        Criteria criteria = this.createCriteria(context, Item.class, "item");
        criteria.setFirstResult(offset);
        criteria.setMaxResults(limit);
        if (!collectionUuids.isEmpty()) {
            DetachedCriteria dcollCriteria = DetachedCriteria.forClass(Collection.class, (String)"coll");
            dcollCriteria.setProjection((Projection)Projections.property((String)"coll.id"));
            dcollCriteria.add((Criterion)Restrictions.eqProperty((String)"coll.id", (String)"item.owningCollection"));
            dcollCriteria.add(Restrictions.in((String)"coll.id", collectionUuids));
            criteria.add(Subqueries.exists((DetachedCriteria)dcollCriteria));
        }
        int index = Math.min(listFieldList.size(), Math.min(query_op.size(), query_val.size()));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < index; ++i) {
            OP op = OP.valueOf(query_op.get(i));
            if (op == null) {
                log.warn((Object)("Skipping Invalid Operator: " + query_op.get(i)));
                continue;
            }
            if ((op == OP.matches || op == OP.doesnt_match) && regexClause.isEmpty()) {
                log.warn((Object)("Skipping Unsupported Regex Operator: " + query_op.get(i)));
                continue;
            }
            DetachedCriteria subcriteria = DetachedCriteria.forClass(MetadataValue.class, (String)"mv");
            subcriteria.add((Criterion)Property.forName((String)"mv.dSpaceObject").eqProperty("item.id"));
            subcriteria.setProjection((Projection)Projections.property((String)"mv.dSpaceObject"));
            if (!listFieldList.get(i).isEmpty()) {
                subcriteria.add(Restrictions.in((String)"metadataField", (java.util.Collection)listFieldList.get(i)));
            }
            sb.append(op.name() + " ");
            if (op == OP.equals || op == OP.not_equals) {
                subcriteria.add((Criterion)Property.forName((String)"mv.value").eq((Object)query_val.get(i)));
                sb.append(query_val.get(i));
            } else if (op == OP.like || op == OP.not_like) {
                subcriteria.add((Criterion)Property.forName((String)"mv.value").like((Object)query_val.get(i)));
                sb.append(query_val.get(i));
            } else if (op == OP.contains || op == OP.doesnt_contain) {
                subcriteria.add((Criterion)Property.forName((String)"mv.value").like((Object)("%" + query_val.get(i) + "%")));
                sb.append(query_val.get(i));
            } else if (op == OP.matches || op == OP.doesnt_match) {
                subcriteria.add(Restrictions.sqlRestriction((String)regexClause, (Object)query_val.get(i), (Type)StandardBasicTypes.STRING));
                sb.append(query_val.get(i));
            }
            if (op == OP.exists || op == OP.equals || op == OP.like || op == OP.contains || op == OP.matches) {
                criteria.add(Subqueries.exists((DetachedCriteria)subcriteria));
                continue;
            }
            criteria.add(Subqueries.notExists((DetachedCriteria)subcriteria));
        }
        criteria.addOrder(Order.asc((String)"item.id"));
        log.debug((Object)String.format("Running custom query with %d filters", index));
        return this.list(criteria).iterator();
    }

    @Override
    public Iterator<Item> findByAuthorityValue(Context context, MetadataField metadataField, String authority, boolean inArchive) throws SQLException {
        Query query = this.createQuery(context, "SELECT item FROM Item as item join item.metadata metadatavalue WHERE item.inArchive=:in_archive AND metadatavalue.metadataField = :metadata_field AND metadatavalue.authority = :authority order by item.id");
        query.setParameter("in_archive", (Object)inArchive);
        query.setParameter("metadata_field", (Object)metadataField);
        query.setParameter("authority", (Object)authority);
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findArchivedByCollection(Context context, Collection collection, Integer limit, Integer offset) throws SQLException {
        Query query = this.createQuery(context, "select i from Item i join i.collections c WHERE :collection IN c AND i.inArchive=:in_archive order by i.id");
        query.setParameter("collection", (Object)collection);
        query.setParameter("in_archive", (Object)true);
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findAllByCollection(Context context, Collection collection) throws SQLException {
        Query query = this.createQuery(context, "select i from Item i join i.collections c WHERE :collection IN c order by i.id");
        query.setParameter("collection", (Object)collection);
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findAllByCollection(Context context, Collection collection, Integer limit, Integer offset) throws SQLException {
        Query query = this.createQuery(context, "select i from Item i join i.collections c WHERE :collection IN c order by i.id");
        query.setParameter("collection", (Object)collection);
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        return this.iterate(query);
    }

    @Override
    public int countItems(Context context, Collection collection, boolean includeArchived, boolean includeWithdrawn) throws SQLException {
        Query query = this.createQuery(context, "select count(i) from Item i join i.collections c WHERE :collection IN c AND i.inArchive=:in_archive AND i.withdrawn=:withdrawn");
        query.setParameter("collection", (Object)collection);
        query.setParameter("in_archive", (Object)includeArchived);
        query.setParameter("withdrawn", (Object)includeWithdrawn);
        return this.count(query);
    }

    @Override
    public int countItems(Context context, List<Collection> collections, boolean includeArchived, boolean includeWithdrawn) throws SQLException {
        if (collections.size() == 0) {
            return 0;
        }
        Query query = this.createQuery(context, "select count(distinct i) from Item i join i.collections collection WHERE collection IN (:collections) AND i.inArchive=:in_archive AND i.withdrawn=:withdrawn");
        query.setParameterList("collections", collections);
        query.setParameter("in_archive", (Object)includeArchived);
        query.setParameter("withdrawn", (Object)includeWithdrawn);
        return this.count(query);
    }

    @Override
    public Iterator<Item> findByLastModifiedSince(Context context, Date since) throws SQLException {
        Query query = this.createQuery(context, "SELECT i FROM item i WHERE last_modified > :last_modified order by id");
        query.setTimestamp("last_modified", since);
        return this.iterate(query);
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM Item"));
    }

    @Override
    public int countItems(Context context, boolean includeArchived, boolean includeWithdrawn) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(*) FROM Item i WHERE i.inArchive=:in_archive AND i.withdrawn=:withdrawn");
        query.setParameter("in_archive", (Object)includeArchived);
        query.setParameter("withdrawn", (Object)includeWithdrawn);
        return this.count(query);
    }

    static enum OP {
        equals,
        not_equals,
        like,
        not_like,
        contains,
        doesnt_contain,
        exists,
        doesnt_exist,
        matches,
        doesnt_match;

    }
}

