/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.List;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.dao.MetadataFieldDAO;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Query;
import org.hibernate.criterion.Order;

public class MetadataFieldDAOImpl
extends AbstractHibernateDAO<MetadataField>
implements MetadataFieldDAO {
    protected MetadataFieldDAOImpl() {
    }

    @Override
    public MetadataField find(Context context, int metadataFieldId, MetadataSchema metadataSchema, String element, String qualifier) throws SQLException {
        Query query = qualifier != null ? this.createQuery(context, "SELECT mf FROM MetadataField mf JOIN FETCH mf.metadataSchema ms WHERE mf.id != :id AND ms.name = :name AND mf.element = :element AND qualifier = :qualifier") : this.createQuery(context, "SELECT mf FROM MetadataField mf JOIN FETCH mf.metadataSchema ms WHERE mf.id != :id AND ms.name = :name AND mf.element = :element AND mf.qualifier IS NULL");
        query.setParameter("id", (Object)metadataFieldId);
        query.setParameter("name", (Object)metadataSchema.getName());
        query.setParameter("element", (Object)element);
        if (qualifier != null) {
            query.setParameter("qualifier", (Object)qualifier);
        }
        query.setCacheable(true);
        return (MetadataField)this.singleResult(query);
    }

    @Override
    public MetadataField findByElement(Context context, MetadataSchema metadataSchema, String element, String qualifier) throws SQLException {
        return this.findByElement(context, metadataSchema.getName(), element, qualifier);
    }

    @Override
    public MetadataField findByElement(Context context, String metadataSchema, String element, String qualifier) throws SQLException {
        Query query = qualifier != null && !qualifier.isEmpty() ? this.createQuery(context, "SELECT mf FROM MetadataField mf JOIN FETCH mf.metadataSchema ms WHERE ms.name = :name AND mf.element = :element AND qualifier = :qualifier") : this.createQuery(context, "SELECT mf FROM MetadataField mf JOIN FETCH mf.metadataSchema ms WHERE ms.name = :name AND mf.element = :element AND mf.qualifier IS NULL");
        query.setParameter("name", (Object)metadataSchema);
        query.setParameter("element", (Object)element);
        if (qualifier != null && !qualifier.isEmpty()) {
            query.setParameter("qualifier", (Object)qualifier);
        }
        query.setCacheable(true);
        return (MetadataField)this.singleResult(query);
    }

    @Override
    public List<MetadataField> findAll(Context context, Class<MetadataField> clazz) throws SQLException {
        Criteria criteria = this.createCriteria(context, MetadataField.class);
        criteria.createAlias("metadataSchema", "s").addOrder(Order.asc((String)"s.name")).addOrder(Order.asc((String)"element")).addOrder(Order.asc((String)"qualifier"));
        criteria.setFetchMode("metadataSchema", FetchMode.JOIN);
        criteria.setCacheable(true);
        return this.list(criteria);
    }

    @Override
    public List<MetadataField> findFieldsByElementNameUnqualified(Context context, String metadataSchema, String element) throws SQLException {
        Query query = this.createQuery(context, "SELECT mf FROM MetadataField mf JOIN FETCH mf.metadataSchema ms WHERE ms.name = :name AND mf.element = :element ");
        query.setParameter("name", (Object)metadataSchema);
        query.setParameter("element", (Object)element);
        query.setCacheable(true);
        return this.list(query);
    }

    @Override
    public List<MetadataField> findAllInSchema(Context context, MetadataSchema metadataSchema) throws SQLException {
        Query query = this.createQuery(context, "SELECT mf FROM MetadataField mf JOIN FETCH mf.metadataSchema ms WHERE ms.name = :name ORDER BY mf.element ASC, mf.qualifier ASC ");
        query.setParameter("name", (Object)metadataSchema.getName());
        query.setCacheable(true);
        return this.list(query);
    }
}

