/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.BufferedReader;
import java.io.FileReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.curate.Curator;
import org.dspace.curate.TaskQueue;
import org.dspace.curate.TaskQueueEntry;
import org.dspace.curate.factory.CurateServiceFactory;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;

public class CurationCli {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("t", "task", true, "curation task name");
        options.addOption("T", "taskfile", true, "file containing curation task names");
        options.addOption("i", "id", true, "Id (handle) of object to perform task on, or 'all' to perform on whole repository");
        options.addOption("q", "queue", true, "name of task queue to process");
        options.addOption("e", "eperson", true, "email address of curating eperson");
        options.addOption("r", "reporter", true, "reporter to manage results - use '-' to report to console. If absent, no reporting");
        options.addOption("s", "scope", true, "transaction scope to impose: use 'object', 'curation', or 'open'. If absent, 'open' applies");
        options.addOption("v", "verbose", false, "report activity to stdout");
        options.addOption("h", "help", false, "help");
        CommandLine line = parser.parse(options, args);
        String taskName = null;
        String taskFileName = null;
        String idName = null;
        String taskQueueName = null;
        String ePersonName = null;
        String reporterName = null;
        String scope = null;
        boolean verbose = false;
        if (line.hasOption('h')) {
            HelpFormatter help = new HelpFormatter();
            help.printHelp("CurationCli\n", options);
            System.out.println("\nwhole repo: CurationCli -t estimate -i all");
            System.out.println("single item: CurationCli -t generate -i itemId");
            System.out.println("task queue: CurationCli -q monthly");
            System.exit(0);
        }
        if (line.hasOption('t')) {
            taskName = line.getOptionValue('t');
        }
        if (line.hasOption('T')) {
            taskFileName = line.getOptionValue('T');
        }
        if (line.hasOption('i')) {
            idName = line.getOptionValue('i');
        }
        if (line.hasOption('q')) {
            taskQueueName = line.getOptionValue('q');
        }
        if (line.hasOption('e')) {
            ePersonName = line.getOptionValue('e');
        }
        if (line.hasOption('r')) {
            reporterName = line.getOptionValue('r');
        }
        if (line.hasOption('s')) {
            scope = line.getOptionValue('s');
        }
        if (line.hasOption('v')) {
            verbose = true;
        }
        if (idName == null && taskQueueName == null) {
            System.out.println("Id must be specified: a handle, 'all', or a task queue (-h for help)");
            System.exit(1);
        }
        if (taskName == null && taskFileName == null && taskQueueName == null) {
            System.out.println("A curation task or queue must be specified (-h for help)");
            System.exit(1);
        }
        if (scope != null && Curator.TxScope.valueOf(scope.toUpperCase()) == null) {
            System.out.println("Bad transaction scope '" + scope + "': only 'object', 'curation' or 'open' recognized");
            System.exit(1);
        }
        EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        Context c = new Context(Context.Mode.BATCH_EDIT);
        if (ePersonName != null) {
            EPerson ePerson = ePersonService.findByEmail(c, ePersonName);
            if (ePerson == null) {
                System.out.println("EPerson not found: " + ePersonName);
                System.exit(1);
            }
            c.setCurrentUser(ePerson);
        } else {
            c.turnOffAuthorisationSystem();
        }
        Curator curator = new Curator();
        if (reporterName != null) {
            curator.setReporter(reporterName);
        }
        if (scope != null) {
            Curator.TxScope txScope = Curator.TxScope.valueOf(scope.toUpperCase());
            curator.setTransactionScope(txScope);
        }
        curator.setInvoked(Curator.Invoked.BATCH);
        if (taskName != null) {
            if (verbose) {
                System.out.println("Adding task: " + taskName);
            }
            curator.addTask(taskName);
            if (verbose && !curator.hasTask(taskName)) {
                System.out.println("Task: " + taskName + " not resolved");
            }
        } else if (taskQueueName == null) {
            try (BufferedReader reader = null;){
                reader = new BufferedReader(new FileReader(taskFileName));
                while ((taskName = reader.readLine()) != null) {
                    if (verbose) {
                        System.out.println("Adding task: " + taskName);
                    }
                    curator.addTask(taskName);
                }
            }
        }
        long start = System.currentTimeMillis();
        if (verbose) {
            System.out.println("Starting curation");
        }
        if (idName != null) {
            if (verbose) {
                System.out.println("Curating id: " + idName);
            }
            if ("all".equals(idName)) {
                curator.curate(c, ContentServiceFactory.getInstance().getSiteService().findSite(c).getHandle());
            } else {
                curator.curate(c, idName);
            }
        } else {
            TaskQueue queue = (TaskQueue)CoreServiceFactory.getInstance().getPluginService().getSinglePlugin(TaskQueue.class);
            if (queue == null) {
                System.out.println("No implementation configured for queue");
                throw new UnsupportedOperationException("No queue service available");
            }
            long ticket = System.currentTimeMillis();
            for (TaskQueueEntry entry : queue.dequeue(taskQueueName, ticket)) {
                if (verbose) {
                    System.out.println("Curating id: " + entry.getObjectId());
                }
                curator.clear();
                if (entry.getObjectId().indexOf("/") > 0) {
                    for (String task : entry.getTaskNames()) {
                        curator.addTask(task);
                    }
                    curator.curate(c, entry.getObjectId());
                    continue;
                }
                EPerson agent = ePersonService.findByEmail(c, entry.getEpersonId());
                if (agent != null) {
                    c.setCurrentUser(agent);
                }
                CurateServiceFactory.getInstance().getWorkflowCuratorService().curate(curator, c, entry.getObjectId());
            }
            queue.release(taskQueueName, ticket, true);
        }
        c.complete();
        if (verbose) {
            long elapsed = System.currentTimeMillis() - start;
            System.out.println("Ending curation. Elapsed time: " + elapsed);
        }
    }
}

