/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.btree.BTree;
import jdbm.helper.StringComparator;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;

public class LoadLastLogin {
    public static void main(String[] argv) throws IOException, SQLException, AuthorizeException {
        String USAGE = "LoadLastLogin [options] path...path\n\n'path's are paths to DSpace log files";
        String loginRE = "([0-9-]+) ([0-9:]+)[^@]+@ ([^:]+):session_id=[^:]+:ip_addr=[0-9a-f.:]+:login:type=(implicit|explicit)";
        Options options = new Options();
        options.addOption("h", "help", false, "Explain options");
        options.addOption("p", "pretend", false, "Output TSV instead of updating database");
        options.addOption("v", "verbose", false, "Talk more about what we are doing");
        PosixParser parser = new PosixParser();
        CommandLine command = null;
        try {
            command = parser.parse(options, argv);
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            if (!(ex instanceof MissingOptionException)) {
                new HelpFormatter().printHelp("LoadLastLogin [options] path...path\n\n'path's are paths to DSpace log files", options);
            }
            System.exit(1);
        }
        if (command.hasOption('h')) {
            System.out.println("Load users' last_active dates into the database from DSpace logs.");
            System.out.println();
            new HelpFormatter().printHelp("LoadLastLogin [options] path...path\n\n'path's are paths to DSpace log files", options);
            System.exit(0);
        }
        boolean VERBOSE = command.hasOption('v');
        boolean PRETEND = command.hasOption('p');
        String[] args = command.getArgs();
        Properties rmProps = new Properties();
        rmProps.put("jdbm.disableTransactions", "true");
        String dbname = new File(System.getProperty("java.io.tmpdir"), "lastlogindb").getCanonicalPath();
        if (VERBOSE) {
            System.out.println("dbname:  " + dbname);
        }
        RecordManager stamps = RecordManagerFactory.createRecordManager((String)dbname, (Properties)rmProps);
        BTree stampDb = BTree.createInstance((RecordManager)stamps, (Comparator)new StringComparator());
        Pattern loginCracker = Pattern.compile("([0-9-]+) ([0-9:]+)[^@]+@ ([^:]+):session_id=[^:]+:ip_addr=[0-9a-f.:]+:login:type=(implicit|explicit)");
        SimpleDateFormat dateEncoder = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (String logName : args) {
            String line;
            BufferedReader logReader = new BufferedReader(new FileReader(logName));
            while (null != (line = logReader.readLine())) {
                Date stamp;
                Matcher loginMatcher;
                if (!line.contains(":login:") || !(loginMatcher = loginCracker.matcher(line)).matches()) continue;
                String date = loginMatcher.group(1);
                String time = loginMatcher.group(2);
                String user = loginMatcher.group(3);
                String logDateTime = date + ' ' + time;
                try {
                    stamp = dateEncoder.parse(logDateTime);
                }
                catch (java.text.ParseException ex) {
                    System.err.println("Skipping log record:  " + ex.getMessage());
                    continue;
                }
                Date previous = (Date)stampDb.find((Object)user);
                if (null != previous && !stamp.after(previous)) continue;
                stampDb.insert((Object)user, (Object)stamp, true);
            }
            logReader.close();
        }
        TupleBrowser walker = stampDb.browse();
        Tuple stamp = new Tuple();
        Context ctx = new Context();
        ctx.turnOffAuthorisationSystem();
        EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        while (walker.getNext(stamp)) {
            String name = (String)stamp.getKey();
            Date date = (Date)stamp.getValue();
            EPerson ePerson = ePersonService.findByEmail(ctx, name);
            if (null == ePerson) {
                ePerson = ePersonService.findByNetid(ctx, name);
            }
            if (null == ePerson) {
                System.err.println("Skipping unknown user:  " + name);
                continue;
            }
            Date previous = ePerson.getLastActive();
            if (null != previous && !date.after(previous)) continue;
            if (PRETEND) {
                System.out.printf("%s\t%s\t%s\t%s\t%s\n", ePerson.getID().toString(), date, ePerson.getEmail(), ePerson.getNetid(), ePerson.getFullName());
                continue;
            }
            ePerson.setLastActive(date);
            ePersonService.update(ctx, ePerson);
        }
        ctx.complete();
        stamps.close();
        File target = new File(dbname + ".db");
        if (target.exists()) {
            target.delete();
        }
        if ((target = new File(dbname + ".lg")).exists()) {
            target.delete();
        }
    }
}

