/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson.dao.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.MetadataField;
import org.dspace.core.AbstractHibernateDSODAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.dao.EPersonDAO;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class EPersonDAOImpl
extends AbstractHibernateDSODAO<EPerson>
implements EPersonDAO {
    protected EPersonDAOImpl() {
    }

    @Override
    public EPerson findByEmail(Context context, String email) throws SQLException {
        Criteria criteria = this.createCriteria(context, EPerson.class);
        criteria.add((Criterion)Restrictions.eq((String)"email", (Object)email.toLowerCase()));
        criteria.setCacheable(true);
        return (EPerson)this.uniqueResult(criteria);
    }

    @Override
    public EPerson findByNetid(Context context, String netid) throws SQLException {
        Criteria criteria = this.createCriteria(context, EPerson.class);
        criteria.add((Criterion)Restrictions.eq((String)"netid", (Object)netid));
        criteria.setCacheable(true);
        return (EPerson)this.uniqueResult(criteria);
    }

    @Override
    public List<EPerson> search(Context context, String query, List<MetadataField> queryFields, List<MetadataField> sortFields, int offset, int limit) throws SQLException {
        String queryString = "SELECT " + EPerson.class.getSimpleName().toLowerCase() + " FROM EPerson as " + EPerson.class.getSimpleName().toLowerCase() + " ";
        if (query != null) {
            query = "%" + query.toLowerCase() + "%";
        }
        Query hibernateQuery = this.getSearchQuery(context, queryString, query, queryFields, sortFields, null);
        if (0 <= offset) {
            hibernateQuery.setFirstResult(offset);
        }
        if (0 <= limit) {
            hibernateQuery.setMaxResults(limit);
        }
        return this.list(hibernateQuery);
    }

    @Override
    public int searchResultCount(Context context, String query, List<MetadataField> queryFields) throws SQLException {
        String queryString = "SELECT count(*) FROM EPerson as " + EPerson.class.getSimpleName().toLowerCase();
        Query hibernateQuery = this.getSearchQuery(context, queryString, query, queryFields, ListUtils.EMPTY_LIST, null);
        return this.count(hibernateQuery);
    }

    @Override
    public List<EPerson> findAll(Context context, MetadataField metadataSortField, String sortField) throws SQLException {
        String queryString = "SELECT " + EPerson.class.getSimpleName().toLowerCase() + " FROM EPerson as " + EPerson.class.getSimpleName().toLowerCase();
        List<MetadataField> sortFields = ListUtils.EMPTY_LIST;
        if (metadataSortField != null) {
            sortFields = Collections.singletonList(metadataSortField);
        }
        Query query = this.getSearchQuery(context, queryString, null, ListUtils.EMPTY_LIST, sortFields, sortField);
        return this.list(query);
    }

    @Override
    public List<EPerson> findByGroups(Context context, Set<Group> groups) throws SQLException {
        Query query = this.createQuery(context, "SELECT DISTINCT e FROM EPerson e JOIN e.groups g WHERE g.id IN (:idList) ");
        ArrayList<UUID> idList = new ArrayList<UUID>(groups.size());
        for (Group group : groups) {
            idList.add(group.getID());
        }
        query.setParameterList("idList", idList);
        return this.list(query);
    }

    @Override
    public List<EPerson> findWithPasswordWithoutDigestAlgorithm(Context context) throws SQLException {
        Criteria criteria = this.createCriteria(context, EPerson.class);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.isNotNull((String)"password"), (Criterion)Restrictions.isNull((String)"digestAlgorithm")));
        return this.list(criteria);
    }

    @Override
    public List<EPerson> findNotActiveSince(Context context, Date date) throws SQLException {
        Criteria criteria = this.createCriteria(context, EPerson.class);
        criteria.add((Criterion)Restrictions.le((String)"lastActive", (Object)date));
        return this.list(criteria);
    }

    protected Query getSearchQuery(Context context, String queryString, String queryParam, List<MetadataField> queryFields, List<MetadataField> sortFields, String sortField) throws SQLException {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(queryString);
        LinkedHashSet<MetadataField> metadataFieldsToJoin = new LinkedHashSet<MetadataField>();
        metadataFieldsToJoin.addAll(queryFields);
        metadataFieldsToJoin.addAll(sortFields);
        if (!CollectionUtils.isEmpty(metadataFieldsToJoin)) {
            this.addMetadataLeftJoin(queryBuilder, EPerson.class.getSimpleName().toLowerCase(), metadataFieldsToJoin);
        }
        if (queryParam != null) {
            this.addMetadataValueWhereQuery(queryBuilder, queryFields, "like", EPerson.class.getSimpleName().toLowerCase() + ".email like :queryParam");
        }
        if (!CollectionUtils.isEmpty(sortFields)) {
            this.addMetadataSortQuery(queryBuilder, sortFields, Collections.singletonList(sortField));
        }
        Query query = this.createQuery(context, queryBuilder.toString());
        if (StringUtils.isNotBlank((CharSequence)queryParam)) {
            query.setParameter("queryParam", (Object)("%" + queryParam.toLowerCase() + "%"));
        }
        for (MetadataField metadataField : metadataFieldsToJoin) {
            query.setParameter(metadataField.toString(), (Object)metadataField.getID());
        }
        return query;
    }

    @Override
    public List<EPerson> findAllSubscribers(Context context) throws SQLException {
        return this.list(this.createQuery(context, "SELECT DISTINCT e from Subscription s join s.ePerson e"));
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM EPerson"));
    }
}

