/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson.dao.impl;

import java.sql.SQLException;
import java.util.List;
import org.dspace.content.Collection;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Subscription;
import org.dspace.eperson.dao.SubscriptionDAO;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class SubscriptionDAOImpl
extends AbstractHibernateDAO<Subscription>
implements SubscriptionDAO {
    protected SubscriptionDAOImpl() {
    }

    @Override
    public List<Subscription> findByEPerson(Context context, EPerson eperson) throws SQLException {
        Criteria criteria = this.createCriteria(context, Subscription.class);
        criteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"ePerson", (Object)eperson)}));
        return this.list(criteria);
    }

    @Override
    public Subscription findByCollectionAndEPerson(Context context, EPerson eperson, Collection collection) throws SQLException {
        Criteria criteria = this.createCriteria(context, Subscription.class);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"ePerson", (Object)eperson), (Criterion)Restrictions.eq((String)"collection", (Object)collection)));
        return (Subscription)this.singleResult(criteria);
    }

    @Override
    public void deleteByCollection(Context context, Collection collection) throws SQLException {
        String hqlQuery = "delete from Subscription where collection=:collection";
        Query query = this.createQuery(context, hqlQuery);
        query.setParameter("collection", (Object)collection);
        query.executeUpdate();
    }

    @Override
    public void deleteByEPerson(Context context, EPerson eperson) throws SQLException {
        String hqlQuery = "delete from Subscription where ePerson=:ePerson";
        Query query = this.createQuery(context, hqlQuery);
        query.setParameter("ePerson", (Object)eperson);
        query.executeUpdate();
    }

    @Override
    public void deleteByCollectionAndEPerson(Context context, Collection collection, EPerson eperson) throws SQLException {
        String hqlQuery = "delete from Subscription where collection=:collection AND ePerson=:ePerson";
        Query query = this.createQuery(context, hqlQuery);
        query.setParameter("collection", (Object)collection);
        query.setParameter("ePerson", (Object)eperson);
        query.executeUpdate();
    }

    @Override
    public List<Subscription> findAllOrderedByEPerson(Context context) throws SQLException {
        Criteria criteria = this.createCriteria(context, Subscription.class);
        criteria.addOrder(Order.asc((String)"ePerson"));
        return this.list(criteria);
    }
}

