/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;
import org.jaxen.JaxenException;
import org.springframework.beans.factory.annotation.Required;

public class SimpleXpathMetadatumContributor
implements MetadataContributor<OMElement> {
    private MetadataFieldConfig field;
    private MetadataFieldMapping<OMElement, MetadataContributor<OMElement>> metadataFieldMapping;
    private Map<String, String> prefixToNamespaceMapping;
    private String query;

    public Map<String, String> getPrefixToNamespaceMapping() {
        return this.prefixToNamespaceMapping;
    }

    public MetadataFieldMapping<OMElement, MetadataContributor<OMElement>> getMetadataFieldMapping() {
        return this.metadataFieldMapping;
    }

    @Override
    public void setMetadataFieldMapping(MetadataFieldMapping<OMElement, MetadataContributor<OMElement>> metadataFieldMapping) {
        this.metadataFieldMapping = metadataFieldMapping;
    }

    @Resource(name="isiFullprefixMapping")
    public void setPrefixToNamespaceMapping(Map<String, String> prefixToNamespaceMapping) {
        this.prefixToNamespaceMapping = prefixToNamespaceMapping;
    }

    public SimpleXpathMetadatumContributor(String query, Map<String, String> prefixToNamespaceMapping, MetadataFieldConfig field) {
        this.query = query;
        this.prefixToNamespaceMapping = prefixToNamespaceMapping;
        this.field = field;
    }

    public SimpleXpathMetadatumContributor() {
    }

    public MetadataFieldConfig getField() {
        return this.field;
    }

    @Required
    public void setField(MetadataFieldConfig field) {
        this.field = field;
    }

    public String getQuery() {
        return this.query;
    }

    @Required
    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(OMElement t) {
        LinkedList<MetadatumDTO> values = new LinkedList<MetadatumDTO>();
        try {
            AXIOMXPath xpath = new AXIOMXPath(this.query);
            for (String ns : this.prefixToNamespaceMapping.keySet()) {
                xpath.addNamespace(this.prefixToNamespaceMapping.get(ns), ns);
            }
            List nodes = xpath.selectNodes((Object)t);
            for (Object el : nodes) {
                if (el instanceof OMElement) {
                    values.add(this.metadataFieldMapping.toDCValue(this.field, ((OMElement)el).getText()));
                    continue;
                }
                if (el instanceof OMAttribute) {
                    values.add(this.metadataFieldMapping.toDCValue(this.field, ((OMAttribute)el).getAttributeValue()));
                    continue;
                }
                if (el instanceof String) {
                    values.add(this.metadataFieldMapping.toDCValue(this.field, (String)el));
                    continue;
                }
                if (el instanceof OMText) {
                    values.add(this.metadataFieldMapping.toDCValue(this.field, ((OMText)el).getText()));
                    continue;
                }
                System.err.println("node of type: " + el.getClass());
            }
            return values;
        }
        catch (JaxenException e) {
            System.err.println(this.query);
            throw new RuntimeException(e);
        }
    }
}

