/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.rdf.ItemNotArchivedException;
import org.dspace.rdf.ItemNotDiscoverableException;
import org.dspace.rdf.ItemWithdrawnException;
import org.dspace.rdf.RDFMissingIdentifierException;
import org.dspace.rdf.factory.RDFFactory;
import org.dspace.services.factory.DSpaceServicesFactory;

public class RDFUtil {
    private static final Logger log = Logger.getLogger(RDFUtil.class);
    private static final AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    public static final String CONTENT_NEGOTIATION_KEY = "rdf.contentNegotiation.enable";
    public static final String CONVERTER_DSOTYPES_KEY = "rdf.converter.DSOtypes";
    public static final String STORAGE_GRAPHSTORE_PASSWORD_KEY = "rdf.storage.graphstore.password";
    public static final String CONTEXT_PATH_KEY = "rdf.contextPath";
    public static final String SPARQL_ENDPOINT_KEY = "rdf.public.sparql.endpoint";
    public static final String STORAGE_SPARQL_LOGIN_KEY = "rdf.storage.sparql.login";
    public static final String STORAGE_SPARQL_PASSWORD_KEY = "rdf.storage.sparql.password";
    public static final String STORAGE_GRAPHSTORE_ENDPOINT_KEY = "rdf.storage.graphstore.endpoint";
    public static final String STORAGE_SPARQL_ENDPOINT_KEY = "rdf.storage.sparql.endpoint";
    public static final String STORAGE_GRAPHSTORE_LOGIN_KEY = "rdf.storage.graphstore.login";

    public static Model loadModel(String identifier) {
        return RDFFactory.getInstance().getRDFStorage().load(identifier);
    }

    public static String generateIdentifier(Context context, DSpaceObject dso) throws SQLException {
        return RDFFactory.getInstance().getURIGenerator().generateIdentifier(context, dso);
    }

    public static String generateIdentifier(Context context, int type, UUID id, String handle, List<String> identifier) throws SQLException {
        return RDFFactory.getInstance().getURIGenerator().generateIdentifier(context, type, id, handle, identifier);
    }

    public static Model convert(Context context, DSpaceObject dso) throws RDFMissingIdentifierException, SQLException, ItemNotArchivedException, ItemWithdrawnException, ItemNotDiscoverableException, AuthorizeException, IllegalArgumentException {
        String[] dsoTypes = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty(CONVERTER_DSOTYPES_KEY);
        if (dsoTypes == null || dsoTypes.length == 0) {
            log.warn((Object)"Property rdf.rdf.converter.DSOtypes was not found or is empty. Will convert all type of DSpace Objects.");
        } else {
            boolean found = false;
            for (String type : dsoTypes) {
                if (!StringUtils.equalsIgnoreCase((String)Constants.typeText[dso.getType()], (String)type.trim())) continue;
                found = true;
                break;
            }
            if (!found) {
                log.warn((Object)("Configuration of DSpaceObjects of type " + Constants.typeText[dso.getType()] + " prohibitted by configuration."));
                return null;
            }
        }
        RDFUtil.isPublic(context, dso);
        return RDFFactory.getInstance().getRDFConverter().convert(context, dso);
    }

    public static Model convertAndStore(Context context, DSpaceObject dso) throws RDFMissingIdentifierException, SQLException, ItemNotArchivedException, ItemWithdrawnException, ItemNotDiscoverableException, AuthorizeException, IllegalArgumentException {
        Model convertedData = RDFUtil.convert(context, dso);
        String identifier = RDFUtil.generateIdentifier(context, dso);
        if (StringUtils.isEmpty((String)identifier)) {
            log.error((Object)("Cannot generate identifier for dso from type " + ContentServiceFactory.getInstance().getDSpaceObjectService(dso).getTypeText(dso) + " (id: " + dso.getID() + ")."));
            if (convertedData != null) {
                convertedData.close();
            }
            throw new RDFMissingIdentifierException(dso.getType(), dso.getID());
        }
        if (convertedData == null) {
            RDFFactory.getInstance().getRDFStorage().delete(identifier);
            return null;
        }
        RDFFactory.getInstance().getRDFStorage().store(identifier, convertedData);
        return convertedData;
    }

    public static void isPublic(Context context, DSpaceObject dso) throws SQLException, ItemNotArchivedException, ItemWithdrawnException, ItemNotDiscoverableException, AuthorizeException {
        if (dso instanceof Site) {
            return;
        }
        authorizeService.authorizeAction(context, dso, 0);
        if (dso instanceof Item) {
            Item item = (Item)dso;
            if (!item.isArchived()) {
                throw new ItemNotArchivedException();
            }
            if (!item.isDiscoverable()) {
                throw new ItemNotDiscoverableException();
            }
            if (item.isWithdrawn()) {
                throw new ItemWithdrawnException();
            }
        }
    }

    public static boolean isPublicBoolean(Context context, DSpaceObject dso) throws SQLException {
        try {
            RDFUtil.isPublic(context, dso);
        }
        catch (AuthorizeException | ItemNotArchivedException | ItemNotDiscoverableException | ItemWithdrawnException ex) {
            return false;
        }
        return true;
    }

    public static void delete(String uri) {
        RDFFactory.getInstance().getRDFStorage().delete(uri);
    }

    public static void delete(Context ctx, int type, UUID id, String handle, List<String> identifiers) throws SQLException, RDFMissingIdentifierException {
        String uri = RDFFactory.getInstance().getURIGenerator().generateIdentifier(ctx, type, id, handle, identifiers);
        if (uri == null) {
            throw new RDFMissingIdentifierException(type, id);
        }
        RDFFactory.getInstance().getRDFStorage().delete(uri);
    }
}

