/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.dspace.statistics.factory.StatisticsServiceFactory;
import org.dspace.statistics.util.SpiderDetectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiderDetector {
    private static final Logger log = LoggerFactory.getLogger(SpiderDetector.class);
    private static SpiderDetectorService spiderDetectorService = StatisticsServiceFactory.getInstance().getSpiderDetectorService();

    public static Set<String> getSpiderIpAddresses() {
        spiderDetectorService.loadSpiderIpAddresses();
        return spiderDetectorService.getTable().toSet();
    }

    public static Set<String> readPatterns(File patternFile) throws IOException {
        return spiderDetectorService.readPatterns(patternFile);
    }

    public static boolean isSpider(String clientIP, String proxyIPs, String hostname, String agent) {
        return spiderDetectorService.isSpider(clientIP, proxyIPs, hostname, agent);
    }

    public static boolean isSpider(HttpServletRequest request) {
        return spiderDetectorService.isSpider(request);
    }

    public static boolean isSpider(String ip) {
        return spiderDetectorService.isSpider(ip);
    }
}

