/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.bitstore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.core.Utils;
import org.dspace.storage.bitstore.BitStoreService;

public class DSBitStoreService
implements BitStoreService {
    private static Logger log = Logger.getLogger(DSBitStoreService.class);
    private static final int digitsPerLevel = 2;
    private static final int directoryLevels = 3;
    private static final String CSA = "MD5";
    private File baseDir;
    protected final String REGISTERED_FLAG = "-R";

    @Override
    public void init() {
    }

    @Override
    public String generateId() {
        return Utils.generateKey();
    }

    @Override
    public InputStream get(Bitstream bitstream) throws IOException {
        try {
            return new FileInputStream(this.getFile(bitstream));
        }
        catch (Exception e) {
            log.error((Object)("get(" + bitstream.getInternalId() + ")"), (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public void put(Bitstream bitstream, InputStream in) throws IOException {
        try {
            File file = this.getFile(bitstream);
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            file.createNewFile();
            try (FileOutputStream fos = new FileOutputStream(file);
                 DigestInputStream dis = new DigestInputStream(in, MessageDigest.getInstance(CSA));){
                Utils.bufferedCopy(dis, fos);
                in.close();
                bitstream.setSizeBytes(file.length());
                bitstream.setChecksum(Utils.toHex(dis.getMessageDigest().digest()));
                bitstream.setChecksumAlgorithm(CSA);
            }
            catch (NoSuchAlgorithmException nsae) {
                log.warn((Object)"Caught NoSuchAlgorithmException", (Throwable)nsae);
            }
        }
        catch (Exception e) {
            log.error((Object)("put(" + bitstream.getInternalId() + ", inputstream)"), (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public Map about(Bitstream bitstream, Map attrs) throws IOException {
        try {
            File file = this.getFile(bitstream);
            if (file != null && file.exists()) {
                if (attrs.containsKey("size_bytes")) {
                    attrs.put("size_bytes", file.length());
                }
                if (attrs.containsKey("checksum")) {
                    int count;
                    DigestInputStream dis = null;
                    try {
                        FileInputStream fis = new FileInputStream(file);
                        dis = new DigestInputStream(fis, MessageDigest.getInstance(CSA));
                    }
                    catch (NoSuchAlgorithmException e) {
                        log.warn((Object)"Caught NoSuchAlgorithmException", (Throwable)e);
                        throw new IOException("Invalid checksum algorithm");
                    }
                    int BUFFER_SIZE = 4096;
                    byte[] buffer = new byte[4096];
                    while ((count = dis.read(buffer, 0, 4096)) != -1) {
                    }
                    attrs.put("checksum", Utils.toHex(dis.getMessageDigest().digest()));
                    attrs.put("checksum_algorithm", CSA);
                    dis.close();
                }
                if (attrs.containsKey("modified")) {
                    attrs.put("modified", String.valueOf(file.lastModified()));
                }
                return attrs;
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)("about(" + bitstream.getInternalId() + ")"), (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public void remove(Bitstream bitstream) throws IOException {
        try {
            File file = this.getFile(bitstream);
            if (file != null) {
                if (file.delete()) {
                    DSBitStoreService.deleteParents(file);
                }
            } else {
                log.warn((Object)("Attempt to remove non-existent asset. ID: " + bitstream.getInternalId()));
            }
        }
        catch (Exception e) {
            log.error((Object)("remove(" + bitstream.getInternalId() + ")"), (Throwable)e);
            throw new IOException(e);
        }
    }

    private static synchronized void deleteParents(File file) {
        File directory;
        File[] files;
        if (file == null) {
            return;
        }
        File tmp = file;
        for (int i = 0; i < 3 && (files = (directory = tmp.getParentFile()).listFiles()).length == 0; ++i) {
            directory.delete();
            tmp = directory;
        }
    }

    protected File getFile(Bitstream bitstream) throws IOException {
        if (bitstream == null) {
            return null;
        }
        String sInternalId = bitstream.getInternalId();
        String sIntermediatePath = null;
        if (this.isRegisteredBitstream(sInternalId)) {
            sInternalId = sInternalId.substring("-R".length());
            sIntermediatePath = "";
        } else {
            if (sInternalId.contains(File.separator)) {
                sInternalId = sInternalId.substring(sInternalId.lastIndexOf(File.separator) + 1);
            }
            sIntermediatePath = this.getIntermediatePath(sInternalId);
        }
        StringBuilder bufFilename = new StringBuilder();
        bufFilename.append(this.baseDir.getCanonicalFile());
        bufFilename.append(File.separator);
        bufFilename.append(sIntermediatePath);
        bufFilename.append(sInternalId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Local filename for " + sInternalId + " is " + bufFilename.toString()));
        }
        return new File(bufFilename.toString());
    }

    protected String getIntermediatePath(String iInternalId) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int digits = i * 2;
            if (i > 0) {
                buf.append(File.separator);
            }
            buf.append(iInternalId.substring(digits, digits + 2));
        }
        buf.append(File.separator);
        return buf.toString();
    }

    public boolean isRegisteredBitstream(String internalId) {
        return internalId.startsWith("-R");
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }
}

