/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.storage.rdbms.PostgresUtils;
import org.dspace.workflow.factory.WorkflowServiceFactory;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.DbSupportFactory;
import org.flywaydb.core.internal.dbsupport.SqlScript;
import org.flywaydb.core.internal.info.MigrationInfoDumper;

public class DatabaseUtils {
    private static final Logger log = Logger.getLogger(DatabaseUtils.class);
    private static Flyway flywaydb;
    private static final String reindexDiscoveryFilePath;
    public static final String DBMS_POSTGRES = "postgres";
    public static final String DBMS_ORACLE = "oracle";
    public static final String DBMS_H2 = "h2";

    public static void main(String[] argv) {
        block129: {
            if (argv.length < 1) {
                System.out.println("\nDatabase action argument is missing.");
                System.out.println("Valid actions: 'test', 'info', 'migrate', 'repair', 'validate', 'update-sequences' or 'clean'");
                System.out.println("\nOr, type 'database help' for more information.\n");
                System.exit(1);
            }
            try {
                DataSource dataSource = DatabaseUtils.getDataSource();
                Flyway flyway = DatabaseUtils.setupFlyway(dataSource);
                if (argv[0].equalsIgnoreCase("test")) {
                    System.out.println("\nAttempting to connect to database");
                    try (Connection connection = dataSource.getConnection();){
                        System.out.println("Connected successfully!");
                        DatabaseUtils.printDBInfo(connection);
                        boolean issueFound = DatabaseUtils.printDBIssues(connection);
                        if (issueFound) {
                            System.exit(1);
                        } else {
                            System.exit(0);
                        }
                        break block129;
                    }
                    catch (SQLException sqle) {
                        System.err.println("\nError running 'test': ");
                        System.err.println(" - " + sqle);
                        System.err.println("\nPlease see the DSpace documentation for assistance.\n");
                        sqle.printStackTrace();
                        System.exit(1);
                    }
                    break block129;
                }
                if (argv[0].equalsIgnoreCase("info") || argv[0].equalsIgnoreCase("status")) {
                    try (Connection connection = dataSource.getConnection();){
                        boolean issueFound;
                        DatabaseUtils.printDBInfo(connection);
                        System.out.println("\n" + MigrationInfoDumper.dumpToAsciiTable((MigrationInfo[])flyway.info().all()));
                        if (!DatabaseUtils.tableExists(connection, flyway.getTable(), true)) {
                            System.out.println("\nNOTE: This database is NOT yet initialized for auto-migrations (via Flyway).");
                            String dbVersion = DatabaseUtils.determineDBVersion(connection);
                            if (dbVersion != null) {
                                System.out.println("\nYour database looks to be compatible with DSpace version " + dbVersion);
                                System.out.println("All upgrades *after* version " + dbVersion + " will be run during the next migration.");
                                System.out.println("\nIf you'd like to upgrade now, simply run 'dspace database migrate'.");
                            }
                        }
                        if (issueFound = DatabaseUtils.printDBIssues(connection)) {
                            System.exit(1);
                        } else {
                            System.exit(0);
                        }
                        break block129;
                    }
                    catch (SQLException e) {
                        System.err.println("Info exception:");
                        e.printStackTrace();
                        System.exit(1);
                    }
                    break block129;
                }
                if (argv[0].equalsIgnoreCase("migrate")) {
                    try (Connection connection = dataSource.getConnection();){
                        System.out.println("\nDatabase URL: " + connection.getMetaData().getURL());
                        if (argv.length == 2) {
                            if (argv[1].equalsIgnoreCase("ignored")) {
                                System.out.println("Migrating database to latest version AND running previously \"Ignored\" migrations... (Check logs for details)");
                                DatabaseUtils.updateDatabase(dataSource, connection, null, true);
                            } else {
                                String migrationVersion = argv[1];
                                BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
                                System.out.println("You've specified to migrate your database ONLY to version " + migrationVersion + " ...");
                                System.out.println("\nWARNING: It is highly likely you will see errors in your logs when the Metadata");
                                System.out.println("or Bitstream Format Registry auto-update. This is because you are attempting to");
                                System.out.println("use an OLD version " + migrationVersion + " Database with a newer DSpace API. NEVER do this in a");
                                System.out.println("PRODUCTION scenario. The resulting old DB is only useful for migration testing.\n");
                                System.out.print("Are you SURE you only want to migrate your database to version " + migrationVersion + "? [y/n]: ");
                                String choiceString = input.readLine();
                                input.close();
                                if (choiceString.equalsIgnoreCase("y")) {
                                    System.out.println("Migrating database ONLY to version " + migrationVersion + " ... (Check logs for details)");
                                    DatabaseUtils.updateDatabase(dataSource, connection, migrationVersion, false);
                                } else {
                                    System.out.println("No action performed.");
                                }
                            }
                        } else {
                            System.out.println("Migrating database to latest version... (Check dspace logs for details)");
                            DatabaseUtils.updateDatabase(dataSource, connection);
                        }
                        System.out.println("Done.");
                        System.exit(0);
                        break block129;
                    }
                    catch (SQLException e) {
                        System.err.println("Migration exception:");
                        e.printStackTrace();
                        System.exit(1);
                    }
                    break block129;
                }
                if (argv[0].equalsIgnoreCase("repair")) {
                    try (Connection connection = dataSource.getConnection();){
                        System.out.println("\nDatabase URL: " + connection.getMetaData().getURL());
                        System.out.println("Attempting to repair any previously failed migrations (or mismatched checksums) via FlywayDB... (Check dspace logs for details)");
                        flyway.repair();
                        System.out.println("Done.");
                        System.exit(0);
                        break block129;
                    }
                    catch (SQLException | FlywayException e) {
                        System.err.println("Repair exception:");
                        e.printStackTrace();
                        System.exit(1);
                    }
                    break block129;
                }
                if (argv[0].equalsIgnoreCase("validate")) {
                    try (Connection connection = dataSource.getConnection();){
                        System.out.println("\nDatabase URL: " + connection.getMetaData().getURL());
                        System.out.println("Attempting to validate database status (and migration checksums) via FlywayDB...");
                        flyway.validate();
                        System.out.println("No errors thrown. Validation succeeded. (Check dspace logs for more details)");
                        System.exit(0);
                        break block129;
                    }
                    catch (SQLException | FlywayException e) {
                        System.err.println("Validation exception:");
                        e.printStackTrace();
                        System.exit(1);
                    }
                    break block129;
                }
                if (argv[0].equalsIgnoreCase("clean")) {
                    if (flyway.isCleanDisabled()) {
                        System.out.println("\nWARNING: 'clean' command is currently disabled, as it is dangerous to run in Production scenarios!");
                        System.out.println("\nIn order to run a 'clean' you first must enable it in your DSpace config by specifying 'db.cleanDisabled=false'.\n");
                        System.exit(1);
                    }
                    try (Connection connection = dataSource.getConnection();){
                        String dbType = DatabaseUtils.getDbType(connection);
                        if (dbType.equals(DBMS_POSTGRES) && !PostgresUtils.checkCleanPermissions(connection)) {
                            String username = connection.getMetaData().getUserName();
                            System.out.println("\nERROR: The database user '" + username + "' does not have sufficient privileges to run a 'database clean' (via Flyway).");
                            System.out.println("\nIn order to run a 'clean', the database user MUST have 'superuser' privileges");
                            System.out.println("OR the 'pgcrypto' extension must be installed in a separate schema (see documentation).");
                            System.out.println("\nOptionally, you could also manually remove the 'pgcrypto' extension first (DROP EXTENSION pgcrypto CASCADE;), then rerun the 'clean'");
                            System.exit(1);
                        }
                        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
                        System.out.println("\nDatabase URL: " + connection.getMetaData().getURL());
                        System.out.println("\nWARNING: ALL DATA AND TABLES IN YOUR DATABASE WILL BE PERMANENTLY DELETED.\n");
                        System.out.println("There is NO turning back from this action. Backup your DB before continuing.");
                        if (dbType.equals(DBMS_ORACLE)) {
                            System.out.println("\nORACLE WARNING: your RECYCLEBIN will also be PURGED.\n");
                        } else if (dbType.equals(DBMS_POSTGRES)) {
                            System.out.println("\nPOSTGRES WARNING: the 'pgcrypto' extension will be dropped if it is in the same schema as the DSpace database.\n");
                        }
                        System.out.print("Do you want to PERMANENTLY DELETE everything from your database? [y/n]: ");
                        String choiceString = input.readLine();
                        input.close();
                        if (choiceString.equalsIgnoreCase("y")) {
                            System.out.println("Scrubbing database clean... (Check dspace logs for details)");
                            DatabaseUtils.cleanDatabase(flyway, dataSource);
                            System.out.println("Done.");
                            System.exit(0);
                        } else {
                            System.out.println("No action performed.");
                        }
                        break block129;
                    }
                    catch (SQLException e) {
                        System.err.println("Clean exception:");
                        e.printStackTrace();
                        System.exit(1);
                    }
                    break block129;
                }
                if (argv[0].equalsIgnoreCase("update-sequences")) {
                    try (Connection connection = dataSource.getConnection();){
                        String dbType = DatabaseUtils.getDbType(connection);
                        String sqlfile = "org/dspace/storage/rdbms/sqlmigration/" + dbType + "/update-sequences.sql";
                        InputStream sqlstream = DatabaseUtils.class.getClassLoader().getResourceAsStream(sqlfile);
                        if (sqlstream != null) {
                            String s = IOUtils.toString((InputStream)sqlstream, (String)"UTF-8");
                            if (!s.isEmpty()) {
                                System.out.println("Running " + sqlfile);
                                connection.createStatement().execute(s);
                                System.out.println("update-sequences complete");
                            } else {
                                System.err.println(sqlfile + " contains no SQL to execute");
                            }
                        } else {
                            System.err.println(sqlfile + " not found");
                        }
                        break block129;
                    }
                }
                System.out.println("\nUsage: database [action]");
                System.out.println("Valid actions: 'test', 'info', 'migrate', 'repair', 'update-sequences' or 'clean'");
                System.out.println(" - test             = Performs a test connection to database to validate connection settings");
                System.out.println(" - info / status    = Describe basic info/status about database, including validating the compatibility of this database");
                System.out.println(" - migrate          = Migrate the database to the latest version");
                System.out.println(" - repair           = Attempt to repair any previously failed database migrations or checksum mismatches (via Flyway repair)");
                System.out.println(" - validate         = Validate current database's migration status (via Flyway validate), validating all migration checksums.");
                System.out.println(" - update-sequences = Update database sequences after running AIP ingest.");
                System.out.println(" - clean            = DESTROY all data and tables in database (WARNING there is no going back!). Requires 'db.cleanDisabled=false' setting in config.");
                System.out.println("");
                System.exit(0);
            }
            catch (Exception e) {
                System.err.println("Caught exception:");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static void printDBInfo(Connection connection) throws SQLException {
        DatabaseMetaData meta = connection.getMetaData();
        String dbType = DatabaseUtils.getDbType(connection);
        System.out.println("\nDatabase Type: " + dbType);
        System.out.println("Database URL: " + meta.getURL());
        System.out.println("Database Schema: " + DatabaseUtils.getSchemaName(connection));
        System.out.println("Database Username: " + meta.getUserName());
        System.out.println("Database Software: " + meta.getDatabaseProductName() + " version " + meta.getDatabaseProductVersion());
        System.out.println("Database Driver: " + meta.getDriverName() + " version " + meta.getDriverVersion());
        if (dbType.equals(DBMS_POSTGRES)) {
            boolean pgcryptoUpToDate = PostgresUtils.isPgcryptoUpToDate();
            Double pgcryptoVersion = PostgresUtils.getPgcryptoInstalledVersion(connection);
            System.out.println("PostgreSQL 'pgcrypto' extension installed/up-to-date? " + pgcryptoUpToDate + " " + (pgcryptoVersion != null ? "(version=" + pgcryptoVersion + ")" : "(not installed)"));
        }
    }

    private static boolean printDBIssues(Connection connection) throws SQLException {
        boolean issueFound = false;
        String dbType = DatabaseUtils.getDbType(connection);
        if (dbType.equals(DBMS_POSTGRES)) {
            Double pgcryptoAvailable = PostgresUtils.getPgcryptoAvailableVersion(connection);
            String requirementsMsg = "\n** DSpace REQUIRES PostgreSQL >= " + PostgresUtils.POSTGRES_VERSION + " AND " + "pgcrypto" + " extension >= " + PostgresUtils.PGCRYPTO_VERSION + " **\n";
            if (pgcryptoAvailable != null && pgcryptoAvailable.compareTo(PostgresUtils.PGCRYPTO_VERSION) >= 0) {
                Double pgcryptoInstalled = PostgresUtils.getPgcryptoInstalledVersion(connection);
                if (pgcryptoInstalled != null && pgcryptoInstalled.compareTo(PostgresUtils.PGCRYPTO_VERSION) < 0) {
                    System.out.println("\nWARNING: Required PostgreSQL 'pgcrypto' extension is OUTDATED (installed version=" + pgcryptoInstalled + ", available version = " + pgcryptoAvailable + ").");
                    System.out.println(requirementsMsg);
                    System.out.println("To update it, please connect to your DSpace database as a 'superuser' and manually run the following command: ");
                    System.out.println("\n  ALTER EXTENSION pgcrypto UPDATE TO '" + pgcryptoAvailable + "';\n");
                    issueFound = true;
                } else if (pgcryptoInstalled == null) {
                    System.out.println("\nWARNING: Required PostgreSQL 'pgcrypto' extension is NOT INSTALLED on this database.");
                    System.out.println(requirementsMsg);
                    System.out.println("To install it, please connect to your DSpace database as a 'superuser' and manually run the following command: ");
                    System.out.println("\n  CREATE EXTENSION pgcrypto;\n");
                    issueFound = true;
                }
            } else if (pgcryptoAvailable != null && pgcryptoAvailable.compareTo(PostgresUtils.PGCRYPTO_VERSION) < 0) {
                System.out.println("\nWARNING: UNSUPPORTED version of PostgreSQL 'pgcrypto' extension found (version=" + pgcryptoAvailable + ").");
                System.out.println(requirementsMsg);
                System.out.println("Make sure you are running a supported version of PostgreSQL, and then install pgcrypto version >= " + PostgresUtils.PGCRYPTO_VERSION);
                System.out.println("The 'pgcrypto' extension is often provided in the 'postgresql-contrib' package for your operating system.");
                issueFound = true;
            } else if (pgcryptoAvailable == null) {
                System.out.println("\nWARNING: PostgreSQL 'pgcrypto' extension is NOT AVAILABLE. Please install it into this PostgreSQL instance.");
                System.out.println(requirementsMsg);
                System.out.println("The 'pgcrypto' extension is often provided in the 'postgresql-contrib' package for your operating system.");
                System.out.println("Once the extension is installed globally, please connect to your DSpace database as a 'superuser' and manually run the following command: ");
                System.out.println("\n  CREATE EXTENSION pgcrypto;\n");
                issueFound = true;
            }
        }
        return issueFound;
    }

    private static synchronized Flyway setupFlyway(DataSource datasource) {
        ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
        if (flywaydb == null) {
            try (Connection connection = datasource.getConnection();){
                flywaydb = new Flyway();
                flywaydb.setDataSource(datasource);
                flywaydb.setEncoding("UTF-8");
                flywaydb.setCleanDisabled(config.getBooleanProperty("db.cleanDisabled", true));
                String dbType = DatabaseUtils.getDbType(connection);
                connection.close();
                ArrayList<String> scriptLocations = new ArrayList<String>();
                if (!dbType.equals(DBMS_H2)) {
                    scriptLocations.add("filesystem:" + config.getProperty("dspace.dir") + "/etc/" + dbType);
                }
                scriptLocations.add("classpath:org.dspace.storage.rdbms.sqlmigration." + dbType);
                scriptLocations.add("classpath:org.dspace.storage.rdbms.migration");
                List<String> workflowFlywayMigrationLocations = WorkflowServiceFactory.getInstance().getWorkflowService().getFlywayMigrationLocations();
                scriptLocations.addAll(workflowFlywayMigrationLocations);
                log.info((Object)("Loading Flyway DB migrations from: " + StringUtils.join(scriptLocations, (String)", ")));
                flywaydb.setLocations(scriptLocations.toArray(new String[scriptLocations.size()]));
                List flywayCallbacks = DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(FlywayCallback.class);
                flywaydb.setCallbacks(flywayCallbacks.toArray(new FlywayCallback[flywayCallbacks.size()]));
            }
            catch (SQLException e) {
                log.error((Object)"Unable to setup Flyway against DSpace database", (Throwable)e);
            }
        }
        return flywaydb;
    }

    public static synchronized void updateDatabase() throws SQLException {
        DataSource dataSource = DatabaseUtils.getDataSource();
        if (null == dataSource) {
            throw new SQLException("The DataSource is a null reference -- cannot continue.");
        }
        try (Connection connection = dataSource.getConnection();){
            DatabaseUtils.updateDatabase(dataSource, connection);
        }
    }

    protected static synchronized void updateDatabase(DataSource datasource, Connection connection) throws SQLException {
        DatabaseUtils.updateDatabase(datasource, connection, null, false);
    }

    protected static synchronized void updateDatabase(DataSource datasource, Connection connection, String targetVersion, boolean outOfOrder) throws SQLException {
        if (null == datasource) {
            throw new SQLException("The datasource is a null reference -- cannot continue.");
        }
        try {
            MigrationInfo[] pending;
            Flyway flyway = DatabaseUtils.setupFlyway(datasource);
            flyway.setOutOfOrder(outOfOrder);
            if (!StringUtils.isBlank((String)targetVersion)) {
                flyway.setTargetAsString(targetVersion);
            }
            if (!DatabaseUtils.tableExists(connection, flyway.getTable(), true)) {
                String dbVersion = DatabaseUtils.determineDBVersion(connection);
                if (dbVersion == null) {
                    flyway.baseline();
                } else {
                    flyway.setBaselineVersionAsString(dbVersion);
                    flyway.setBaselineDescription("Initializing from DSpace " + dbVersion + " database schema");
                    flyway.baseline();
                }
            }
            if ((pending = flyway.info().pending()) != null && pending.length > 0) {
                log.info((Object)"Pending DSpace database schema migrations:");
                for (MigrationInfo info : pending) {
                    log.info((Object)("\t" + info.getVersion() + " " + info.getDescription() + " " + info.getType() + " " + info.getState()));
                }
                flyway.migrate();
                DatabaseUtils.setReindexDiscovery(true);
            } else {
                log.info((Object)"DSpace database schema is up to date");
            }
        }
        catch (FlywayException fe) {
            throw new SQLException("Flyway migration error occurred", fe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void cleanDatabase(Flyway flyway, DataSource dataSource) throws SQLException {
        block18: {
            try {
                flyway.clean();
                try (Connection connection = dataSource.getConnection();){
                    String dbType = DatabaseUtils.getDbType(connection);
                    if (!dbType.equals(DBMS_ORACLE)) break block18;
                    PreparedStatement statement = null;
                    try {
                        statement = connection.prepareStatement("PURGE RECYCLEBIN");
                        statement.executeQuery();
                    }
                    finally {
                        if (statement != null && !statement.isClosed()) {
                            statement.close();
                        }
                    }
                }
            }
            catch (FlywayException fe) {
                throw new SQLException("Flyway clean error occurred", fe);
            }
        }
    }

    private static String determineDBVersion(Connection connection) throws SQLException {
        if (!DatabaseUtils.tableExists(connection, "Item")) {
            return null;
        }
        if (DatabaseUtils.tableColumnExists(connection, "metadatavalue", "resource_id")) {
            return "5.0.2014.09.26";
        }
        if (DatabaseUtils.tableColumnExists(connection, "requestitem", "request_message")) {
            return "5.0.2014.08.08";
        }
        if (DatabaseUtils.tableExists(connection, "Webapp")) {
            return "4.0";
        }
        if (DatabaseUtils.tableExists(connection, "versionitem")) {
            return "3.0";
        }
        if (DatabaseUtils.tableColumnExists(connection, "bundle2bitstream", "bitstream_order")) {
            return "1.8";
        }
        if (!DatabaseUtils.sequenceExists(connection, "dctyperegistry_seq")) {
            return "1.7";
        }
        if (DatabaseUtils.tableExists(connection, "harvested_collection")) {
            return "1.6";
        }
        if (DatabaseUtils.tableExists(connection, "collection_item_count")) {
            return "1.5";
        }
        if (DatabaseUtils.tableExists(connection, "Group2Group")) {
            return "1.4";
        }
        if (DatabaseUtils.tableExists(connection, "epersongroup2workspaceitem")) {
            return "1.3";
        }
        if (DatabaseUtils.tableExists(connection, "Community2Community")) {
            return "1.2";
        }
        if (DatabaseUtils.tableExists(connection, "Community")) {
            return "1.1";
        }
        throw new SQLException("CANNOT AUTOUPGRADE DSPACE DATABASE, AS IT DOES NOT LOOK TO BE A VALID DSPACE DATABASE.");
    }

    public static boolean tableExists(Connection connection, String tableName) {
        return DatabaseUtils.tableExists(connection, tableName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(Connection connection, String tableName, boolean caseSensitive) {
        boolean exists = false;
        ResultSet results = null;
        try {
            String schema = DatabaseUtils.getSchemaName(connection);
            DatabaseMetaData meta = connection.getMetaData();
            if (!caseSensitive) {
                schema = DatabaseUtils.canonicalize(connection, schema);
                tableName = DatabaseUtils.canonicalize(connection, tableName);
            }
            if ((results = meta.getTables(null, schema, tableName, null)) != null && results.next()) {
                exists = true;
            }
        }
        catch (SQLException e) {
            log.error((Object)("Error attempting to determine if table " + tableName + " exists"), (Throwable)e);
        }
        finally {
            try {
                if (results != null && !results.isClosed()) {
                    results.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableColumnExists(Connection connection, String tableName, String columnName) {
        boolean exists = false;
        ResultSet results = null;
        try {
            String schema = DatabaseUtils.getSchemaName(connection);
            schema = DatabaseUtils.canonicalize(connection, schema);
            tableName = DatabaseUtils.canonicalize(connection, tableName);
            columnName = DatabaseUtils.canonicalize(connection, columnName);
            DatabaseMetaData meta = connection.getMetaData();
            results = meta.getColumns(null, schema, tableName, columnName);
            if (results != null && results.next()) {
                exists = true;
            }
        }
        catch (SQLException e) {
            log.error((Object)("Error attempting to determine if column " + columnName + " exists"), (Throwable)e);
        }
        finally {
            try {
                if (results != null && !results.isClosed()) {
                    results.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sequenceExists(Connection connection, String sequenceName) {
        boolean exists = false;
        Statement statement = null;
        ResultSet results = null;
        boolean schemaFilter = false;
        try {
            String schema = DatabaseUtils.getSchemaName(connection);
            schema = DatabaseUtils.canonicalize(connection, schema);
            sequenceName = DatabaseUtils.canonicalize(connection, sequenceName);
            String dbtype = DatabaseUtils.getDbType(connection);
            String sequenceSQL = null;
            switch (dbtype) {
                case "postgres": {
                    if (schema == null) {
                        schema = "public";
                    }
                    sequenceSQL = "SELECT COUNT(1) FROM pg_class, pg_namespace WHERE pg_class.relnamespace=pg_namespace.oid AND pg_class.relkind='S' AND pg_class.relname=? AND pg_namespace.nspname=?";
                    schemaFilter = true;
                    break;
                }
                case "oracle": {
                    sequenceSQL = "SELECT COUNT(1) FROM user_sequences WHERE sequence_name=?";
                    break;
                }
                case "h2": {
                    sequenceSQL = "SELECT COUNT(1) FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_NAME = ?";
                    break;
                }
                default: {
                    throw new SQLException("DBMS " + dbtype + " is unsupported.");
                }
            }
            if (sequenceSQL != null) {
                statement = connection.prepareStatement(sequenceSQL);
                statement.setString(1, sequenceName);
                if (schemaFilter) {
                    statement.setString(2, schema);
                }
                if ((results = statement.executeQuery()) != null && results.next() && results.getInt(1) > 0) {
                    exists = true;
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)("Error attempting to determine if sequence " + sequenceName + " exists"), (Throwable)e);
        }
        finally {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
                if (results != null && !results.isClosed()) {
                    results.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return exists;
    }

    public static void executeSql(Connection connection, String sqlToExecute) throws SQLException {
        try {
            DbSupport dbSupport = DbSupportFactory.createDbSupport((Connection)connection, (boolean)false);
            SqlScript script = new SqlScript(sqlToExecute, dbSupport);
            script.execute(dbSupport.getJdbcTemplate());
        }
        catch (FlywayException fe) {
            throw new SQLException("Flyway executeSql() error occurred", fe);
        }
    }

    public static String getSchemaName(Connection connection) throws SQLException {
        String schema = null;
        try {
            schema = connection.getSchema();
        }
        catch (AbstractMethodError | Exception throwable) {
            // empty catch block
        }
        if (StringUtils.isBlank((String)schema)) {
            schema = DatabaseUtils.canonicalize(connection, DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("db.schema"));
        }
        if (StringUtils.isBlank((String)schema)) {
            String dbType = DatabaseUtils.getDbType(connection);
            if (dbType.equals(DBMS_POSTGRES)) {
                schema = "public";
            } else if (dbType.equals(DBMS_ORACLE)) {
                DatabaseMetaData meta = connection.getMetaData();
                schema = meta.getUserName();
            } else {
                schema = null;
            }
        }
        return schema;
    }

    public static String canonicalize(Connection connection, String dbIdentifier) throws SQLException {
        if (dbIdentifier == null) {
            return null;
        }
        DatabaseMetaData meta = connection.getMetaData();
        if (meta.storesLowerCaseIdentifiers()) {
            return StringUtils.lowerCase((String)dbIdentifier);
        }
        if (meta.storesUpperCaseIdentifiers()) {
            return StringUtils.upperCase((String)dbIdentifier);
        }
        return dbIdentifier;
    }

    public static synchronized void setReindexDiscovery(boolean reindex) {
        boolean deleted;
        File reindexFlag = new File(reindexDiscoveryFilePath);
        if (reindex) {
            try {
                if (!reindexFlag.exists()) {
                    reindexFlag.createNewFile();
                    reindexFlag.setWritable(true, false);
                }
            }
            catch (IOException io) {
                log.error((Object)("Unable to create Discovery reindex flag file " + reindexFlag.getAbsolutePath() + ". You may need to reindex manually."), (Throwable)io);
            }
        } else if (reindexFlag.exists() && !(deleted = reindexFlag.delete())) {
            log.error((Object)("Unable to delete Discovery reindex flag file " + reindexFlag.getAbsolutePath() + ". You may need to delete it manually."));
        }
    }

    public static boolean getReindexDiscovery() {
        boolean autoReindex = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("discovery.autoReindex", true);
        return autoReindex && new File(reindexDiscoveryFilePath).exists();
    }

    public static synchronized void checkReindexDiscovery(IndexingService indexer) {
        if (DatabaseUtils.getReindexDiscovery()) {
            ReindexerThread go = new ReindexerThread(indexer);
            go.start();
        }
    }

    public static String getDbType(Connection connection) throws SQLException {
        DatabaseMetaData meta = connection.getMetaData();
        String prodName = meta.getDatabaseProductName();
        String dbms_lc = prodName.toLowerCase(Locale.ROOT);
        if (dbms_lc.contains("postgresql")) {
            return DBMS_POSTGRES;
        }
        if (dbms_lc.contains(DBMS_ORACLE)) {
            return DBMS_ORACLE;
        }
        if (dbms_lc.contains(DBMS_H2)) {
            return DBMS_H2;
        }
        return dbms_lc;
    }

    protected static DataSource getDataSource() {
        DataSource dataSource = (DataSource)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("dataSource", DataSource.class);
        if (null == dataSource) {
            log.error((Object)"The service manager could not find the DataSource.");
        }
        return dataSource;
    }

    public static void clearFlywayDBCache() {
        flywaydb = null;
    }

    public static String getCurrentFlywayState(Connection connection) throws SQLException {
        PreparedStatement statement = connection.prepareStatement("SELECT \"version\" FROM \"schema_version\" ORDER BY \"version\" desc");
        ResultSet resultSet = statement.executeQuery();
        resultSet.next();
        return resultSet.getString("version");
    }

    public static Double getCurrentFlywayDSpaceState(Connection connection) throws SQLException {
        String flywayState = DatabaseUtils.getCurrentFlywayState(connection);
        Matcher matcher = Pattern.compile("^([0-9]*\\.[0-9]*)(\\.)?.*").matcher(flywayState);
        if (matcher.matches()) {
            return Double.parseDouble(matcher.group(1));
        }
        return null;
    }

    static {
        reindexDiscoveryFilePath = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir") + File.separator + "solr" + File.separator + "search" + File.separator + "conf" + File.separator + "reindex.flag";
    }

    private static class ReindexerThread
    extends Thread {
        private final IndexingService indexer;

        ReindexerThread(IndexingService is) {
            this.indexer = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IndexingService indexingService = this.indexer;
            synchronized (indexingService) {
                if (DatabaseUtils.getReindexDiscovery()) {
                    Context context = null;
                    try {
                        context = new Context();
                        context.turnOffAuthorisationSystem();
                        log.info((Object)"Post database migration, reindexing all content in Discovery search and browse engine");
                        this.indexer.cleanIndex(true);
                        this.indexer.createIndex(context);
                        this.indexer.buildSpellCheck();
                        log.info((Object)"Reindexing is complete");
                    }
                    catch (SearchServiceException sse) {
                        log.warn((Object)"Unable to reindex content in Discovery search and browse engine. You may need to reindex manually.", (Throwable)sse);
                    }
                    catch (IOException | SQLException e) {
                        log.error((Object)"Error attempting to reindex all contents for search/browse", (Throwable)e);
                    }
                    finally {
                        DatabaseUtils.setReindexDiscovery(false);
                        if (context != null && context.isValid()) {
                            context.abort();
                        }
                    }
                }
            }
        }
    }
}

