/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.bulkedit.BulkEditChange;
import org.dspace.app.bulkedit.BulkEditMetadataValue;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.DSpaceCSVLine;
import org.dspace.app.bulkedit.MetadataImportException;
import org.dspace.app.bulkedit.MetadataImportInvalidHeadingException;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.factory.AuthorityServiceFactory;
import org.dspace.authority.service.AuthorityValueService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Entity;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.EntityService;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.workflow.WorkflowService;
import org.dspace.workflow.factory.WorkflowServiceFactory;

public class MetadataImport {
    Context c;
    DSpaceCSV csv;
    List<DSpaceCSVLine> toImport;
    protected static Set<String> authorityControlled;
    protected static final String AC_PREFIX = "authority.controlled.";
    protected Map<String, Set<Integer>> csvRefMap = new HashMap<String, Set<Integer>>();
    protected HashMap<Integer, UUID> csvRowMap = new HashMap();
    protected static HashMap<UUID, String> entityTypeMap;
    protected static HashMap<String, HashMap<String, ArrayList<String>>> entityRelationMap;
    protected ArrayList<String> relationValidationErrors = new ArrayList();
    protected Integer rowCount = 1;
    protected static final Logger log;
    protected final AuthorityValueService authorityValueService;
    protected final ItemService itemService;
    protected final InstallItemService installItemService;
    protected final CollectionService collectionService;
    protected final HandleService handleService;
    protected final WorkspaceItemService workspaceItemService;
    protected final RelationshipTypeService relationshipTypeService;
    protected final RelationshipService relationshipService;
    protected final EntityTypeService entityTypeService;
    protected final EntityService entityService;

    public MetadataImport(Context c, DSpaceCSV toImport) {
        this.c = c;
        this.csv = toImport;
        this.toImport = toImport.getCSVLines();
        this.installItemService = ContentServiceFactory.getInstance().getInstallItemService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.collectionService = ContentServiceFactory.getInstance().getCollectionService();
        this.handleService = HandleServiceFactory.getInstance().getHandleService();
        this.authorityValueService = AuthorityServiceFactory.getInstance().getAuthorityValueService();
        this.workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
        this.relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
        this.relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
        this.entityTypeService = ContentServiceFactory.getInstance().getEntityTypeService();
        this.entityService = ContentServiceFactory.getInstance().getEntityService();
    }

    public List<BulkEditChange> runImport(boolean change, boolean useWorkflow, boolean workflowNotify, boolean useTemplate) throws MetadataImportException {
        ArrayList<BulkEditChange> changes = new ArrayList<BulkEditChange>();
        try {
            Context.Mode originalMode = this.c.getCurrentMode();
            this.c.setMode(Context.Mode.BATCH_EDIT);
            this.rowCount = 1;
            for (DSpaceCSVLine line : this.toImport) {
                List<String> collections;
                BulkEditChange whatHasChanged;
                this.populateRefAndRowMap(line, line.getID());
                line = this.resolveEntityRefs(line);
                UUID id = line.getID();
                if (this.csv.hasActions() && !"".equals(line.getAction()) && id == null) {
                    throw new MetadataImportException("'action' not allowed for new items!");
                }
                WorkspaceItem wsItem = null;
                ReloadableEntity wfItem = null;
                Item item = null;
                if (id != null) {
                    String action;
                    item = (Item)this.itemService.find(this.c, id);
                    if (item == null) {
                        throw new MetadataImportException("Unknown item ID " + id);
                    }
                    whatHasChanged = new BulkEditChange(item);
                    collections = line.get("collection");
                    if (collections != null) {
                        if (collections.size() == 0) {
                            throw new MetadataImportException("Missing collection from item " + item.getHandle());
                        }
                        List<Collection> actualCollections = item.getCollections();
                        this.compare(item, collections, actualCollections, whatHasChanged, change);
                    }
                    for (String md : line.keys()) {
                        if ("id".equals(md)) continue;
                        String[] fromCSV = line.get(md).toArray(new String[line.get(md).size()]);
                        if (!MetadataImport.isAuthorityControlledField(md)) {
                            for (int i = 0; i < fromCSV.length; ++i) {
                                int pos = fromCSV[i].indexOf(this.csv.getAuthoritySeparator());
                                if (pos <= -1) continue;
                                fromCSV[i] = fromCSV[i].substring(0, pos);
                            }
                        }
                        this.compareAndUpdate(item, fromCSV, change, md, whatHasChanged, line);
                    }
                    if (this.csv.hasActions() && !"".equals(action = line.getAction())) {
                        if ("expunge".equals(action)) {
                            if (!ConfigurationManager.getBooleanProperty("bulkedit", "allowexpunge", false)) {
                                throw new MetadataImportException("'expunge' action denied by configuration");
                            }
                            if (change) {
                                this.itemService.delete(this.c, item);
                            }
                            whatHasChanged.setDeleted();
                        } else if ("withdraw".equals(action)) {
                            if (!item.isWithdrawn()) {
                                if (change) {
                                    this.itemService.withdraw(this.c, item);
                                }
                                whatHasChanged.setWithdrawn();
                            }
                        } else if ("reinstate".equals(action)) {
                            if (item.isWithdrawn()) {
                                if (change) {
                                    this.itemService.reinstate(this.c, item);
                                }
                                whatHasChanged.setReinstated();
                            }
                        } else {
                            throw new MetadataImportException("Unknown action: " + action);
                        }
                    }
                    if (whatHasChanged.hasChanges()) {
                        changes.add(whatHasChanged);
                    }
                } else {
                    Collection collection;
                    if (this.c.getCurrentUser() == null) {
                        throw new MetadataImportException("When adding new items, a user must be specified with the -e option");
                    }
                    whatHasChanged = new BulkEditChange();
                    for (String md : line.keys()) {
                        if ("id".equals(md) || "rowName".equals(md)) continue;
                        String[] fromCSV = line.get(md).toArray(new String[line.get(md).size()]);
                        if (!MetadataImport.isAuthorityControlledField(md)) {
                            for (int i = 0; i < fromCSV.length; ++i) {
                                int pos = fromCSV[i].indexOf(this.csv.getAuthoritySeparator());
                                if (pos <= -1) continue;
                                fromCSV[i] = fromCSV[i].substring(0, pos);
                            }
                        }
                        this.add(fromCSV, md, whatHasChanged);
                    }
                    collections = line.get("collection");
                    if (collections == null) {
                        throw new MetadataImportException("New items must have a 'collection' assigned in the form of a handle");
                    }
                    ArrayList<Collection> check = new ArrayList<Collection>();
                    for (String handle : collections) {
                        try {
                            collection = (Collection)this.handleService.resolveToObject(this.c, handle);
                            if (collection == null) {
                                throw new MetadataImportException("'" + handle + "' is not a Collection! You must specify a valid collection for new items");
                            }
                            if (check.contains(collection)) {
                                throw new MetadataImportException("Duplicate collection assignment detected in new item! " + handle);
                            }
                            check.add(collection);
                        }
                        catch (Exception ex) {
                            throw new MetadataImportException("'" + handle + "' is not a Collection! You must specify a valid collection for new items", ex);
                        }
                    }
                    boolean first = true;
                    for (String handle : collections) {
                        Collection extra = (Collection)this.handleService.resolveToObject(this.c, handle);
                        if (first) {
                            whatHasChanged.setOwningCollection(extra);
                        } else {
                            whatHasChanged.registerNewMappedCollection(extra);
                        }
                        first = false;
                    }
                    if (change) {
                        String collectionHandle = line.get("collection").get(0);
                        collection = (Collection)this.handleService.resolveToObject(this.c, collectionHandle);
                        wsItem = this.workspaceItemService.create(this.c, collection, useTemplate);
                        item = wsItem.getItem();
                        for (BulkEditMetadataValue dcv : whatHasChanged.getAdds()) {
                            if (StringUtils.equals((CharSequence)dcv.getSchema(), (CharSequence)MetadataSchemaEnum.RELATION.getName())) continue;
                            this.itemService.addMetadata(this.c, item, dcv.getSchema(), dcv.getElement(), dcv.getQualifier(), dcv.getLanguage(), dcv.getValue(), dcv.getAuthority(), dcv.getConfidence());
                        }
                        for (BulkEditMetadataValue dcv : whatHasChanged.getAdds()) {
                            if (!StringUtils.equals((CharSequence)dcv.getSchema(), (CharSequence)MetadataSchemaEnum.RELATION.getName())) continue;
                            this.addRelationship(this.c, item, dcv.getElement(), dcv.getValue());
                        }
                        if (useWorkflow) {
                            WorkflowService workflowService = WorkflowServiceFactory.getInstance().getWorkflowService();
                            wfItem = workflowNotify ? (ReloadableEntity)workflowService.start(this.c, wsItem) : (ReloadableEntity)workflowService.startWithoutNotify(this.c, wsItem);
                        } else {
                            this.installItemService.installItem(this.c, wsItem);
                        }
                        if (line.get("collection").size() > 0) {
                            for (int i = 1; i < collections.size(); ++i) {
                                String handle = collections.get(i);
                                Collection extra = (Collection)this.handleService.resolveToObject(this.c, handle);
                                this.collectionService.addItem(this.c, extra, item);
                            }
                        }
                        whatHasChanged.setItem(item);
                    }
                    changes.add(whatHasChanged);
                }
                if (change) {
                    this.c.uncacheEntity(wsItem);
                    this.c.uncacheEntity(wfItem);
                    this.c.uncacheEntity(item);
                }
                this.populateRefAndRowMap(line, item == null ? null : item.getID());
                Integer n = this.rowCount;
                Integer n2 = this.rowCount = Integer.valueOf(this.rowCount + 1);
            }
            this.c.setMode(originalMode);
        }
        catch (MetadataImportException mie) {
            throw mie;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!change) {
            this.validateExpressedRelations();
        }
        return changes;
    }

    protected void compareAndUpdate(Item item, String[] fromCSV, boolean change, String md, BulkEditChange changes, DSpaceCSVLine line) throws SQLException, AuthorizeException, MetadataImportException {
        String[] dcvalues;
        Object all = "";
        for (String part : fromCSV) {
            all = (String)all + part + ",";
        }
        all = ((String)all).substring(0, ((String)all).length());
        log.debug(org.dspace.core.LogManager.getHeader(this.c, "metadata_import", "item_id=" + item.getID() + ",fromCSV=" + (String)all));
        if ("collection".equals(md) || "action".equals(md) || "rowName".equals(md)) {
            return;
        }
        String language = null;
        if (md.contains("[")) {
            String[] bits = md.split("\\[");
            language = bits[1].substring(0, bits[1].length() - 1);
        }
        AuthorityValue fromAuthority = this.authorityValueService.getAuthorityValueType(md);
        if (md.indexOf(58) > 0) {
            md = md.substring(md.indexOf(58) + 1);
        }
        String[] bits = md.split("\\.");
        String schema = bits[0];
        String element = bits[1];
        if (element.contains("[")) {
            element = element.substring(0, element.indexOf(91));
        }
        String qualifier = null;
        if (bits.length > 2 && (qualifier = bits[2]).contains("[")) {
            qualifier = qualifier.substring(0, qualifier.indexOf(91));
        }
        log.debug(org.dspace.core.LogManager.getHeader(this.c, "metadata_import", "item_id=" + item.getID() + ",fromCSV=" + (String)all + ",looking_for_schema=" + schema + ",looking_for_element=" + element + ",looking_for_qualifier=" + qualifier + ",looking_for_language=" + language));
        if (fromAuthority == null) {
            List<MetadataValue> current = this.itemService.getMetadata(item, schema, element, qualifier, language);
            dcvalues = new String[current.size()];
            int i = 0;
            for (MetadataValue dcv : current) {
                if (dcv.getAuthority() == null || !MetadataImport.isAuthorityControlledField(md)) {
                    dcvalues[i] = dcv.getValue();
                } else {
                    dcvalues[i] = dcv.getValue() + this.csv.getAuthoritySeparator() + dcv.getAuthority();
                    int n = i;
                    dcvalues[n] = dcvalues[n] + this.csv.getAuthoritySeparator() + (dcv.getConfidence() != -1 ? dcv.getConfidence() : 600);
                }
                ++i;
                log.debug(org.dspace.core.LogManager.getHeader(this.c, "metadata_import", "item_id=" + item.getID() + ",fromCSV=" + (String)all + ",found=" + dcv.getValue()));
            }
        } else {
            dcvalues = line.get(md).toArray(new String[line.get(md).size()]);
        }
        for (int v = 0; v < fromCSV.length; ++v) {
            Object value = fromCSV[v];
            BulkEditMetadataValue dcv = this.getBulkEditValueFromCSV(language, schema, element, qualifier, (String)value, fromAuthority);
            if (fromAuthority != null) {
                fromCSV[v] = value = dcv.getValue() + this.csv.getAuthoritySeparator() + dcv.getAuthority() + this.csv.getAuthoritySeparator() + dcv.getConfidence();
            }
            if (value != null && !"".equals(value) && !this.contains((String)value, dcvalues)) {
                changes.registerAdd(dcv);
                continue;
            }
            changes.registerConstant(dcv);
        }
        for (String value : dcvalues) {
            BulkEditMetadataValue dcv = new BulkEditMetadataValue();
            dcv.setSchema(schema);
            dcv.setElement(element);
            dcv.setQualifier(qualifier);
            dcv.setLanguage(language);
            if (value == null || !value.contains(this.csv.getAuthoritySeparator())) {
                this.simplyCopyValue(value, dcv);
            } else {
                String[] parts = value.split(this.csv.getAuthoritySeparator());
                dcv.setValue(parts[0]);
                dcv.setAuthority(parts[1]);
                dcv.setConfidence(parts.length > 2 ? Integer.valueOf(parts[2]) : 600);
            }
            if (value == null || "".equals(value) || this.contains(value, fromCSV) || fromAuthority != null) continue;
            log.debug(org.dspace.core.LogManager.getHeader(this.c, "metadata_import", "item_id=" + item.getID() + ",fromCSV=" + (String)all + ",removing_schema=" + schema + ",removing_element=" + element + ",removing_qualifier=" + qualifier + ",removing_language=" + language));
            changes.registerRemove(dcv);
        }
        if (change && (changes.getAdds().size() > 0 || changes.getRemoves().size() > 0)) {
            List<BulkEditMetadataValue> list = changes.getComplete();
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<String> authorities = new ArrayList<String>();
            ArrayList<Integer> confidences = new ArrayList<Integer>();
            for (BulkEditMetadataValue value : list) {
                if (qualifier == null && language == null) {
                    if (!schema.equals(value.getSchema()) || !element.equals(value.getElement()) || value.getQualifier() != null || value.getLanguage() != null) continue;
                    values.add(value.getValue());
                    authorities.add(value.getAuthority());
                    confidences.add(value.getConfidence());
                    continue;
                }
                if (qualifier == null) {
                    if (!schema.equals(value.getSchema()) || !element.equals(value.getElement()) || !language.equals(value.getLanguage()) || value.getQualifier() != null) continue;
                    values.add(value.getValue());
                    authorities.add(value.getAuthority());
                    confidences.add(value.getConfidence());
                    continue;
                }
                if (language == null) {
                    if (!schema.equals(value.getSchema()) || !element.equals(value.getElement()) || !qualifier.equals(value.getQualifier()) || value.getLanguage() != null) continue;
                    values.add(value.getValue());
                    authorities.add(value.getAuthority());
                    confidences.add(value.getConfidence());
                    continue;
                }
                if (!schema.equals(value.getSchema()) || !element.equals(value.getElement()) || !qualifier.equals(value.getQualifier()) || !language.equals(value.getLanguage())) continue;
                values.add(value.getValue());
                authorities.add(value.getAuthority());
                confidences.add(value.getConfidence());
            }
            if (StringUtils.equals((CharSequence)schema, (CharSequence)MetadataSchemaEnum.RELATION.getName())) {
                List<RelationshipType> relationshipTypeList = this.relationshipTypeService.findByLeftwardOrRightwardTypeName(this.c, element);
                for (RelationshipType relationshipType : relationshipTypeList) {
                    for (Relationship relationship : this.relationshipService.findByItemAndRelationshipType(this.c, item, relationshipType)) {
                        this.relationshipService.delete(this.c, relationship);
                        this.relationshipService.update(this.c, relationship);
                    }
                }
                this.addRelationships(this.c, item, element, values);
            } else {
                this.itemService.clearMetadata(this.c, item, schema, element, qualifier, language);
                this.itemService.addMetadata(this.c, item, schema, element, qualifier, language, values, authorities, confidences);
                this.itemService.update(this.c, item);
            }
        }
    }

    private void addRelationships(Context c, Item item, String typeName, List<String> values) throws SQLException, AuthorizeException, MetadataImportException {
        for (String value : values) {
            this.addRelationship(c, item, typeName, value);
        }
    }

    private Entity getEntity(Context context, String targetReference) throws MetadataImportException {
        Entity entity = null;
        UUID uuid = this.resolveEntityRef(context, targetReference);
        try {
            entity = this.entityService.findByItemId(context, uuid);
            if (entity.getItem() == null) {
                throw new IllegalArgumentException("No item found in repository with uuid: " + uuid);
            }
            return entity;
        }
        catch (SQLException sqle) {
            throw new MetadataImportException("Unable to find entity using reference: " + targetReference, sqle);
        }
    }

    private void addRelationship(Context c, Item item, String typeName, String value) throws SQLException, AuthorizeException, MetadataImportException {
        if (value.isEmpty()) {
            return;
        }
        boolean left = false;
        Entity relationEntity = this.getEntity(c, value);
        String relationEntityRelationshipType = this.itemService.getMetadata(relationEntity.getItem(), "relationship", "type", null, "*").get(0).getValue();
        String itemRelationshipType = this.itemService.getMetadata(item, "relationship", "type", null, "*").get(0).getValue();
        List<RelationshipType> relType = this.relationshipTypeService.findByLeftwardOrRightwardTypeName(c, typeName);
        RelationshipType foundRelationshipType = this.matchRelationshipType(relType, relationEntityRelationshipType, itemRelationshipType, typeName);
        if (foundRelationshipType == null) {
            throw new MetadataImportException("Error on CSV row " + this.rowCount + ":\nNo Relationship type found for:\nTarget type: " + relationEntityRelationshipType + "\nOrigin referer type: " + itemRelationshipType + "\nwith typeName: " + typeName);
        }
        if (foundRelationshipType.getLeftwardType().equalsIgnoreCase(typeName)) {
            left = true;
        }
        Item leftItem = null;
        Item rightItem = null;
        if (left) {
            leftItem = item;
            rightItem = relationEntity.getItem();
        } else {
            leftItem = relationEntity.getItem();
            rightItem = item;
        }
        int leftPlace = this.relationshipService.findNextLeftPlaceByLeftItem(c, leftItem);
        int rightPlace = this.relationshipService.findNextRightPlaceByRightItem(c, rightItem);
        Relationship persistedRelationship = this.relationshipService.create(c, leftItem, rightItem, foundRelationshipType, leftPlace, rightPlace);
        this.relationshipService.update(c, persistedRelationship);
    }

    protected void compare(Item item, List<String> collections, List<Collection> actualCollections, BulkEditChange bechange, boolean change) throws SQLException, AuthorizeException, IOException, MetadataImportException {
        boolean found;
        String oldOwner = item.getOwningCollection().getHandle();
        String newOwner = collections.get(0);
        Collection newCollection = (Collection)this.handleService.resolveToObject(this.c, newOwner);
        if (newCollection == null) {
            throw new MetadataImportException("'" + newOwner + "' is not a Collection! You must specify a valid collection ID");
        }
        if (!oldOwner.equals(newOwner)) {
            bechange.changeOwningCollection(item.getOwningCollection(), (Collection)this.handleService.resolveToObject(this.c, newOwner));
        }
        boolean first = true;
        for (String string : collections) {
            if (!first) {
                found = false;
                for (Collection collection : actualCollections) {
                    if (collection.getID() == item.getOwningCollection().getID() || !string.equals(collection.getHandle())) continue;
                    found = true;
                }
                DSpaceObject dso = this.handleService.resolveToObject(this.c, string);
                if (dso == null || dso.getType() != 3) {
                    throw new MetadataImportException("Collection defined for item " + item.getID() + " (" + item.getHandle() + ") is not a collection");
                }
                if (!found) {
                    Collection col = (Collection)dso;
                    bechange.registerNewMappedCollection(col);
                }
            }
            first = false;
        }
        for (Collection collection : actualCollections) {
            found = false;
            first = true;
            for (String csvcollection : collections) {
                if (first && collection.getID().equals(item.getOwningCollection().getID())) {
                    found = true;
                } else if (!first && collection.getHandle().equals(csvcollection)) {
                    found = true;
                }
                first = false;
            }
            if (found) continue;
            bechange.registerOldMappedCollection(collection);
        }
        if (change) {
            for (Collection collection : bechange.getOldMappedCollections()) {
                this.collectionService.removeItem(this.c, collection, item);
            }
            if (bechange.getNewOwningCollection() != null) {
                this.collectionService.addItem(this.c, bechange.getNewOwningCollection(), item);
                item.setOwningCollection(bechange.getNewOwningCollection());
                this.itemService.update(this.c, item);
            }
            if (bechange.getOldOwningCollection() != null) {
                boolean found2 = false;
                for (Collection c : item.getCollections()) {
                    if (!c.getID().equals(bechange.getOldOwningCollection().getID())) continue;
                    found2 = true;
                }
                if (found2) {
                    this.collectionService.removeItem(this.c, bechange.getOldOwningCollection(), item);
                }
            }
            for (Collection collection : bechange.getNewMappedCollections()) {
                this.collectionService.addItem(this.c, collection, item);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void add(String[] fromCSV, String md, BulkEditChange changes) throws SQLException, AuthorizeException {
        if ("collection".equals(md) || "action".equals(md)) {
            return;
        }
        String language = null;
        if (md.contains("[")) {
            String[] bits = md.split("\\[");
            language = bits[1].substring(0, bits[1].length() - 1);
        }
        AuthorityValue fromAuthority = this.authorityValueService.getAuthorityValueType(md);
        if (md.indexOf(58) > 0) {
            md = md.substring(md.indexOf(58) + 1);
        }
        String[] bits = md.split("\\.");
        String schema = bits[0];
        String element = bits[1];
        if (element.contains("[")) {
            element = element.substring(0, element.indexOf(91));
        }
        String qualifier = null;
        if (bits.length > 2 && (qualifier = bits[2]).contains("[")) {
            qualifier = qualifier.substring(0, qualifier.indexOf(91));
        }
        for (String string : fromCSV) {
            void var13_13;
            BulkEditMetadataValue dcv = this.getBulkEditValueFromCSV(language, schema, element, qualifier, string, fromAuthority);
            if (fromAuthority != null) {
                String string2 = dcv.getValue() + this.csv.getAuthoritySeparator() + dcv.getAuthority() + this.csv.getAuthoritySeparator() + dcv.getConfidence();
            }
            if (var13_13 == null || "".equals(var13_13)) continue;
            changes.registerAdd(dcv);
        }
    }

    protected BulkEditMetadataValue getBulkEditValueFromCSV(String language, String schema, String element, String qualifier, String value, AuthorityValue fromAuthority) {
        BulkEditMetadataValue dcv = new BulkEditMetadataValue();
        dcv.setSchema(schema);
        dcv.setElement(element);
        dcv.setQualifier(qualifier);
        dcv.setLanguage(language);
        if (fromAuthority != null) {
            if (value.indexOf(58) > 0) {
                value = value.substring(0, value.indexOf(58));
            }
            List<AuthorityValue> byValue = this.authorityValueService.findByValue(this.c, schema, element, qualifier, value);
            AuthorityValue authorityValue = null;
            if (byValue.isEmpty()) {
                String toGenerate = fromAuthority.generateString() + value;
                String field = schema + "_" + element + (String)(StringUtils.isNotBlank((CharSequence)qualifier) ? "_" + qualifier : "");
                authorityValue = this.authorityValueService.generate(this.c, toGenerate, value, field);
                dcv.setAuthority(toGenerate);
            } else {
                authorityValue = byValue.get(0);
                dcv.setAuthority(authorityValue.getId());
            }
            dcv.setValue(authorityValue.getValue());
            dcv.setConfidence(600);
        } else if (value == null || !value.contains(this.csv.getAuthoritySeparator())) {
            this.simplyCopyValue(value, dcv);
        } else {
            String[] parts = value.split(this.csv.getEscapedAuthoritySeparator());
            dcv.setValue(parts[0]);
            dcv.setAuthority(parts[1]);
            dcv.setConfidence(parts.length > 2 ? Integer.valueOf(parts[2]) : 600);
        }
        return dcv;
    }

    protected void simplyCopyValue(String value, BulkEditMetadataValue dcv) {
        dcv.setValue(value);
        dcv.setAuthority(null);
        dcv.setConfidence(-1);
    }

    protected boolean contains(String needle, String[] haystack) {
        for (String examine : haystack) {
            if (!this.clean(examine).equals(this.clean(needle))) continue;
            return true;
        }
        return false;
    }

    protected String clean(String in) {
        if (in == null) {
            return null;
        }
        return in.replaceAll("\r\n", "").replaceAll("\n", "").trim();
    }

    private static void printHelp(Options options, int exitCode) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("MetatadataImport\n", options);
        System.out.println("\nmetadataimport: MetadataImport -f filename");
        System.exit(exitCode);
    }

    private static int displayChanges(List<BulkEditChange> changes, boolean changed) {
        int changeCounter = 0;
        for (BulkEditChange change : changes) {
            String md;
            String cName;
            String cHandle;
            List<BulkEditMetadataValue> adds = change.getAdds();
            List<BulkEditMetadataValue> removes = change.getRemoves();
            List<Collection> newCollections = change.getNewMappedCollections();
            List<Collection> oldCollections = change.getOldMappedCollections();
            if (adds.size() > 0 || removes.size() > 0 || newCollections.size() > 0 || oldCollections.size() > 0 || change.getNewOwningCollection() != null || change.getOldOwningCollection() != null || change.isDeleted() || change.isWithdrawn() || change.isReinstated()) {
                Item i = change.getItem();
                System.out.println("-----------------------------------------------------------");
                if (!change.isNewItem()) {
                    System.out.println("Changes for item: " + i.getID() + " (" + i.getHandle() + ")");
                } else {
                    System.out.print("New item: ");
                    if (i != null) {
                        if (i.getHandle() != null) {
                            System.out.print(i.getID() + " (" + i.getHandle() + ")");
                        } else {
                            System.out.print(i.getID() + " (in workflow)");
                        }
                    }
                    System.out.println();
                }
                ++changeCounter;
            }
            if (change.isDeleted()) {
                if (changed) {
                    System.out.println(" - EXPUNGED!");
                } else {
                    System.out.println(" - EXPUNGE!");
                }
            }
            if (change.isWithdrawn()) {
                if (changed) {
                    System.out.println(" - WITHDRAWN!");
                } else {
                    System.out.println(" - WITHDRAW!");
                }
            }
            if (change.isReinstated()) {
                if (changed) {
                    System.out.println(" - REINSTATED!");
                } else {
                    System.out.println(" - REINSTATE!");
                }
            }
            if (change.getNewOwningCollection() != null) {
                String cName2;
                String cHandle2;
                Collection c = change.getNewOwningCollection();
                if (c != null) {
                    cHandle2 = c.getHandle();
                    cName2 = c.getName();
                    if (!changed) {
                        System.out.print(" + New owning collection (" + cHandle2 + "): ");
                    } else {
                        System.out.print(" + New owning collection  (" + cHandle2 + "): ");
                    }
                    System.out.println(cName2);
                }
                if ((c = change.getOldOwningCollection()) != null) {
                    cHandle2 = c.getHandle();
                    cName2 = c.getName();
                    if (!changed) {
                        System.out.print(" + Old owning collection (" + cHandle2 + "): ");
                    } else {
                        System.out.print(" + Old owning collection  (" + cHandle2 + "): ");
                    }
                    System.out.println(cName2);
                }
            }
            for (Collection c : newCollections) {
                cHandle = c.getHandle();
                cName = c.getName();
                if (!changed) {
                    System.out.print(" + Map to collection (" + cHandle + "): ");
                } else {
                    System.out.print(" + Mapped to collection  (" + cHandle + "): ");
                }
                System.out.println(cName);
            }
            for (Collection c : oldCollections) {
                cHandle = c.getHandle();
                cName = c.getName();
                if (!changed) {
                    System.out.print(" + Un-map from collection (" + cHandle + "): ");
                } else {
                    System.out.print(" + Un-mapped from collection  (" + cHandle + "): ");
                }
                System.out.println(cName);
            }
            for (BulkEditMetadataValue metadataValue : adds) {
                md = metadataValue.getSchema() + "." + metadataValue.getElement();
                if (metadataValue.getQualifier() != null) {
                    md = md + "." + metadataValue.getQualifier();
                }
                if (metadataValue.getLanguage() != null) {
                    md = md + "[" + metadataValue.getLanguage() + "]";
                }
                if (!changed) {
                    System.out.print(" + Add    (" + md + "): ");
                } else {
                    System.out.print(" + Added   (" + md + "): ");
                }
                System.out.print(metadataValue.getValue());
                if (MetadataImport.isAuthorityControlledField(md)) {
                    System.out.print(", authority = " + metadataValue.getAuthority());
                    System.out.print(", confidence = " + metadataValue.getConfidence());
                }
                System.out.println("");
            }
            for (BulkEditMetadataValue metadataValue : removes) {
                md = metadataValue.getSchema() + "." + metadataValue.getElement();
                if (metadataValue.getQualifier() != null) {
                    md = md + "." + metadataValue.getQualifier();
                }
                if (metadataValue.getLanguage() != null) {
                    md = md + "[" + metadataValue.getLanguage() + "]";
                }
                if (!changed) {
                    System.out.print(" - Remove (" + md + "): ");
                } else {
                    System.out.print(" - Removed (" + md + "): ");
                }
                System.out.print(metadataValue.getValue());
                if (MetadataImport.isAuthorityControlledField(md)) {
                    System.out.print(", authority = " + metadataValue.getAuthority());
                    System.out.print(", confidence = " + metadataValue.getConfidence());
                }
                System.out.println("");
            }
        }
        return changeCounter;
    }

    private static boolean isAuthorityControlledField(String md) {
        String mdf = StringUtils.substringAfter((String)md, (String)":");
        mdf = StringUtils.substringBefore((String)mdf, (String)"[");
        return authorityControlled.contains(mdf);
    }

    private static void setAuthorizedMetadataFields() {
        authorityControlled = new HashSet<String>();
        Enumeration<?> propertyNames = ConfigurationManager.getProperties().propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = ((String)propertyNames.nextElement()).trim();
            if (!key.startsWith(AC_PREFIX) || !ConfigurationManager.getBooleanProperty(key, false)) continue;
            authorityControlled.add(key.substring(AC_PREFIX.length()));
        }
    }

    public static void main(String[] argv) {
        List<BulkEditChange> changes;
        boolean validateOnly;
        MetadataImport importer;
        boolean change;
        Context c;
        boolean workflowNotify;
        boolean useWorkflow;
        boolean useTemplate;
        block32: {
            DSpaceCSV csv;
            CommandLine line;
            PosixParser parser = new PosixParser();
            Options options = new Options();
            options.addOption("f", "file", true, "source file");
            options.addOption("e", "email", true, "email address or user id of user (required if adding new items)");
            options.addOption("s", "silent", false, "silent operation - doesn't request confirmation of changes USE WITH CAUTION");
            options.addOption("w", "workflow", false, "workflow - when adding new items, use collection workflow");
            options.addOption("n", "notify", false, "notify - when adding new items using a workflow, send notification emails");
            options.addOption("t", "template", false, "template - when adding new items, use the collection template (if it exists)");
            options.addOption("v", "validate-only", false, "validate - just validate the csv, don't run the import");
            options.addOption("h", "help", false, "help");
            try {
                line = parser.parse(options, argv);
            }
            catch (ParseException pe) {
                System.err.println("Error parsing command line arguments: " + pe.getMessage());
                System.exit(1);
                return;
            }
            if (line.hasOption('h')) {
                MetadataImport.printHelp(options, 0);
            }
            if (!line.hasOption('f')) {
                System.err.println("Required parameter -f missing!");
                MetadataImport.printHelp(options, 1);
            }
            String filename = line.getOptionValue('f');
            useTemplate = false;
            if (line.hasOption('t')) {
                useTemplate = true;
            }
            useWorkflow = false;
            workflowNotify = false;
            if (line.hasOption('w')) {
                useWorkflow = true;
                if (line.hasOption('n')) {
                    workflowNotify = true;
                }
            } else if (line.hasOption('n')) {
                System.err.println("Invalid option 'n': (notify) can only be specified with the 'w' (workflow) option.");
                System.exit(1);
            }
            try {
                c = new Context();
                c.turnOffAuthorisationSystem();
            }
            catch (Exception e) {
                System.err.println("Unable to create a new DSpace Context: " + e.getMessage());
                System.exit(1);
                return;
            }
            try {
                if (line.hasOption('e')) {
                    String e = line.getOptionValue('e');
                    EPerson eperson = e.indexOf(64) != -1 ? EPersonServiceFactory.getInstance().getEPersonService().findByEmail(c, e) : (EPerson)EPersonServiceFactory.getInstance().getEPersonService().find(c, UUID.fromString(e));
                    if (eperson == null) {
                        System.out.println("Error, eperson cannot be found: " + e);
                        System.exit(1);
                    }
                    c.setCurrentUser(eperson);
                }
            }
            catch (Exception e) {
                System.err.println("Unable to find DSpace user: " + e.getMessage());
                System.exit(1);
                return;
            }
            change = false;
            try {
                csv = new DSpaceCSV(new File(filename), c);
            }
            catch (MetadataImportInvalidHeadingException miihe) {
                System.err.println(miihe.getMessage());
                System.exit(1);
                return;
            }
            catch (Exception e) {
                System.err.println("Error reading file: " + e.getMessage());
                System.exit(1);
                return;
            }
            importer = new MetadataImport(c, csv);
            validateOnly = line.hasOption('v');
            if (!line.hasOption('s') || validateOnly) {
                try {
                    changes = importer.runImport(false, useWorkflow, workflowNotify, useTemplate);
                }
                catch (MetadataImportException mie) {
                    System.err.println("Error: " + mie.getMessage());
                    System.exit(1);
                    return;
                }
                int changeCounter = MetadataImport.displayChanges(changes, false);
                if (!validateOnly && changeCounter > 0) {
                    try {
                        System.out.println("\n" + changeCounter + " item(s) will be changed\n");
                        System.out.print("Do you want to make these changes? [y/n] ");
                        String yn = new BufferedReader(new InputStreamReader(System.in)).readLine();
                        if ("y".equalsIgnoreCase(yn)) {
                            change = true;
                            break block32;
                        }
                        System.out.println("No data has been changed.");
                    }
                    catch (IOException ioe) {
                        System.err.println("Error: " + ioe.getMessage());
                        System.err.println("No changes have been made");
                        System.exit(1);
                    }
                } else {
                    System.out.println("There were no changes detected");
                }
            } else {
                change = true;
            }
        }
        try {
            if (change && !validateOnly) {
                try {
                    changes = importer.runImport(true, useWorkflow, workflowNotify, useTemplate);
                }
                catch (MetadataImportException mie) {
                    System.err.println("Error: " + mie.getMessage());
                    System.exit(1);
                    return;
                }
                MetadataImport.displayChanges(changes, true);
            }
            c.restoreAuthSystemState();
            c.complete();
        }
        catch (Exception e) {
            c.abort();
            System.err.println("Error committing changes to database: " + e.getMessage());
            System.err.println("Aborting most recent changes.");
            System.exit(1);
        }
    }

    public DSpaceCSVLine resolveEntityRefs(DSpaceCSVLine line) throws MetadataImportException {
        DSpaceCSVLine newLine = new DSpaceCSVLine(line.getID());
        UUID originId = this.evaluateOriginId(line.getID());
        for (String key : line.keys()) {
            if (key.split("\\.")[0].equalsIgnoreCase("relation")) {
                if (line.get(key).size() <= 0) continue;
                for (String val : line.get(key)) {
                    String uuid = this.resolveEntityRef(this.c, val).toString();
                    newLine.add(key, uuid);
                    this.populateEntityRelationMap(uuid, key, originId.toString());
                }
                continue;
            }
            if (line.get(key).size() > 1) {
                for (String value : line.get(key)) {
                    newLine.add(key, value);
                }
                continue;
            }
            if (line.get(key).size() <= 0) continue;
            newLine.add(key, line.get(key).get(0));
        }
        return newLine;
    }

    private void populateEntityRelationMap(String refUUID, String relationField, String originId) {
        HashMap<Object, Object> typeNames = null;
        if (entityRelationMap.get(refUUID) == null) {
            typeNames = new HashMap();
            ArrayList<String> originIds = new ArrayList<String>();
            originIds.add(originId);
            typeNames.put(relationField, originIds);
            entityRelationMap.put(refUUID, typeNames);
        } else {
            typeNames = entityRelationMap.get(refUUID);
            if (typeNames.get(relationField) == null) {
                ArrayList<String> originIds = new ArrayList<String>();
                originIds.add(originId);
                typeNames.put(relationField, originIds);
            } else {
                ArrayList originIds = (ArrayList)typeNames.get(relationField);
                originIds.add(originId);
                typeNames.put(relationField, originIds);
            }
            entityRelationMap.put(refUUID, typeNames);
        }
    }

    private void populateRefAndRowMap(DSpaceCSVLine line, @Nullable UUID uuid) {
        if (uuid != null) {
            this.csvRowMap.put(this.rowCount, uuid);
        } else {
            this.csvRowMap.put(this.rowCount, new UUID(0L, this.rowCount.intValue()));
        }
        for (String key : line.keys()) {
            if (key.contains(".") && !key.split("\\.")[0].equalsIgnoreCase("relation") || key.equalsIgnoreCase("rowName")) {
                for (String value : line.get(key)) {
                    String valueKey = key + ":" + value;
                    Set<Integer> rowNums = this.csvRefMap.get(valueKey);
                    if (rowNums == null) {
                        rowNums = new HashSet<Integer>();
                        this.csvRefMap.put(valueKey, rowNums);
                    }
                    rowNums.add(this.rowCount);
                }
            }
            if (!key.equalsIgnoreCase("relationship.type") || line.get(key).size() <= 0) continue;
            if (uuid == null) {
                entityTypeMap.put(new UUID(0L, this.rowCount.intValue()), line.get(key).get(0));
                continue;
            }
            entityTypeMap.put(uuid, line.get(key).get(0));
        }
    }

    private UUID resolveEntityRef(Context context, String reference) throws MetadataImportException {
        Set<UUID> csvUUIDs;
        UUID uuid = null;
        if (!reference.contains(":")) {
            try {
                return UUID.fromString(reference);
            }
            catch (IllegalArgumentException e) {
                throw new MetadataImportException("Error in CSV row " + this.rowCount + ":\nNot a UUID or indirect entity reference: '" + reference + "'");
            }
        }
        if (!reference.startsWith("rowName:")) {
            MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
            MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
            int i = reference.indexOf(":");
            String mfValue = reference.substring(i + 1);
            String[] mf = reference.substring(0, i).split("\\.");
            if (mf.length < 2) {
                throw new MetadataImportException("Error in CSV row " + this.rowCount + ":\nBad metadata field in reference: '" + reference + "' (expected syntax is schema.element[.qualifier])");
            }
            String schema = mf[0];
            String element = mf[1];
            String qualifier = mf.length == 2 ? null : mf[2];
            try {
                MetadataField mfo = metadataFieldService.findByElement(context, schema, element, qualifier);
                Iterator<MetadataValue> mdv = metadataValueService.findByFieldAndValue(context, mfo, mfValue);
                if (mdv.hasNext()) {
                    MetadataValue mdvVal = mdv.next();
                    uuid = mdvVal.getDSpaceObject().getID();
                    if (mdv.hasNext()) {
                        throw new MetadataImportException("Error in CSV row " + this.rowCount + ":\nAmbiguous reference; multiple matches in db: " + reference);
                    }
                }
            }
            catch (SQLException e) {
                throw new MetadataImportException("Error in CSV row " + this.rowCount + ":\nError looking up item by metadata reference: " + reference, e);
            }
        }
        if ((csvUUIDs = this.getMatchingCSVUUIDs(reference)).size() > 1) {
            throw new MetadataImportException("Error in CSV row " + this.rowCount + ":\nAmbiguous reference; multiple matches in csv: " + reference);
        }
        if (csvUUIDs.size() == 1) {
            UUID csvUUID = csvUUIDs.iterator().next();
            if (csvUUID.equals(uuid)) {
                return uuid;
            }
            if (uuid != null) {
                throw new MetadataImportException("Error in CSV row " + this.rowCount + ":\nAmbiguous reference; multiple matches in db and csv: " + reference);
            }
            return csvUUID;
        }
        if (uuid == null) {
            throw new MetadataImportException("Error in CSV row " + this.rowCount + ":\nNo matches found for reference: " + reference + "\nKeep in mind you can only reference entries that are listed before this one within the CSV.");
        }
        return uuid;
    }

    private Set<UUID> getMatchingCSVUUIDs(String mdValueRef) {
        HashSet<UUID> set = new HashSet<UUID>();
        if (this.csvRefMap.containsKey(mdValueRef)) {
            for (Integer rowNum : this.csvRefMap.get(mdValueRef)) {
                set.add(this.getUUIDForRow(rowNum));
            }
        }
        return set;
    }

    private UUID getUUIDForRow(int rowNum) {
        if (this.csvRowMap.containsKey(rowNum)) {
            return this.csvRowMap.get(rowNum);
        }
        return new UUID(0L, rowNum);
    }

    private UUID evaluateOriginId(@Nullable UUID originId) {
        if (originId != null) {
            return originId;
        }
        return new UUID(0L, this.rowCount.intValue());
    }

    private void validateExpressedRelations() throws MetadataImportException {
        for (String targetUUID : entityRelationMap.keySet()) {
            String targetType = null;
            try {
                if (entityTypeMap.get(UUID.fromString(targetUUID)) != null) {
                    targetType = this.entityTypeService.findByEntityType(this.c, entityTypeMap.get(UUID.fromString(targetUUID))).getLabel();
                } else {
                    Object targetItem = null;
                    if (this.itemService.find(this.c, UUID.fromString(targetUUID)) != null) {
                        targetItem = (Item)this.itemService.find(this.c, UUID.fromString(targetUUID));
                        List<MetadataValue> relTypes = this.itemService.getMetadata(targetItem, "relationship", "type", null, "*");
                        String relTypeValue = null;
                        if (relTypes.size() > 0) {
                            relTypeValue = relTypes.get(0).getValue();
                            targetType = this.entityTypeService.findByEntityType(this.c, relTypeValue).getLabel();
                        } else {
                            this.relationValidationErrors.add("Cannot resolve Entity type for target UUID: " + targetUUID);
                        }
                    } else {
                        this.relationValidationErrors.add("Cannot resolve Entity type for target UUID: " + targetUUID);
                    }
                }
                if (targetType == null) continue;
                for (String typeName : entityRelationMap.get(targetUUID).keySet()) {
                    for (String originRefererUUID : entityRelationMap.get(targetUUID).get(typeName)) {
                        Object originRow = "N/A";
                        if (this.csvRowMap.containsValue(UUID.fromString(originRefererUUID))) {
                            for (int key : this.csvRowMap.keySet()) {
                                if (!this.csvRowMap.get(key).toString().equalsIgnoreCase(originRefererUUID)) continue;
                                originRow = "" + key;
                                break;
                            }
                        }
                        String originType = "";
                        if (entityTypeMap.get(UUID.fromString(originRefererUUID)) != null) {
                            originType = entityTypeMap.get(UUID.fromString(originRefererUUID));
                            this.validateTypesByTypeByTypeName(targetType, originType, typeName, (String)originRow);
                            continue;
                        }
                        Item originItem = null;
                        if (this.itemService.find(this.c, UUID.fromString(targetUUID)) != null) {
                            originItem = (Item)this.itemService.find(this.c, UUID.fromString(originRefererUUID));
                            List<MetadataValue> relTypes = this.itemService.getMetadata(originItem, "relationship", "type", null, "*");
                            String relTypeValue = null;
                            if (relTypes.size() > 0) {
                                relTypeValue = relTypes.get(0).getValue();
                                originType = this.entityTypeService.findByEntityType(this.c, relTypeValue).getLabel();
                                this.validateTypesByTypeByTypeName(targetType, originType, typeName, (String)originRow);
                                continue;
                            }
                            this.relationValidationErrors.add("Error on CSV row " + (String)originRow + ":\nCannot resolve Entity type for reference: " + originRefererUUID);
                            continue;
                        }
                        this.relationValidationErrors.add("Error on CSV row " + (String)originRow + ":\nCannot resolve Entity type for reference: " + originRefererUUID + " in row: " + (String)originRow);
                    }
                }
            }
            catch (SQLException sqle) {
                throw new MetadataImportException("Error interacting with database!", sqle);
            }
        }
        if (!this.relationValidationErrors.isEmpty()) {
            StringBuilder errors = new StringBuilder();
            for (String error : this.relationValidationErrors) {
                errors.append(error + "\n");
            }
            throw new MetadataImportException("Error validating relationships: \n" + errors);
        }
    }

    private void validateTypesByTypeByTypeName(String targetType, String originType, String typeName, String originRow) throws MetadataImportException {
        try {
            RelationshipType foundRelationshipType = null;
            List<RelationshipType> relationshipTypeList = this.relationshipTypeService.findByLeftwardOrRightwardTypeName(this.c, typeName.split("\\.")[1]);
            foundRelationshipType = this.matchRelationshipType(relationshipTypeList, targetType, originType, typeName);
            if (foundRelationshipType == null) {
                this.relationValidationErrors.add("Error on CSV row " + originRow + ":\nNo Relationship type found for:\nTarget type: " + targetType + "\nOrigin referer type: " + originType + "\nwith typeName: " + typeName + " for type: " + originType);
            }
        }
        catch (SQLException sqle) {
            throw new MetadataImportException("Error interacting with database!", sqle);
        }
    }

    private RelationshipType matchRelationshipType(List<RelationshipType> relTypes, String targetType, String originType, String originTypeName) {
        RelationshipType foundRelationshipType = null;
        if (originTypeName.split("\\.").length > 1) {
            originTypeName = originTypeName.split("\\.")[1];
        }
        for (RelationshipType relationshipType : relTypes) {
            boolean isLeft = false;
            if (relationshipType.getLeftType().getLabel().equalsIgnoreCase(originType)) {
                isLeft = true;
            }
            if (isLeft) {
                if (!relationshipType.getLeftwardType().equalsIgnoreCase(originTypeName) || !relationshipType.getLeftType().getLabel().equalsIgnoreCase(originType) || !relationshipType.getRightType().getLabel().equalsIgnoreCase(targetType)) continue;
                foundRelationshipType = relationshipType;
                continue;
            }
            if (!relationshipType.getRightwardType().equalsIgnoreCase(originTypeName) || !relationshipType.getLeftType().getLabel().equalsIgnoreCase(targetType) || !relationshipType.getRightType().getLabel().equalsIgnoreCase(originType)) continue;
            foundRelationshipType = relationshipType;
        }
        return foundRelationshipType;
    }

    static {
        MetadataImport.setAuthorizedMetadataFields();
        entityTypeMap = new HashMap();
        entityRelationMap = new HashMap();
        log = LogManager.getLogger(MetadataImport.class);
    }
}

