/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.sql.SQLException;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.app.requestitem.dao.RequestItemDAO;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.content.Bitstream;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.springframework.beans.factory.annotation.Autowired;

public class RequestItemServiceImpl
implements RequestItemService {
    private final Logger log = LogManager.getLogger(RequestItemServiceImpl.class);
    @Autowired(required=true)
    protected RequestItemDAO requestItemDAO;

    protected RequestItemServiceImpl() {
    }

    @Override
    public String createRequest(Context context, Bitstream bitstream, Item item, boolean allFiles, String reqEmail, String reqName, String reqMessage) throws SQLException {
        RequestItem requestItem = this.requestItemDAO.create(context, new RequestItem());
        requestItem.setToken(Utils.generateHexKey());
        requestItem.setBitstream(bitstream);
        requestItem.setItem(item);
        requestItem.setAllfiles(allFiles);
        requestItem.setReqEmail(reqEmail);
        requestItem.setReqName(reqName);
        requestItem.setReqMessage(reqMessage);
        requestItem.setRequest_date(new Date());
        this.requestItemDAO.save(context, requestItem);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created requestitem_token " + requestItem.getID() + " with token " + requestItem.getToken() + "\"");
        }
        return requestItem.getToken();
    }

    @Override
    public RequestItem findByToken(Context context, String token) {
        try {
            return this.requestItemDAO.findByToken(context, token);
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
            return null;
        }
    }

    @Override
    public void update(Context context, RequestItem requestItem) {
        try {
            this.requestItemDAO.save(context, requestItem);
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
        }
    }
}

