/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.statistics;

import java.io.File;
import java.io.FileInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.dspace.app.statistics.LogAnalyser;
import org.dspace.app.statistics.ReportGenerator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class CreateStatReport {
    private static Calendar calendar = null;
    private static Calendar reportStartDate = null;
    private static String outputLogDirectory = null;
    private static String outputReportDirectory = null;
    private static String outputSuffix = ".dat";
    private static Context context;
    private static String configFile;

    private CreateStatReport() {
    }

    public static void main(String[] argv) throws Exception {
        FileInputStream fis = new FileInputStream(new File(configFile));
        Properties config = new Properties();
        config.load(fis);
        int startMonth = 0;
        int startYear = 2005;
        try {
            startYear = Integer.parseInt(config.getProperty("start.year", "1").trim());
        }
        catch (NumberFormatException nfe) {
            System.err.println("start.year is incorrectly set in dstat.cfg. Must be a number (e.g. 2005).");
            System.exit(0);
        }
        try {
            startMonth = Integer.parseInt(config.getProperty("start.month", "2005").trim());
        }
        catch (NumberFormatException nfe) {
            System.err.println("start.month is incorrectly set in dstat.cfg. Must be a number between 1 and 12.");
            System.exit(0);
        }
        reportStartDate = new GregorianCalendar(startYear, startMonth - 1, 1);
        calendar = new GregorianCalendar();
        context = new Context();
        context.turnOffAuthorisationSystem();
        outputLogDirectory = ConfigurationManager.getProperty("log.report.dir") + File.separator;
        outputReportDirectory = ConfigurationManager.getProperty("report.dir") + File.separator;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("r", "report", true, "report");
        CommandLine line = parser.parse(options, argv);
        String statAction = null;
        if (line.hasOption('r')) {
            statAction = line.getOptionValue('r');
        }
        if (statAction == null) {
            CreateStatReport.usage();
            System.exit(0);
        }
        if (statAction.equals("stat-monthly")) {
            CreateStatReport.statMonthly();
        }
        if (statAction.equals("stat-general")) {
            CreateStatReport.statGeneral();
        }
        if (statAction.equals("stat-initial")) {
            CreateStatReport.statInitial();
        }
        if (statAction.equals("stat-report-general")) {
            CreateStatReport.statReportGeneral();
        }
        if (statAction.equals("stat-report-initial")) {
            CreateStatReport.statReportInitial();
        }
        if (statAction.equals("stat-report-monthly")) {
            CreateStatReport.statReportMonthly();
        }
    }

    private static void statMonthly() throws Exception {
        String outputPrefix = "dspace-log-monthly-";
        String myLogDir = null;
        String myFileTemplate = null;
        String myConfigFile = null;
        StringBuffer myOutFile = null;
        Date myStartDate = null;
        Date myEndDate = null;
        boolean myLookUp = false;
        GregorianCalendar start = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.getActualMinimum(5));
        myStartDate = start.getTime();
        GregorianCalendar end = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.getActualMaximum(5));
        myEndDate = end.getTime();
        myOutFile = new StringBuffer(outputLogDirectory);
        myOutFile.append(outputPrefix);
        myOutFile.append(calendar.get(1));
        myOutFile.append("-");
        myOutFile.append(calendar.get(2) + 1);
        myOutFile.append(outputSuffix);
        LogAnalyser.processLogs(context, myLogDir, myFileTemplate, myConfigFile, myOutFile.toString(), myStartDate, myEndDate, myLookUp);
    }

    private static void statGeneral() throws Exception {
        String outputPrefix = "dspace-log-general-";
        String myLogDir = null;
        String myFileTemplate = null;
        String myConfigFile = null;
        StringBuffer myOutFile = null;
        Date myStartDate = null;
        Date myEndDate = null;
        boolean myLookUp = false;
        myOutFile = new StringBuffer(outputLogDirectory);
        myOutFile.append(outputPrefix);
        myOutFile.append(calendar.get(1));
        myOutFile.append("-");
        myOutFile.append(calendar.get(2) + 1);
        myOutFile.append("-");
        myOutFile.append(calendar.get(5));
        myOutFile.append(outputSuffix);
        LogAnalyser.processLogs(context, myLogDir, myFileTemplate, myConfigFile, myOutFile.toString(), myStartDate, myEndDate, myLookUp);
    }

    private static void statInitial() throws Exception {
        String outputPrefix = "dspace-log-monthly-";
        String myLogDir = null;
        String myFileTemplate = null;
        String myConfigFile = null;
        StringBuffer myOutFile = null;
        Date myStartDate = null;
        Date myEndDate = null;
        boolean myLookUp = false;
        GregorianCalendar reportEndDate = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.getActualMaximum(5));
        Calendar currentMonth = (Calendar)reportStartDate.clone();
        while (currentMonth.before(reportEndDate)) {
            GregorianCalendar start = new GregorianCalendar(currentMonth.get(1), currentMonth.get(2), currentMonth.getActualMinimum(5));
            myStartDate = start.getTime();
            GregorianCalendar end = new GregorianCalendar(currentMonth.get(1), currentMonth.get(2), currentMonth.getActualMaximum(5));
            myEndDate = end.getTime();
            myOutFile = new StringBuffer(outputLogDirectory);
            myOutFile.append(outputPrefix);
            myOutFile.append(currentMonth.get(1));
            myOutFile.append("-");
            myOutFile.append(currentMonth.get(2) + 1);
            myOutFile.append(outputSuffix);
            LogAnalyser.processLogs(context, myLogDir, myFileTemplate, myConfigFile, myOutFile.toString(), myStartDate, myEndDate, myLookUp);
            currentMonth.add(2, 1);
        }
    }

    private static void statReportGeneral() throws Exception {
        String inputPrefix = "dspace-log-general-";
        String outputPrefix = "report-general-";
        String myFormat = "html";
        StringBuffer myInput = null;
        StringBuffer myOutput = null;
        String myMap = null;
        myInput = new StringBuffer(outputLogDirectory);
        myInput.append(inputPrefix);
        myInput.append(calendar.get(1));
        myInput.append("-");
        myInput.append(calendar.get(2) + 1);
        myInput.append("-");
        myInput.append(calendar.get(5));
        myInput.append(outputSuffix);
        myOutput = new StringBuffer(outputReportDirectory);
        myOutput.append(outputPrefix);
        myOutput.append(calendar.get(1));
        myOutput.append("-");
        myOutput.append(calendar.get(2) + 1);
        myOutput.append("-");
        myOutput.append(calendar.get(5));
        myOutput.append(".");
        myOutput.append(myFormat);
        ReportGenerator.processReport(context, myFormat, myInput.toString(), myOutput.toString(), myMap);
    }

    private static void statReportInitial() throws Exception {
        String inputPrefix = "dspace-log-monthly-";
        String outputPrefix = "report-";
        String myFormat = "html";
        StringBuffer myInput = null;
        StringBuffer myOutput = null;
        String myMap = null;
        GregorianCalendar reportEndDate = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.getActualMaximum(5));
        Calendar currentMonth = (Calendar)reportStartDate.clone();
        while (currentMonth.before(reportEndDate)) {
            myInput = new StringBuffer(outputLogDirectory);
            myInput.append(inputPrefix);
            myInput.append(currentMonth.get(1));
            myInput.append("-");
            myInput.append(currentMonth.get(2) + 1);
            myInput.append(outputSuffix);
            myOutput = new StringBuffer(outputReportDirectory);
            myOutput.append(outputPrefix);
            myOutput.append(currentMonth.get(1));
            myOutput.append("-");
            myOutput.append(currentMonth.get(2) + 1);
            myOutput.append(".");
            myOutput.append(myFormat);
            ReportGenerator.processReport(context, myFormat, myInput.toString(), myOutput.toString(), myMap);
            currentMonth.add(2, 1);
        }
    }

    private static void statReportMonthly() throws Exception {
        String inputPrefix = "dspace-log-monthly-";
        String outputPrefix = "report-";
        String myFormat = "html";
        StringBuffer myInput = null;
        StringBuffer myOutput = null;
        String myMap = null;
        myInput = new StringBuffer(outputLogDirectory);
        myInput.append(inputPrefix);
        myInput.append(calendar.get(1));
        myInput.append("-");
        myInput.append(calendar.get(2) + 1);
        myInput.append(outputSuffix);
        myOutput = new StringBuffer(outputReportDirectory);
        myOutput.append(outputPrefix);
        myOutput.append(calendar.get(1));
        myOutput.append("-");
        myOutput.append(calendar.get(2) + 1);
        myOutput.append(".");
        myOutput.append(myFormat);
        ReportGenerator.processReport(context, myFormat, myInput.toString(), myOutput.toString(), myMap);
    }

    private static void usage() throws Exception {
        System.out.println("Usage: java CreateStatReport -r <statistic to run>");
        System.out.println("Available: <stat-initial> <stat-general> <stat-monthly> <stat-report-initial> <stat-report-general> <stat-report-monthly>");
    }

    static {
        configFile = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "dstat.cfg";
    }
}

