/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import com.ibm.icu.text.CollationElementIterator;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.text.filter.TextFilter;

public class LocaleOrderingFilter
implements TextFilter {
    private static Logger log = LogManager.getLogger(LocaleOrderingFilter.class);

    @Override
    public String filter(String str) {
        RuleBasedCollator collator = LocaleOrderingFilter.getCollator();
        if (collator != null) {
            int element;
            StringBuffer buf = new StringBuffer();
            CollationElementIterator iter = collator.getCollationElementIterator(str);
            while ((element = iter.next()) != -1) {
                String test = Integer.toString(element, 16);
                buf.append(test);
            }
            return buf.toString();
        }
        return str;
    }

    @Override
    public String filter(String str, String lang) {
        return this.filter(str);
    }

    private static RuleBasedCollator getCollator() {
        RuleBasedCollator collator;
        Locale locale = LocaleOrderingFilter.getSortLocale();
        if (locale != null && (collator = (RuleBasedCollator)Collator.getInstance((Locale)locale)) != null) {
            return collator;
        }
        return null;
    }

    private static Locale getSortLocale() {
        Locale theLocale = null;
        String locale = ConfigurationManager.getProperty("webui.browse.sort.locale");
        if (locale != null) {
            String[] localeArr = locale.split("_");
            theLocale = localeArr.length > 1 ? new Locale(localeArr[0], localeArr[1]) : new Locale(locale);
            if (theLocale == null) {
                log.warn("Could not create the supplied Locale: webui.browse.sort.locale=" + locale);
                return Locale.ENGLISH;
            }
        } else {
            return Locale.ENGLISH;
        }
        return theLocale;
    }
}

