/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.MetadataValue;
import org.dspace.core.ReloadableEntity;
import org.dspace.handle.Handle;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="dspaceobject")
public abstract class DSpaceObject
implements Serializable,
ReloadableEntity<UUID> {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @Column(name="uuid", unique=true, nullable=false, insertable=true, updatable=false)
    protected UUID id;
    @Transient
    private StringBuffer eventDetails = null;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="dSpaceObject", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="metadataField, place")
    private List<MetadataValue> metadata = new ArrayList<MetadataValue>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="dso")
    @OrderBy(value="id ASC")
    private List<Handle> handles = new ArrayList<Handle>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="dSpaceObject", cascade={CascadeType.ALL})
    private List<ResourcePolicy> resourcePolicies = new ArrayList<ResourcePolicy>();
    @Transient
    private boolean modifiedMetadata = false;
    @Transient
    private boolean modified = false;

    protected DSpaceObject() {
    }

    public void clearDetails() {
        this.eventDetails = null;
    }

    protected void addDetails(String d) {
        if (this.eventDetails == null) {
            this.eventDetails = new StringBuffer(d);
        } else {
            this.eventDetails.append(", ").append(d);
        }
    }

    public String getDetails() {
        return this.eventDetails == null ? null : this.eventDetails.toString();
    }

    public abstract int getType();

    @Override
    public UUID getID() {
        return this.id;
    }

    public abstract String getName();

    public String getHandle() {
        return CollectionUtils.isNotEmpty(this.handles) ? this.handles.get(0).getHandle() : null;
    }

    void setHandle(List<Handle> handle) {
        this.handles = handle;
    }

    public void addHandle(Handle handle) {
        this.handles.add(handle);
    }

    public List<Handle> getHandles() {
        return this.handles;
    }

    public List<MetadataValue> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<MetadataValue> metadata) {
        this.metadata = metadata;
    }

    protected void removeMetadata(MetadataValue metadataValue) {
        this.setMetadataModified();
        this.getMetadata().remove(metadataValue);
    }

    protected void removeMetadata(List<MetadataValue> metadataValues) {
        this.setMetadataModified();
        this.getMetadata().removeAll(metadataValues);
    }

    protected void addMetadata(MetadataValue metadataValue) {
        this.setMetadataModified();
        this.getMetadata().add(metadataValue);
        this.addDetails(metadataValue.getMetadataField().toString());
    }

    public List<ResourcePolicy> getResourcePolicies() {
        return this.resourcePolicies;
    }

    public boolean isMetadataModified() {
        return this.modifiedMetadata;
    }

    protected void setMetadataModified() {
        this.modifiedMetadata = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void clearModified() {
        this.modified = false;
    }

    protected void setModified() {
        this.modified = true;
    }
}

