/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.SiteService;
import org.dspace.core.ConfigurationManager;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name="site")
public class Site
extends DSpaceObject {
    @Transient
    private transient SiteService siteService;

    protected Site() {
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public String getName() {
        return this.getSiteService().getName(this);
    }

    public String getURL() {
        return ConfigurationManager.getProperty("dspace.ui.url");
    }

    private SiteService getSiteService() {
        if (this.siteService == null) {
            this.siteService = ContentServiceFactory.getInstance().getSiteService();
        }
        return this.siteService;
    }
}

