/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.StreamDisseminationCrosswalk;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.license.factory.LicenseServiceFactory;
import org.dspace.license.service.CreativeCommonsService;

public class CreativeCommonsTextStreamDisseminationCrosswalk
implements StreamDisseminationCrosswalk {
    protected final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected final CreativeCommonsService creativeCommonsService = LicenseServiceFactory.getInstance().getCreativeCommonsService();
    private static Logger log = LogManager.getLogger(CreativeCommonsTextStreamDisseminationCrosswalk.class);

    @Override
    public boolean canDisseminate(Context context, DSpaceObject dso) {
        try {
            return dso.getType() == 2 && this.creativeCommonsService.getLicenseTextBitstream((Item)dso) != null;
        }
        catch (Exception e) {
            log.error("Failed getting CC license", (Throwable)e);
            return false;
        }
    }

    @Override
    public void disseminate(Context context, DSpaceObject dso, OutputStream out) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Bitstream cc;
        if (dso.getType() == 2 && (cc = this.creativeCommonsService.getLicenseTextBitstream((Item)dso)) != null) {
            Utils.copy(this.bitstreamService.retrieve(context, cc), out);
            out.close();
        }
    }

    @Override
    public String getMIMEType() {
        return "text/plain";
    }
}

