/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class METSDisseminationCrosswalk
implements DisseminationCrosswalk {
    private static final String METS_PACKAGER_PLUGIN = "METS";
    public static final Namespace MODS_NS = Namespace.getNamespace((String)"mods", (String)"http://www.loc.gov/mods/v3");
    private static final Namespace XLINK_NS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/TR/xlink");
    private static final Namespace METS_NS = Namespace.getNamespace((String)"mets", (String)"http://www.loc.gov/METS/");
    private static final Namespace[] namespaces = new Namespace[]{METS_NS, MODS_NS, XLINK_NS};
    private static final String METS_XSD = "http://www.loc.gov/standards/mets/mets.xsd";
    private static final String schemaLocation = METS_NS.getURI() + " http://www.loc.gov/standards/mets/mets.xsd";

    @Override
    public Namespace[] getNamespaces() {
        return (Namespace[])ArrayUtils.clone((Object[])namespaces);
    }

    @Override
    public String getSchemaLocation() {
        return schemaLocation;
    }

    @Override
    public List<Element> disseminateList(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        ArrayList<Element> result = new ArrayList<Element>(1);
        result.add(this.disseminateElement(context, dso));
        return result;
    }

    @Override
    public Element disseminateElement(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (!this.canDisseminate(dso)) {
            throw new CrosswalkObjectNotSupported("METSDisseminationCrosswalk cannot disseminate a DSpaceObject of type: " + Constants.typeText[dso.getType()]);
        }
        PackageDisseminator dip = (PackageDisseminator)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(PackageDisseminator.class, METS_PACKAGER_PLUGIN);
        if (dip == null) {
            throw new CrosswalkInternalException("Cannot find a disseminate plugin for package=METS");
        }
        try {
            PackageParameters pparams = new PackageParameters();
            pparams.put("manifestOnly", "true");
            String tempDirectory = ConfigurationManager.getProperty("upload.temp.dir") != null ? ConfigurationManager.getProperty("upload.temp.dir") : System.getProperty("java.io.tmpdir");
            File tempFile = File.createTempFile("METSDissemination" + dso.hashCode(), null, new File(tempDirectory));
            tempFile.deleteOnExit();
            dip.disseminate(context, dso, pparams, tempFile);
            try {
                SAXBuilder builder = new SAXBuilder();
                Document metsDocument = builder.build(tempFile);
                return metsDocument.getRootElement();
            }
            catch (JDOMException je) {
                throw new MetadataValidationException("Error parsing METS (see wrapped error message for more details) ", je);
            }
        }
        catch (PackageException pe) {
            throw new CrosswalkInternalException("Failed making METS manifest in packager (see wrapped error message for more details) ", pe);
        }
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 5 || dso.getType() == 4 || dso.getType() == 3 || dso.getType() == 2;
    }

    @Override
    public boolean preferList() {
        return false;
    }
}

