/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class PREMISCrosswalk
implements IngestionCrosswalk,
DisseminationCrosswalk {
    private static Logger log = LogManager.getLogger(PREMISCrosswalk.class);
    private static final Namespace PREMIS_NS = Namespace.getNamespace((String)"premis", (String)"http://www.loc.gov/standards/premis");
    private String schemaLocation = PREMIS_NS.getURI() + " http://www.loc.gov/standards/premis/PREMIS-v1-0.xsd";
    private static final Namespace[] namespaces = new Namespace[]{PREMIS_NS};
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();

    @Override
    public void ingest(Context context, DSpaceObject dso, Element root, boolean createMissingMetadataFields) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (!root.getName().equals("premis")) {
            throw new MetadataValidationException("Wrong root element for PREMIS: " + root.toString());
        }
        this.ingest(context, dso, root.getChildren(), createMissingMetadataFields);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void ingest(Context context, DSpaceObject dso, List<Element> ml, boolean createMissingMetadataFields) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 0) {
            throw new CrosswalkObjectNotSupported("Wrong target object type, PREMISCrosswalk can only crosswalk to a Bitstream.");
        }
        Bitstream bitstream = (Bitstream)dso;
        String MIMEType = null;
        String bsName = null;
        for (Element me : ml) {
            if (me.getName().equals("premis")) {
                this.ingest(context, dso, me.getChildren(), createMissingMetadataFields);
                continue;
            }
            if (me.getName().equals("object")) {
                BitstreamFormat bf;
                Element oc;
                Element on = me.getChild("originalName", PREMIS_NS);
                if (on != null) {
                    bsName = on.getTextTrim();
                }
                if ((oc = me.getChild("objectCharacteristics", PREMIS_NS)) != null) {
                    Element fd;
                    Element format;
                    Element fixity;
                    String ssize = oc.getChildTextTrim("size", PREMIS_NS);
                    if (ssize != null) {
                        try {
                            int size = Integer.parseInt(ssize);
                            if (bitstream.getSizeBytes() != (long)size) {
                                throw new MetadataValidationException("Bitstream size (" + String.valueOf(bitstream.getSizeBytes()) + ") does not match size in PREMIS (" + ssize + "), rejecting it.");
                            }
                        }
                        catch (NumberFormatException ne) {
                            throw new MetadataValidationException("Bad number value in PREMIS object/objectCharacteristics/size: " + ssize, ne);
                        }
                    }
                    if ((fixity = oc.getChild("fixity", PREMIS_NS)) != null) {
                        String alg = fixity.getChildTextTrim("messageDigestAlgorithm", PREMIS_NS);
                        String md = fixity.getChildTextTrim("messageDigest", PREMIS_NS);
                        String b_alg = bitstream.getChecksumAlgorithm();
                        String b_md = bitstream.getChecksum();
                        if (StringUtils.equals((CharSequence)alg, (CharSequence)b_alg)) {
                            if (!StringUtils.equals((CharSequence)md, (CharSequence)b_md)) throw new MetadataValidationException("Bitstream " + alg + " Checksum does not match value in PREMIS (" + b_md + " != " + md + "), for bitstream: " + bitstream.getName());
                            log.debug("Bitstream checksum agrees with PREMIS: " + bitstream.getName());
                        } else {
                            log.warn("Cannot test checksum on bitstream=" + bitstream.getName() + ", algorithm in PREMIS is different: " + alg);
                        }
                    }
                    if ((format = oc.getChild("format", PREMIS_NS)) != null && (fd = format.getChild("formatDesignation", PREMIS_NS)) != null) {
                        MIMEType = fd.getChildTextTrim("formatName", PREMIS_NS);
                    }
                }
                if (bsName != null) {
                    bitstream.setName(context, bsName);
                    log.debug("Changing bitstream id=" + String.valueOf(bitstream.getID()) + "name and source to: " + bsName);
                }
                BitstreamFormat bitstreamFormat = bf = MIMEType == null ? null : this.bitstreamFormatService.findByMIMEType(context, MIMEType);
                if (bf == null) {
                    bf = this.bitstreamFormatService.guessFormat(context, bitstream);
                }
                if (bf == null) continue;
                bitstream.setFormat(context, bf);
                continue;
            }
            log.debug("Skipping element: " + me.toString());
        }
        this.bitstreamService.update(context, bitstream);
    }

    @Override
    public Namespace[] getNamespaces() {
        return (Namespace[])ArrayUtils.clone((Object[])namespaces);
    }

    @Override
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 0;
    }

    @Override
    public Element disseminateElement(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Object bsName;
        List<Item> bi;
        if (dso.getType() != 0) {
            throw new CrosswalkObjectNotSupported("PREMISCrosswalk can only crosswalk a Bitstream.");
        }
        Bitstream bitstream = (Bitstream)dso;
        Element premis = new Element("premis", PREMIS_NS);
        Element object = new Element("object", PREMIS_NS);
        premis.addContent((Content)object);
        Element oid = new Element("objectIdentifier", PREMIS_NS);
        Element oit = new Element("objectIdentifierType", PREMIS_NS);
        oit.setText("URL");
        oid.addContent((Content)oit);
        Element oiv = new Element("objectIdentifierValue", PREMIS_NS);
        String sid = String.valueOf(bitstream.getSequenceID());
        String baseUrl = ConfigurationManager.getProperty("dspace.ui.url");
        String handle = null;
        List<Bundle> bn = bitstream.getBundles();
        if (bn.size() > 0 && (bi = bn.get(0).getItems()).size() > 0) {
            handle = bi.get(0).getHandle();
        }
        if ((bsName = bitstream.getName()) == null) {
            List<String> ext = bitstream.getFormat(context).getExtensions();
            bsName = "bitstream_" + sid + (ext.size() > 0 ? ext.get(0) : "");
        }
        if (handle != null && baseUrl != null) {
            oiv.setText(baseUrl + "/bitstream/" + URLEncoder.encode(handle, "UTF-8") + "/" + sid + "/" + URLEncoder.encode((String)bsName, "UTF-8"));
        } else {
            oiv.setText(URLEncoder.encode((String)bsName, "UTF-8"));
        }
        oid.addContent((Content)oiv);
        object.addContent((Content)oid);
        Element oc = new Element("objectCategory", PREMIS_NS);
        oc.setText("File");
        object.addContent((Content)oc);
        Element ochar = new Element("objectCharacteristics", PREMIS_NS);
        object.addContent((Content)ochar);
        String cks = bitstream.getChecksum();
        String cka = bitstream.getChecksumAlgorithm();
        if (cks != null && cka != null) {
            Element fixity = new Element("fixity", PREMIS_NS);
            Element mda = new Element("messageDigestAlgorithm", PREMIS_NS);
            mda.setText(cka);
            fixity.addContent((Content)mda);
            Element md = new Element("messageDigest", PREMIS_NS);
            md.setText(cks);
            fixity.addContent((Content)md);
            ochar.addContent((Content)fixity);
        }
        Element size = new Element("size", PREMIS_NS);
        size.setText(String.valueOf(bitstream.getSizeBytes()));
        ochar.addContent((Content)size);
        Element format = new Element("format", PREMIS_NS);
        Element formatDes = new Element("formatDesignation", PREMIS_NS);
        Element formatName = new Element("formatName", PREMIS_NS);
        formatName.setText(bitstream.getFormat(context).getMIMEType());
        formatDes.addContent((Content)formatName);
        format.addContent((Content)formatDes);
        ochar.addContent((Content)format);
        String oname = bitstream.getName();
        if (oname == null) {
            oname = bitstream.getSource();
        }
        if (oname != null) {
            Element on = new Element("originalName", PREMIS_NS);
            on.setText(oname);
            object.addContent((Content)on);
        }
        return premis;
    }

    @Override
    public List<Element> disseminateList(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        ArrayList<Element> result = new ArrayList<Element>(1);
        result.add(this.disseminateElement(context, dso));
        return result;
    }

    @Override
    public boolean preferList() {
        return false;
    }
}

