/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataField_;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataSchema_;
import org.dspace.content.dao.MetadataFieldDAO;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;

public class MetadataFieldDAOImpl
extends AbstractHibernateDAO<MetadataField>
implements MetadataFieldDAO {
    protected MetadataFieldDAOImpl() {
    }

    @Override
    public MetadataField find(Context context, int metadataFieldId, MetadataSchema metadataSchema, String element, String qualifier) throws SQLException {
        Query query = qualifier != null ? this.createQuery(context, "SELECT mf FROM MetadataField mf JOIN FETCH mf.metadataSchema ms WHERE mf.id != :id AND ms.name = :name AND mf.element = :element AND qualifier = :qualifier") : this.createQuery(context, "SELECT mf FROM MetadataField mf JOIN FETCH mf.metadataSchema ms WHERE mf.id != :id AND ms.name = :name AND mf.element = :element AND mf.qualifier IS NULL");
        query.setParameter("id", (Object)metadataFieldId);
        query.setParameter("name", (Object)metadataSchema.getName());
        query.setParameter("element", (Object)element);
        if (qualifier != null) {
            query.setParameter("qualifier", (Object)qualifier);
        }
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return (MetadataField)this.singleResult(query);
    }

    @Override
    public MetadataField findByElement(Context context, MetadataSchema metadataSchema, String element, String qualifier) throws SQLException {
        return this.findByElement(context, metadataSchema.getName(), element, qualifier);
    }

    @Override
    public MetadataField findByElement(Context context, String metadataSchema, String element, String qualifier) throws SQLException {
        Query query = StringUtils.isNotBlank((CharSequence)qualifier) ? this.createQuery(context, "SELECT mf FROM MetadataField mf JOIN FETCH mf.metadataSchema ms WHERE ms.name = :name AND mf.element = :element AND qualifier = :qualifier") : this.createQuery(context, "SELECT mf FROM MetadataField mf JOIN FETCH mf.metadataSchema ms WHERE ms.name = :name AND mf.element = :element AND mf.qualifier IS NULL");
        query.setParameter("name", (Object)metadataSchema);
        query.setParameter("element", (Object)element);
        if (StringUtils.isNotBlank((CharSequence)qualifier)) {
            query.setParameter("qualifier", (Object)qualifier);
        }
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return (MetadataField)this.singleResult(query);
    }

    @Override
    public List<MetadataField> findAll(Context context, Class<MetadataField> clazz) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<MetadataField> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, MetadataField.class);
        Root metadataFieldRoot = criteriaQuery.from(MetadataField.class);
        Join join = metadataFieldRoot.join("metadataSchema");
        criteriaQuery.select((Selection)metadataFieldRoot);
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)join.get(MetadataSchema_.name)));
        orderList.add(criteriaBuilder.asc((Expression)metadataFieldRoot.get(MetadataField_.element)));
        orderList.add(criteriaBuilder.asc((Expression)metadataFieldRoot.get(MetadataField_.qualifier)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, true, MetadataField.class, -1, -1, false);
    }

    @Override
    public List<MetadataField> findFieldsByElementNameUnqualified(Context context, String metadataSchema, String element) throws SQLException {
        Query query = this.createQuery(context, "SELECT mf FROM MetadataField mf JOIN FETCH mf.metadataSchema ms WHERE ms.name = :name AND mf.element = :element ");
        query.setParameter("name", (Object)metadataSchema);
        query.setParameter("element", (Object)element);
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return this.list(query);
    }

    @Override
    public List<MetadataField> findAllInSchema(Context context, MetadataSchema metadataSchema) throws SQLException {
        Query query = this.createQuery(context, "SELECT mf FROM MetadataField mf JOIN FETCH mf.metadataSchema ms WHERE ms.name = :name ORDER BY mf.element ASC, mf.qualifier ASC ");
        query.setParameter("name", (Object)metadataSchema.getName());
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return this.list(query);
    }
}

