/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.scripts;

import java.sql.SQLException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public abstract class DSpaceRunnable
implements Runnable {
    private String name;
    private String description;
    protected CommandLine commandLine;
    protected Options options;
    protected DSpaceRunnableHandler handler;
    @Autowired
    private AuthorizeService authorizeService;

    public String getName() {
        return this.name;
    }

    @Required
    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    @Required
    public void setDescription(String description) {
        this.description = description;
    }

    public Options getOptions() {
        return this.options;
    }

    private void parse(String[] args) throws ParseException {
        this.commandLine = new DefaultParser().parse(this.getOptions(), args);
        this.setup();
    }

    public void printHelp() {
        this.handler.printHelp(this.options, this.name);
    }

    @Override
    public void run() {
        try {
            this.handler.start();
            this.internalRun();
            this.handler.handleCompletion();
        }
        catch (Exception e) {
            this.handler.handleException(e);
        }
    }

    private void setHandler(DSpaceRunnableHandler dSpaceRunnableHandler) {
        this.handler = dSpaceRunnableHandler;
    }

    public void initialize(String[] args, DSpaceRunnableHandler dSpaceRunnableHandler) throws ParseException {
        this.setHandler(dSpaceRunnableHandler);
        this.parse(args);
    }

    public abstract void internalRun() throws Exception;

    public abstract void setup() throws ParseException;

    public boolean isAllowedToExecute(Context context) {
        try {
            return this.authorizeService.isAdmin(context);
        }
        catch (SQLException e) {
            this.handler.logError("Error occured when trying to verify permissions for script: " + this.name);
            return false;
        }
    }
}

